@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage the accepter's side of a Direct Connect hosted public virtual interface.
 * This resource accepts ownership of a public virtual interface created by another AWS account.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.directconnect.HostedPublicVirtualInterface;
 * import com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceArgs;
 * import com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceAccepter;
 * import com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accepter = new Provider("accepter");
 *         final var accepterCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var creator = new HostedPublicVirtualInterface("creator", HostedPublicVirtualInterfaceArgs.builder()
 *             .connectionId("dxcon-zzzzzzzz")
 *             .ownerAccountId(accepterCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .vlan(4094)
 *             .addressFamily("ipv4")
 *             .bgpAsn(65352)
 *             .customerAddress("175.45.176.1/30")
 *             .amazonAddress("175.45.176.2/30")
 *             .routeFilterPrefixes(
 *                 "210.52.109.0/24",
 *                 "175.45.176.0/22")
 *             .build());
 *         var accepterHostedPublicVirtualInterfaceAccepter = new HostedPublicVirtualInterfaceAccepter("accepterHostedPublicVirtualInterfaceAccepter", HostedPublicVirtualInterfaceAccepterArgs.builder()
 *             .virtualInterfaceId(creator.id())
 *             .tags(Map.of("Side", "Accepter"))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.accepter())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Direct Connect hosted public virtual interfaces using the VIF `id`. For example:
 * ```sh
 *  $ pulumi import aws:directconnect/hostedPublicVirtualInterfaceAccepter:HostedPublicVirtualInterfaceAccepter test dxvif-33cc44dd
 * ```
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property virtualInterfaceId The ID of the Direct Connect virtual interface to accept.
 */
public data class HostedPublicVirtualInterfaceAccepterArgs(
    public val tags: Output<Map<String, String>>? = null,
    public val virtualInterfaceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceAccepterArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceAccepterArgs =
        com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceAccepterArgs.builder()
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualInterfaceId(virtualInterfaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HostedPublicVirtualInterfaceAccepterArgs].
 */
@PulumiTagMarker
public class HostedPublicVirtualInterfaceAccepterArgsBuilder internal constructor() {
    private var tags: Output<Map<String, String>>? = null

    private var virtualInterfaceId: Output<String>? = null

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("migcjxurrvuqucdy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the Direct Connect virtual interface to accept.
     */
    @JvmName("efggfjtgulexmxfo")
    public suspend fun virtualInterfaceId(`value`: Output<String>) {
        this.virtualInterfaceId = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rqgdtgdddnqdciok")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cynebkcxmrpsvpxa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the Direct Connect virtual interface to accept.
     */
    @JvmName("bcruphscyfqogdcp")
    public suspend fun virtualInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualInterfaceId = mapped
    }

    internal fun build(): HostedPublicVirtualInterfaceAccepterArgs =
        HostedPublicVirtualInterfaceAccepterArgs(
            tags = tags,
            virtualInterfaceId = virtualInterfaceId,
        )
}
