@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Direct Connect hosted public virtual interface resource. This resource represents the allocator's side of the hosted virtual interface.
 * A hosted virtual interface is a virtual interface that is owned by another AWS account.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.HostedPublicVirtualInterface;
 * import com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new HostedPublicVirtualInterface("foo", HostedPublicVirtualInterfaceArgs.builder()
 *             .addressFamily("ipv4")
 *             .amazonAddress("175.45.176.2/30")
 *             .bgpAsn(65352)
 *             .connectionId("dxcon-zzzzzzzz")
 *             .customerAddress("175.45.176.1/30")
 *             .routeFilterPrefixes(
 *                 "210.52.109.0/24",
 *                 "175.45.176.0/22")
 *             .vlan(4094)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Direct Connect hosted public virtual interfaces using the VIF `id`. For example:
 * ```sh
 *  $ pulumi import aws:directconnect/hostedPublicVirtualInterface:HostedPublicVirtualInterface test dxvif-33cc44dd
 * ```
 * @property addressFamily The address family for the BGP peer. `ipv4 ` or `ipv6`.
 * @property amazonAddress The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
 * @property bgpAsn The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
 * @property bgpAuthKey The authentication key for BGP configuration.
 * @property connectionId The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
 * @property customerAddress The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
 * @property name The name for the virtual interface.
 * @property ownerAccountId The AWS account that will own the new virtual interface.
 * @property routeFilterPrefixes A list of routes to be advertised to the AWS network in this region.
 * @property vlan The VLAN ID.
 */
public data class HostedPublicVirtualInterfaceArgs(
    public val addressFamily: Output<String>? = null,
    public val amazonAddress: Output<String>? = null,
    public val bgpAsn: Output<Int>? = null,
    public val bgpAuthKey: Output<String>? = null,
    public val connectionId: Output<String>? = null,
    public val customerAddress: Output<String>? = null,
    public val name: Output<String>? = null,
    public val ownerAccountId: Output<String>? = null,
    public val routeFilterPrefixes: Output<List<String>>? = null,
    public val vlan: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceArgs =
        com.pulumi.aws.directconnect.HostedPublicVirtualInterfaceArgs.builder()
            .addressFamily(addressFamily?.applyValue({ args0 -> args0 }))
            .amazonAddress(amazonAddress?.applyValue({ args0 -> args0 }))
            .bgpAsn(bgpAsn?.applyValue({ args0 -> args0 }))
            .bgpAuthKey(bgpAuthKey?.applyValue({ args0 -> args0 }))
            .connectionId(connectionId?.applyValue({ args0 -> args0 }))
            .customerAddress(customerAddress?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ownerAccountId(ownerAccountId?.applyValue({ args0 -> args0 }))
            .routeFilterPrefixes(routeFilterPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vlan(vlan?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HostedPublicVirtualInterfaceArgs].
 */
@PulumiTagMarker
public class HostedPublicVirtualInterfaceArgsBuilder internal constructor() {
    private var addressFamily: Output<String>? = null

    private var amazonAddress: Output<String>? = null

    private var bgpAsn: Output<Int>? = null

    private var bgpAuthKey: Output<String>? = null

    private var connectionId: Output<String>? = null

    private var customerAddress: Output<String>? = null

    private var name: Output<String>? = null

    private var ownerAccountId: Output<String>? = null

    private var routeFilterPrefixes: Output<List<String>>? = null

    private var vlan: Output<Int>? = null

    /**
     * @param value The address family for the BGP peer. `ipv4 ` or `ipv6`.
     */
    @JvmName("uqhjmloggxwfsjaq")
    public suspend fun addressFamily(`value`: Output<String>) {
        this.addressFamily = value
    }

    /**
     * @param value The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
     */
    @JvmName("dfcttofpplvgssig")
    public suspend fun amazonAddress(`value`: Output<String>) {
        this.amazonAddress = value
    }

    /**
     * @param value The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    @JvmName("xogtgvbtwkkchurf")
    public suspend fun bgpAsn(`value`: Output<Int>) {
        this.bgpAsn = value
    }

    /**
     * @param value The authentication key for BGP configuration.
     */
    @JvmName("fronlrnkpkhsurgj")
    public suspend fun bgpAuthKey(`value`: Output<String>) {
        this.bgpAuthKey = value
    }

    /**
     * @param value The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
     */
    @JvmName("flqhuchcmrtuwwyp")
    public suspend fun connectionId(`value`: Output<String>) {
        this.connectionId = value
    }

    /**
     * @param value The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
     */
    @JvmName("bnlensxfvvnqwwyl")
    public suspend fun customerAddress(`value`: Output<String>) {
        this.customerAddress = value
    }

    /**
     * @param value The name for the virtual interface.
     */
    @JvmName("mvidotaortrwraui")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The AWS account that will own the new virtual interface.
     */
    @JvmName("dkpebwicfbsoywnu")
    public suspend fun ownerAccountId(`value`: Output<String>) {
        this.ownerAccountId = value
    }

    /**
     * @param value A list of routes to be advertised to the AWS network in this region.
     */
    @JvmName("wxblgthehevemwoq")
    public suspend fun routeFilterPrefixes(`value`: Output<List<String>>) {
        this.routeFilterPrefixes = value
    }

    @JvmName("cifmvxaxnmbpokwa")
    public suspend fun routeFilterPrefixes(vararg values: Output<String>) {
        this.routeFilterPrefixes = Output.all(values.asList())
    }

    /**
     * @param values A list of routes to be advertised to the AWS network in this region.
     */
    @JvmName("wmesgskucmlqqsoi")
    public suspend fun routeFilterPrefixes(values: List<Output<String>>) {
        this.routeFilterPrefixes = Output.all(values)
    }

    /**
     * @param value The VLAN ID.
     */
    @JvmName("eytynonstamtcjas")
    public suspend fun vlan(`value`: Output<Int>) {
        this.vlan = value
    }

    /**
     * @param value The address family for the BGP peer. `ipv4 ` or `ipv6`.
     */
    @JvmName("tbkswemddkabcwpd")
    public suspend fun addressFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressFamily = mapped
    }

    /**
     * @param value The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
     */
    @JvmName("ewsbawrpihjlrcrg")
    public suspend fun amazonAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amazonAddress = mapped
    }

    /**
     * @param value The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    @JvmName("axwslrscoybwxjby")
    public suspend fun bgpAsn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpAsn = mapped
    }

    /**
     * @param value The authentication key for BGP configuration.
     */
    @JvmName("vjhmpywvuvgiqcjc")
    public suspend fun bgpAuthKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpAuthKey = mapped
    }

    /**
     * @param value The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
     */
    @JvmName("xdsicykokaasrdgy")
    public suspend fun connectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionId = mapped
    }

    /**
     * @param value The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
     */
    @JvmName("lamdcdigwsbcbkqv")
    public suspend fun customerAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerAddress = mapped
    }

    /**
     * @param value The name for the virtual interface.
     */
    @JvmName("utmnpmdtdlycroho")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The AWS account that will own the new virtual interface.
     */
    @JvmName("suvbrcggmilkhqux")
    public suspend fun ownerAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerAccountId = mapped
    }

    /**
     * @param value A list of routes to be advertised to the AWS network in this region.
     */
    @JvmName("pkvpydkryjkeuvcg")
    public suspend fun routeFilterPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeFilterPrefixes = mapped
    }

    /**
     * @param values A list of routes to be advertised to the AWS network in this region.
     */
    @JvmName("tepcgdtqhetnjing")
    public suspend fun routeFilterPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeFilterPrefixes = mapped
    }

    /**
     * @param value The VLAN ID.
     */
    @JvmName("tghjdgveeglssbgs")
    public suspend fun vlan(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlan = mapped
    }

    internal fun build(): HostedPublicVirtualInterfaceArgs = HostedPublicVirtualInterfaceArgs(
        addressFamily = addressFamily,
        amazonAddress = amazonAddress,
        bgpAsn = bgpAsn,
        bgpAuthKey = bgpAuthKey,
        connectionId = connectionId,
        customerAddress = customerAddress,
        name = name,
        ownerAccountId = ownerAccountId,
        routeFilterPrefixes = routeFilterPrefixes,
        vlan = vlan,
    )
}
