@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [HostedTransitVirtualInterfaceAcceptor].
 */
@PulumiTagMarker
public class HostedTransitVirtualInterfaceAcceptorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HostedTransitVirtualInterfaceAcceptorArgs =
        HostedTransitVirtualInterfaceAcceptorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend HostedTransitVirtualInterfaceAcceptorArgsBuilder.() -> Unit) {
        val builder = HostedTransitVirtualInterfaceAcceptorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): HostedTransitVirtualInterfaceAcceptor {
        val builtJavaResource =
            com.pulumi.aws.directconnect.HostedTransitVirtualInterfaceAcceptor(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HostedTransitVirtualInterfaceAcceptor(builtJavaResource)
    }
}

/**
 * Provides a resource to manage the accepter's side of a Direct Connect hosted transit virtual interface.
 * This resource accepts ownership of a transit virtual interface created by another AWS account.
 * > **NOTE:** AWS allows a Direct Connect hosted transit virtual interface to be deleted from either the allocator's or accepter's side. However, this provider only allows the Direct Connect hosted transit virtual interface to be deleted from the allocator's side by removing the corresponding `aws.directconnect.HostedTransitVirtualInterface` resource from your configuration. Removing a `aws.directconnect.HostedTransitVirtualInterfaceAcceptor` resource from your configuration will remove it from your statefile and management, **but will not delete the Direct Connect virtual interface.**
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.Provider;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.directconnect.Gateway;
 * import com.pulumi.aws.directconnect.GatewayArgs;
 * import com.pulumi.aws.directconnect.HostedTransitVirtualInterface;
 * import com.pulumi.aws.directconnect.HostedTransitVirtualInterfaceArgs;
 * import com.pulumi.aws.directconnect.HostedTransitVirtualInterfaceAcceptor;
 * import com.pulumi.aws.directconnect.HostedTransitVirtualInterfaceAcceptorArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var accepter = new Provider("accepter");
 *         final var accepterCallerIdentity = AwsFunctions.getCallerIdentity();
 *         var example = new Gateway("example", GatewayArgs.builder()
 *             .amazonSideAsn(64512)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.accepter())
 *                 .build());
 *         var creator = new HostedTransitVirtualInterface("creator", HostedTransitVirtualInterfaceArgs.builder()
 *             .connectionId("dxcon-zzzzzzzz")
 *             .ownerAccountId(accepterCallerIdentity.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *             .vlan(4094)
 *             .addressFamily("ipv4")
 *             .bgpAsn(65352)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *         var accepterHostedTransitVirtualInterfaceAcceptor = new HostedTransitVirtualInterfaceAcceptor("accepterHostedTransitVirtualInterfaceAcceptor", HostedTransitVirtualInterfaceAcceptorArgs.builder()
 *             .virtualInterfaceId(creator.id())
 *             .dxGatewayId(example.id())
 *             .tags(Map.of("Side", "Accepter"))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.accepter())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Direct Connect hosted transit virtual interfaces using the VIF `id`. For example:
 * ```sh
 *  $ pulumi import aws:directconnect/hostedTransitVirtualInterfaceAcceptor:HostedTransitVirtualInterfaceAcceptor test dxvif-33cc44dd
 * ```
 *
 */
public class HostedTransitVirtualInterfaceAcceptor internal constructor(
    override val javaResource: com.pulumi.aws.directconnect.HostedTransitVirtualInterfaceAcceptor,
) : KotlinCustomResource(javaResource, HostedTransitVirtualInterfaceAcceptorMapper) {
    /**
     * The ARN of the virtual interface.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ID of the Direct Connect gateway to which to connect the virtual interface.
     */
    public val dxGatewayId: Output<String>
        get() = javaResource.dxGatewayId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the Direct Connect virtual interface to accept.
     */
    public val virtualInterfaceId: Output<String>
        get() = javaResource.virtualInterfaceId().applyValue({ args0 -> args0 })
}

public object HostedTransitVirtualInterfaceAcceptorMapper :
    ResourceMapper<HostedTransitVirtualInterfaceAcceptor> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directconnect.HostedTransitVirtualInterfaceAcceptor::class == javaResource::class

    override fun map(javaResource: Resource): HostedTransitVirtualInterfaceAcceptor =
        HostedTransitVirtualInterfaceAcceptor(
            javaResource as
                com.pulumi.aws.directconnect.HostedTransitVirtualInterfaceAcceptor,
        )
}

/**
 * @see [HostedTransitVirtualInterfaceAcceptor].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HostedTransitVirtualInterfaceAcceptor].
 */
public suspend fun hostedTransitVirtualInterfaceAcceptor(
    name: String,
    block: suspend HostedTransitVirtualInterfaceAcceptorResourceBuilder.() -> Unit,
):
    HostedTransitVirtualInterfaceAcceptor {
    val builder = HostedTransitVirtualInterfaceAcceptorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HostedTransitVirtualInterfaceAcceptor].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hostedTransitVirtualInterfaceAcceptor(name: String):
    HostedTransitVirtualInterfaceAcceptor {
    val builder = HostedTransitVirtualInterfaceAcceptorResourceBuilder()
    builder.name(name)
    return builder.build()
}
