@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [LinkAggregationGroup].
 */
@PulumiTagMarker
public class LinkAggregationGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LinkAggregationGroupArgs = LinkAggregationGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LinkAggregationGroupArgsBuilder.() -> Unit) {
        val builder = LinkAggregationGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LinkAggregationGroup {
        val builtJavaResource =
            com.pulumi.aws.directconnect.LinkAggregationGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LinkAggregationGroup(builtJavaResource)
    }
}

/**
 * Provides a Direct Connect LAG. Connections can be added to the LAG via the `aws.directconnect.Connection` and `aws.directconnect.ConnectionAssociation` resources.
 * > *NOTE:* When creating a LAG, if no existing connection is specified, Direct Connect will create a connection and this provider will remove this unmanaged connection during resource creation.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.LinkAggregationGroup;
 * import com.pulumi.aws.directconnect.LinkAggregationGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hoge = new LinkAggregationGroup("hoge", LinkAggregationGroupArgs.builder()
 *             .connectionsBandwidth("1Gbps")
 *             .forceDestroy(true)
 *             .location("EqDC2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Direct Connect LAGs using the LAG `id`. For example:
 * ```sh
 *  $ pulumi import aws:directconnect/linkAggregationGroup:LinkAggregationGroup test_lag dxlag-fgnsp5rq
 * ```
 *
 */
public class LinkAggregationGroup internal constructor(
    override val javaResource: com.pulumi.aws.directconnect.LinkAggregationGroup,
) : KotlinCustomResource(javaResource, LinkAggregationGroupMapper) {
    /**
     * The ARN of the LAG.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ID of an existing dedicated connection to migrate to the LAG.
     */
    public val connectionId: Output<String>?
        get() = javaResource.connectionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The bandwidth of the individual physical connections bundled by the LAG. Valid values: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps and 100Gbps. Case sensitive.
     */
    public val connectionsBandwidth: Output<String>
        get() = javaResource.connectionsBandwidth().applyValue({ args0 -> args0 })

    /**
     * A boolean that indicates all connections associated with the LAG should be deleted so that the LAG can be destroyed without error. These objects are *not* recoverable.
     */
    public val forceDestroy: Output<Boolean>?
        get() = javaResource.forceDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the LAG supports a secondary BGP peer in the same address family (IPv4/IPv6).
     */
    public val hasLogicalRedundancy: Output<String>
        get() = javaResource.hasLogicalRedundancy().applyValue({ args0 -> args0 })

    /**
     * Indicates whether jumbo frames (9001 MTU) are supported.
     */
    public val jumboFrameCapable: Output<Boolean>
        get() = javaResource.jumboFrameCapable().applyValue({ args0 -> args0 })

    /**
     * The AWS Direct Connect location in which the LAG should be allocated. See [DescribeLocations](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLocations.html) for the list of AWS Direct Connect locations. Use `locationCode`.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the LAG.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ID of the AWS account that owns the LAG.
     */
    public val ownerAccountId: Output<String>
        get() = javaResource.ownerAccountId().applyValue({ args0 -> args0 })

    /**
     * The name of the service provider associated with the LAG.
     */
    public val providerName: Output<String>
        get() = javaResource.providerName().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object LinkAggregationGroupMapper : ResourceMapper<LinkAggregationGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directconnect.LinkAggregationGroup::class == javaResource::class

    override fun map(javaResource: Resource): LinkAggregationGroup = LinkAggregationGroup(
        javaResource
            as com.pulumi.aws.directconnect.LinkAggregationGroup,
    )
}

/**
 * @see [LinkAggregationGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LinkAggregationGroup].
 */
public suspend fun linkAggregationGroup(
    name: String,
    block: suspend LinkAggregationGroupResourceBuilder.() -> Unit,
): LinkAggregationGroup {
    val builder = LinkAggregationGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LinkAggregationGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun linkAggregationGroup(name: String): LinkAggregationGroup {
    val builder = LinkAggregationGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
