@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.LinkAggregationGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Direct Connect LAG. Connections can be added to the LAG via the `aws.directconnect.Connection` and `aws.directconnect.ConnectionAssociation` resources.
 * > *NOTE:* When creating a LAG, if no existing connection is specified, Direct Connect will create a connection and this provider will remove this unmanaged connection during resource creation.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.LinkAggregationGroup;
 * import com.pulumi.aws.directconnect.LinkAggregationGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hoge = new LinkAggregationGroup("hoge", LinkAggregationGroupArgs.builder()
 *             .connectionsBandwidth("1Gbps")
 *             .forceDestroy(true)
 *             .location("EqDC2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Direct Connect LAGs using the LAG `id`. For example:
 * ```sh
 *  $ pulumi import aws:directconnect/linkAggregationGroup:LinkAggregationGroup test_lag dxlag-fgnsp5rq
 * ```
 * @property connectionId The ID of an existing dedicated connection to migrate to the LAG.
 * @property connectionsBandwidth The bandwidth of the individual physical connections bundled by the LAG. Valid values: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps and 100Gbps. Case sensitive.
 * @property forceDestroy A boolean that indicates all connections associated with the LAG should be deleted so that the LAG can be destroyed without error. These objects are *not* recoverable.
 * @property location The AWS Direct Connect location in which the LAG should be allocated. See [DescribeLocations](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLocations.html) for the list of AWS Direct Connect locations. Use `locationCode`.
 * @property name The name of the LAG.
 * @property providerName The name of the service provider associated with the LAG.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class LinkAggregationGroupArgs(
    public val connectionId: Output<String>? = null,
    public val connectionsBandwidth: Output<String>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val providerName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.LinkAggregationGroupArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.LinkAggregationGroupArgs =
        com.pulumi.aws.directconnect.LinkAggregationGroupArgs.builder()
            .connectionId(connectionId?.applyValue({ args0 -> args0 }))
            .connectionsBandwidth(connectionsBandwidth?.applyValue({ args0 -> args0 }))
            .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .providerName(providerName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LinkAggregationGroupArgs].
 */
@PulumiTagMarker
public class LinkAggregationGroupArgsBuilder internal constructor() {
    private var connectionId: Output<String>? = null

    private var connectionsBandwidth: Output<String>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var providerName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The ID of an existing dedicated connection to migrate to the LAG.
     */
    @JvmName("gvtlkhmvdytsqime")
    public suspend fun connectionId(`value`: Output<String>) {
        this.connectionId = value
    }

    /**
     * @param value The bandwidth of the individual physical connections bundled by the LAG. Valid values: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps and 100Gbps. Case sensitive.
     */
    @JvmName("rpgkjeivitslskyt")
    public suspend fun connectionsBandwidth(`value`: Output<String>) {
        this.connectionsBandwidth = value
    }

    /**
     * @param value A boolean that indicates all connections associated with the LAG should be deleted so that the LAG can be destroyed without error. These objects are *not* recoverable.
     */
    @JvmName("mhbrdlohesaqdrqw")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value The AWS Direct Connect location in which the LAG should be allocated. See [DescribeLocations](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLocations.html) for the list of AWS Direct Connect locations. Use `locationCode`.
     */
    @JvmName("llsyogpnwoetrkbs")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the LAG.
     */
    @JvmName("niarqwmonmlqqige")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the service provider associated with the LAG.
     */
    @JvmName("slbkcyimbjrgvhej")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tpigjhnheyxncxvu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of an existing dedicated connection to migrate to the LAG.
     */
    @JvmName("burhqiqsycjrhqwx")
    public suspend fun connectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionId = mapped
    }

    /**
     * @param value The bandwidth of the individual physical connections bundled by the LAG. Valid values: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps and 100Gbps. Case sensitive.
     */
    @JvmName("rkuayrxynrbhpbfg")
    public suspend fun connectionsBandwidth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionsBandwidth = mapped
    }

    /**
     * @param value A boolean that indicates all connections associated with the LAG should be deleted so that the LAG can be destroyed without error. These objects are *not* recoverable.
     */
    @JvmName("oqmlqejglbmeaseh")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value The AWS Direct Connect location in which the LAG should be allocated. See [DescribeLocations](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLocations.html) for the list of AWS Direct Connect locations. Use `locationCode`.
     */
    @JvmName("cqmrauyuiuvqcegv")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the LAG.
     */
    @JvmName("lbdwuccxudedtdno")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the service provider associated with the LAG.
     */
    @JvmName("hgljjcputckujkct")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jtsfafsbufqdysyg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("plduaffevywntefq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LinkAggregationGroupArgs = LinkAggregationGroupArgs(
        connectionId = connectionId,
        connectionsBandwidth = connectionsBandwidth,
        forceDestroy = forceDestroy,
        location = location,
        name = name,
        providerName = providerName,
        tags = tags,
    )
}
