@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [TransitVirtualInterface].
 */
@PulumiTagMarker
public class TransitVirtualInterfaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TransitVirtualInterfaceArgs = TransitVirtualInterfaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TransitVirtualInterfaceArgsBuilder.() -> Unit) {
        val builder = TransitVirtualInterfaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TransitVirtualInterface {
        val builtJavaResource =
            com.pulumi.aws.directconnect.TransitVirtualInterface(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TransitVirtualInterface(builtJavaResource)
    }
}

/**
 * Provides a Direct Connect transit virtual interface resource.
 * A transit virtual interface is a VLAN that transports traffic from a Direct Connect gateway to one or more transit gateways.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Gateway;
 * import com.pulumi.aws.directconnect.GatewayArgs;
 * import com.pulumi.aws.directconnect.TransitVirtualInterface;
 * import com.pulumi.aws.directconnect.TransitVirtualInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGateway = new Gateway("exampleGateway", GatewayArgs.builder()
 *             .amazonSideAsn(64512)
 *             .build());
 *         var exampleTransitVirtualInterface = new TransitVirtualInterface("exampleTransitVirtualInterface", TransitVirtualInterfaceArgs.builder()
 *             .connectionId(aws_dx_connection.example().id())
 *             .dxGatewayId(exampleGateway.id())
 *             .vlan(4094)
 *             .addressFamily("ipv4")
 *             .bgpAsn(65352)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Direct Connect transit virtual interfaces using the VIF `id`. For example:
 * ```sh
 *  $ pulumi import aws:directconnect/transitVirtualInterface:TransitVirtualInterface test dxvif-33cc44dd
 * ```
 *
 */
public class TransitVirtualInterface internal constructor(
    override val javaResource: com.pulumi.aws.directconnect.TransitVirtualInterface,
) : KotlinCustomResource(javaResource, TransitVirtualInterfaceMapper) {
    /**
     * The address family for the BGP peer. `ipv4 ` or `ipv6`.
     */
    public val addressFamily: Output<String>
        get() = javaResource.addressFamily().applyValue({ args0 -> args0 })

    /**
     * The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
     */
    public val amazonAddress: Output<String>
        get() = javaResource.amazonAddress().applyValue({ args0 -> args0 })

    public val amazonSideAsn: Output<String>
        get() = javaResource.amazonSideAsn().applyValue({ args0 -> args0 })

    /**
     * The ARN of the virtual interface.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Direct Connect endpoint on which the virtual interface terminates.
     */
    public val awsDevice: Output<String>
        get() = javaResource.awsDevice().applyValue({ args0 -> args0 })

    /**
     * The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    public val bgpAsn: Output<Int>
        get() = javaResource.bgpAsn().applyValue({ args0 -> args0 })

    /**
     * The authentication key for BGP configuration.
     */
    public val bgpAuthKey: Output<String>
        get() = javaResource.bgpAuthKey().applyValue({ args0 -> args0 })

    /**
     * The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
     */
    public val connectionId: Output<String>
        get() = javaResource.connectionId().applyValue({ args0 -> args0 })

    /**
     * The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
     */
    public val customerAddress: Output<String>
        get() = javaResource.customerAddress().applyValue({ args0 -> args0 })

    /**
     * The ID of the Direct Connect gateway to which to connect the virtual interface.
     */
    public val dxGatewayId: Output<String>
        get() = javaResource.dxGatewayId().applyValue({ args0 -> args0 })

    /**
     * Indicates whether jumbo frames (8500 MTU) are supported.
     */
    public val jumboFrameCapable: Output<Boolean>
        get() = javaResource.jumboFrameCapable().applyValue({ args0 -> args0 })

    /**
     * The maximum transmission unit (MTU) is the size, in bytes, of the largest permissible packet that can be passed over the connection.
     * The MTU of a virtual transit interface can be either `1500` or `8500` (jumbo frames). Default is `1500`.
     */
    public val mtu: Output<Int>?
        get() = javaResource.mtu().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name for the virtual interface.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Indicates whether to enable or disable SiteLink.
     */
    public val sitelinkEnabled: Output<Boolean>?
        get() = javaResource.sitelinkEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The VLAN ID.
     */
    public val vlan: Output<Int>
        get() = javaResource.vlan().applyValue({ args0 -> args0 })
}

public object TransitVirtualInterfaceMapper : ResourceMapper<TransitVirtualInterface> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directconnect.TransitVirtualInterface::class == javaResource::class

    override fun map(javaResource: Resource): TransitVirtualInterface =
        TransitVirtualInterface(javaResource as com.pulumi.aws.directconnect.TransitVirtualInterface)
}

/**
 * @see [TransitVirtualInterface].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TransitVirtualInterface].
 */
public suspend fun transitVirtualInterface(
    name: String,
    block: suspend TransitVirtualInterfaceResourceBuilder.() -> Unit,
): TransitVirtualInterface {
    val builder = TransitVirtualInterfaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TransitVirtualInterface].
 * @param name The _unique_ name of the resulting resource.
 */
public fun transitVirtualInterface(name: String): TransitVirtualInterface {
    val builder = TransitVirtualInterfaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
