@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.TransitVirtualInterfaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Direct Connect transit virtual interface resource.
 * A transit virtual interface is a VLAN that transports traffic from a Direct Connect gateway to one or more transit gateways.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Gateway;
 * import com.pulumi.aws.directconnect.GatewayArgs;
 * import com.pulumi.aws.directconnect.TransitVirtualInterface;
 * import com.pulumi.aws.directconnect.TransitVirtualInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGateway = new Gateway("exampleGateway", GatewayArgs.builder()
 *             .amazonSideAsn(64512)
 *             .build());
 *         var exampleTransitVirtualInterface = new TransitVirtualInterface("exampleTransitVirtualInterface", TransitVirtualInterfaceArgs.builder()
 *             .connectionId(aws_dx_connection.example().id())
 *             .dxGatewayId(exampleGateway.id())
 *             .vlan(4094)
 *             .addressFamily("ipv4")
 *             .bgpAsn(65352)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Direct Connect transit virtual interfaces using the VIF `id`. For example:
 * ```sh
 *  $ pulumi import aws:directconnect/transitVirtualInterface:TransitVirtualInterface test dxvif-33cc44dd
 * ```
 * @property addressFamily The address family for the BGP peer. `ipv4 ` or `ipv6`.
 * @property amazonAddress The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
 * @property bgpAsn The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
 * @property bgpAuthKey The authentication key for BGP configuration.
 * @property connectionId The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
 * @property customerAddress The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
 * @property dxGatewayId The ID of the Direct Connect gateway to which to connect the virtual interface.
 * @property mtu The maximum transmission unit (MTU) is the size, in bytes, of the largest permissible packet that can be passed over the connection.
 * The MTU of a virtual transit interface can be either `1500` or `8500` (jumbo frames). Default is `1500`.
 * @property name The name for the virtual interface.
 * @property sitelinkEnabled Indicates whether to enable or disable SiteLink.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vlan The VLAN ID.
 */
public data class TransitVirtualInterfaceArgs(
    public val addressFamily: Output<String>? = null,
    public val amazonAddress: Output<String>? = null,
    public val bgpAsn: Output<Int>? = null,
    public val bgpAuthKey: Output<String>? = null,
    public val connectionId: Output<String>? = null,
    public val customerAddress: Output<String>? = null,
    public val dxGatewayId: Output<String>? = null,
    public val mtu: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val sitelinkEnabled: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vlan: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.TransitVirtualInterfaceArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.TransitVirtualInterfaceArgs =
        com.pulumi.aws.directconnect.TransitVirtualInterfaceArgs.builder()
            .addressFamily(addressFamily?.applyValue({ args0 -> args0 }))
            .amazonAddress(amazonAddress?.applyValue({ args0 -> args0 }))
            .bgpAsn(bgpAsn?.applyValue({ args0 -> args0 }))
            .bgpAuthKey(bgpAuthKey?.applyValue({ args0 -> args0 }))
            .connectionId(connectionId?.applyValue({ args0 -> args0 }))
            .customerAddress(customerAddress?.applyValue({ args0 -> args0 }))
            .dxGatewayId(dxGatewayId?.applyValue({ args0 -> args0 }))
            .mtu(mtu?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .sitelinkEnabled(sitelinkEnabled?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vlan(vlan?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransitVirtualInterfaceArgs].
 */
@PulumiTagMarker
public class TransitVirtualInterfaceArgsBuilder internal constructor() {
    private var addressFamily: Output<String>? = null

    private var amazonAddress: Output<String>? = null

    private var bgpAsn: Output<Int>? = null

    private var bgpAuthKey: Output<String>? = null

    private var connectionId: Output<String>? = null

    private var customerAddress: Output<String>? = null

    private var dxGatewayId: Output<String>? = null

    private var mtu: Output<Int>? = null

    private var name: Output<String>? = null

    private var sitelinkEnabled: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vlan: Output<Int>? = null

    /**
     * @param value The address family for the BGP peer. `ipv4 ` or `ipv6`.
     */
    @JvmName("ubhbuiarnagwklrg")
    public suspend fun addressFamily(`value`: Output<String>) {
        this.addressFamily = value
    }

    /**
     * @param value The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
     */
    @JvmName("cnnsakglsmixnebs")
    public suspend fun amazonAddress(`value`: Output<String>) {
        this.amazonAddress = value
    }

    /**
     * @param value The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    @JvmName("bubrmueljlsbkgie")
    public suspend fun bgpAsn(`value`: Output<Int>) {
        this.bgpAsn = value
    }

    /**
     * @param value The authentication key for BGP configuration.
     */
    @JvmName("wjlcurukxrcqefup")
    public suspend fun bgpAuthKey(`value`: Output<String>) {
        this.bgpAuthKey = value
    }

    /**
     * @param value The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
     */
    @JvmName("cnlhwejpibgdtfxe")
    public suspend fun connectionId(`value`: Output<String>) {
        this.connectionId = value
    }

    /**
     * @param value The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
     */
    @JvmName("gmuvxnsepquqdrdj")
    public suspend fun customerAddress(`value`: Output<String>) {
        this.customerAddress = value
    }

    /**
     * @param value The ID of the Direct Connect gateway to which to connect the virtual interface.
     */
    @JvmName("hbiriworjxkcdrqf")
    public suspend fun dxGatewayId(`value`: Output<String>) {
        this.dxGatewayId = value
    }

    /**
     * @param value The maximum transmission unit (MTU) is the size, in bytes, of the largest permissible packet that can be passed over the connection.
     * The MTU of a virtual transit interface can be either `1500` or `8500` (jumbo frames). Default is `1500`.
     */
    @JvmName("piwhebshiktfdxok")
    public suspend fun mtu(`value`: Output<Int>) {
        this.mtu = value
    }

    /**
     * @param value The name for the virtual interface.
     */
    @JvmName("kjlkacimdjmxyvim")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicates whether to enable or disable SiteLink.
     */
    @JvmName("gomyelqjgpuqxvov")
    public suspend fun sitelinkEnabled(`value`: Output<Boolean>) {
        this.sitelinkEnabled = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rrxvsgpqbjaysmmd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VLAN ID.
     */
    @JvmName("auljfepsnfsisqcj")
    public suspend fun vlan(`value`: Output<Int>) {
        this.vlan = value
    }

    /**
     * @param value The address family for the BGP peer. `ipv4 ` or `ipv6`.
     */
    @JvmName("mflsucorgxdpopdg")
    public suspend fun addressFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressFamily = mapped
    }

    /**
     * @param value The IPv4 CIDR address to use to send traffic to Amazon. Required for IPv4 BGP peers.
     */
    @JvmName("bdsicqmyquiweept")
    public suspend fun amazonAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amazonAddress = mapped
    }

    /**
     * @param value The autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
     */
    @JvmName("bjlwulqwrugfadtp")
    public suspend fun bgpAsn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpAsn = mapped
    }

    /**
     * @param value The authentication key for BGP configuration.
     */
    @JvmName("sutjsyjapxplagff")
    public suspend fun bgpAuthKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpAuthKey = mapped
    }

    /**
     * @param value The ID of the Direct Connect connection (or LAG) on which to create the virtual interface.
     */
    @JvmName("qljvmijqldjxkipe")
    public suspend fun connectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionId = mapped
    }

    /**
     * @param value The IPv4 CIDR destination address to which Amazon should send traffic. Required for IPv4 BGP peers.
     */
    @JvmName("emyjsxvvybwhbxvx")
    public suspend fun customerAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerAddress = mapped
    }

    /**
     * @param value The ID of the Direct Connect gateway to which to connect the virtual interface.
     */
    @JvmName("vkbwlfakfvhrltrr")
    public suspend fun dxGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dxGatewayId = mapped
    }

    /**
     * @param value The maximum transmission unit (MTU) is the size, in bytes, of the largest permissible packet that can be passed over the connection.
     * The MTU of a virtual transit interface can be either `1500` or `8500` (jumbo frames). Default is `1500`.
     */
    @JvmName("hytbhvahspldmmqu")
    public suspend fun mtu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mtu = mapped
    }

    /**
     * @param value The name for the virtual interface.
     */
    @JvmName("mkrmcechftypsmyr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Indicates whether to enable or disable SiteLink.
     */
    @JvmName("hngovrphlbjtrfnt")
    public suspend fun sitelinkEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sitelinkEnabled = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("namvbpioagijnotn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jdrlxghmpltydsfc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VLAN ID.
     */
    @JvmName("phgtautotfwuhbxd")
    public suspend fun vlan(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlan = mapped
    }

    internal fun build(): TransitVirtualInterfaceArgs = TransitVirtualInterfaceArgs(
        addressFamily = addressFamily,
        amazonAddress = amazonAddress,
        bgpAsn = bgpAsn,
        bgpAuthKey = bgpAuthKey,
        connectionId = connectionId,
        customerAddress = customerAddress,
        dxGatewayId = dxGatewayId,
        mtu = mtu,
        name = name,
        sitelinkEnabled = sitelinkEnabled,
        tags = tags,
        vlan = vlan,
    )
}
