@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin.inputs

import com.pulumi.aws.directconnect.inputs.GetConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConnection.
 * @property name Name of the connection to retrieve.
 * @property tags Map of tags for the resource.
 */
public data class GetConnectionPlainArgs(
    public val name: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.inputs.GetConnectionPlainArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.inputs.GetConnectionPlainArgs =
        com.pulumi.aws.directconnect.inputs.GetConnectionPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetConnectionPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the connection to retrieve.
     */
    @JvmName("vvhlvscqlmgaixfs")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Map of tags for the resource.
     */
    @JvmName("vvsenvvxxsmracon")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags for the resource.
     */
    @JvmName("niffbptpwyrdowlg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetConnectionPlainArgs = GetConnectionPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
    )
}
