@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin.inputs

import com.pulumi.aws.directconnect.inputs.GetRouterConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRouterConfiguration.
 * @property routerTypeIdentifier ID of the Router Type. For example: `CiscoSystemsInc-2900SeriesRouters-IOS124`
 * There is currently no AWS API to retrieve the full list of `router_type_identifier` values. Here is a list of known `RouterType` objects that can be used:
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * ```
 * ```python
 * import pulumi
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * return await Deployment.RunAsync(() =>
 * {
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *     }
 * }
 * ```
 * ```yaml
 * {}
 * ```
 * @property virtualInterfaceId ID of the Direct Connect Virtual Interface
 */
public data class GetRouterConfigurationPlainArgs(
    public val routerTypeIdentifier: String,
    public val virtualInterfaceId: String,
) : ConvertibleToJava<com.pulumi.aws.directconnect.inputs.GetRouterConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.inputs.GetRouterConfigurationPlainArgs =
        com.pulumi.aws.directconnect.inputs.GetRouterConfigurationPlainArgs.builder()
            .routerTypeIdentifier(routerTypeIdentifier.let({ args0 -> args0 }))
            .virtualInterfaceId(virtualInterfaceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRouterConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetRouterConfigurationPlainArgsBuilder internal constructor() {
    private var routerTypeIdentifier: String? = null

    private var virtualInterfaceId: String? = null

    /**
     * @param value ID of the Router Type. For example: `CiscoSystemsInc-2900SeriesRouters-IOS124`
     * There is currently no AWS API to retrieve the full list of `router_type_identifier` values. Here is a list of known `RouterType` objects that can be used:
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    @JvmName("xsnoakxrwdmyfhbh")
    public suspend fun routerTypeIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.routerTypeIdentifier = mapped
    }

    /**
     * @param value ID of the Direct Connect Virtual Interface
     */
    @JvmName("cifsngomjbepwnuw")
    public suspend fun virtualInterfaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualInterfaceId = mapped
    }

    internal fun build(): GetRouterConfigurationPlainArgs = GetRouterConfigurationPlainArgs(
        routerTypeIdentifier = routerTypeIdentifier ?: throw
            PulumiNullFieldException("routerTypeIdentifier"),
        virtualInterfaceId = virtualInterfaceId ?: throw PulumiNullFieldException("virtualInterfaceId"),
    )
}
