@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property platform Router platform
 * @property routerTypeIdentifier ID of the Router Type. For example: `CiscoSystemsInc-2900SeriesRouters-IOS124`
 * There is currently no AWS API to retrieve the full list of `router_type_identifier` values. Here is a list of known `RouterType` objects that can be used:
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * ```
 * ```python
 * import pulumi
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * return await Deployment.RunAsync(() =>
 * {
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *     }
 * }
 * ```
 * ```yaml
 * {}
 * ```
 * @property software Router operating system
 * @property vendor Router vendor
 * @property xsltTemplateName Router XSLT Template Name
 * @property xsltTemplateNameForMacSec
 */
public data class GetRouterConfigurationRouter(
    public val platform: String,
    public val routerTypeIdentifier: String,
    public val software: String,
    public val vendor: String,
    public val xsltTemplateName: String,
    public val xsltTemplateNameForMacSec: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.directconnect.outputs.GetRouterConfigurationRouter):
            GetRouterConfigurationRouter = GetRouterConfigurationRouter(
            platform = javaType.platform(),
            routerTypeIdentifier = javaType.routerTypeIdentifier(),
            software = javaType.software(),
            vendor = javaType.vendor(),
            xsltTemplateName = javaType.xsltTemplateName(),
            xsltTemplateNameForMacSec = javaType.xsltTemplateNameForMacSec(),
        )
    }
}
