@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.aws.directoryservice.DirectoryArgs.builder
import com.pulumi.aws.directoryservice.kotlin.inputs.DirectoryConnectSettingsArgs
import com.pulumi.aws.directoryservice.kotlin.inputs.DirectoryConnectSettingsArgsBuilder
import com.pulumi.aws.directoryservice.kotlin.inputs.DirectoryVpcSettingsArgs
import com.pulumi.aws.directoryservice.kotlin.inputs.DirectoryVpcSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Simple or Managed Microsoft directory in AWS Directory Service.
 * ## Example Usage
 * ### SimpleAD
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.DirectoryVpcSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var foo = new Subnet("foo", SubnetArgs.builder()
 *             .vpcId(main.id())
 *             .availabilityZone("us-west-2a")
 *             .cidrBlock("10.0.1.0/24")
 *             .build());
 *         var barSubnet = new Subnet("barSubnet", SubnetArgs.builder()
 *             .vpcId(main.id())
 *             .availabilityZone("us-west-2b")
 *             .cidrBlock("10.0.2.0/24")
 *             .build());
 *         var barDirectory = new Directory("barDirectory", DirectoryArgs.builder()
 *             .name("corp.notexample.com")
 *             .password("SuperSecretPassw0rd")
 *             .size("Small")
 *             .vpcSettings(DirectoryVpcSettingsArgs.builder()
 *                 .vpcId(main.id())
 *                 .subnetIds(
 *                     foo.id(),
 *                     barSubnet.id())
 *                 .build())
 *             .tags(Map.of("Project", "foo"))
 *             .build());
 *     }
 * }
 * ```
 * ### Microsoft Active Directory (MicrosoftAD)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.DirectoryVpcSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var foo = new Subnet("foo", SubnetArgs.builder()
 *             .vpcId(main.id())
 *             .availabilityZone("us-west-2a")
 *             .cidrBlock("10.0.1.0/24")
 *             .build());
 *         var barSubnet = new Subnet("barSubnet", SubnetArgs.builder()
 *             .vpcId(main.id())
 *             .availabilityZone("us-west-2b")
 *             .cidrBlock("10.0.2.0/24")
 *             .build());
 *         var barDirectory = new Directory("barDirectory", DirectoryArgs.builder()
 *             .name("corp.notexample.com")
 *             .password("SuperSecretPassw0rd")
 *             .edition("Standard")
 *             .type("MicrosoftAD")
 *             .vpcSettings(DirectoryVpcSettingsArgs.builder()
 *                 .vpcId(main.id())
 *                 .subnetIds(
 *                     foo.id(),
 *                     barSubnet.id())
 *                 .build())
 *             .tags(Map.of("Project", "foo"))
 *             .build());
 *     }
 * }
 * ```
 * ### Microsoft Active Directory Connector (ADConnector)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.DirectoryConnectSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new Vpc("main", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var foo = new Subnet("foo", SubnetArgs.builder()
 *             .vpcId(main.id())
 *             .availabilityZone("us-west-2a")
 *             .cidrBlock("10.0.1.0/24")
 *             .build());
 *         var bar = new Subnet("bar", SubnetArgs.builder()
 *             .vpcId(main.id())
 *             .availabilityZone("us-west-2b")
 *             .cidrBlock("10.0.2.0/24")
 *             .build());
 *         var connector = new Directory("connector", DirectoryArgs.builder()
 *             .name("corp.notexample.com")
 *             .password("SuperSecretPassw0rd")
 *             .size("Small")
 *             .type("ADConnector")
 *             .connectSettings(DirectoryConnectSettingsArgs.builder()
 *                 .customerDnsIps("A.B.C.D")
 *                 .customerUsername("Admin")
 *                 .subnetIds(
 *                     foo.id(),
 *                     bar.id())
 *                 .vpcId(main.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DirectoryService directories using the directory `id`. For example:
 * ```sh
 *  $ pulumi import aws:directoryservice/directory:Directory sample d-926724cf57
 * ```
 * @property alias The alias for the directory (must be unique amongst all aliases in AWS). Required for `enable_sso`.
 * @property connectSettings Connector related information about the directory. Fields documented below.
 * @property description A textual description for the directory.
 * @property desiredNumberOfDomainControllers The number of domain controllers desired in the directory. Minimum value of `2`. Scaling of domain controllers is only supported for `MicrosoftAD` directories.
 * @property edition The MicrosoftAD edition (`Standard` or `Enterprise`). Defaults to `Enterprise`.
 * @property enableSso Whether to enable single-sign on for the directory. Requires `alias`. Defaults to `false`.
 * @property name The fully qualified name for the directory, such as `corp.example.com`
 * @property password The password for the directory administrator or connector user.
 * @property shortName The short name of the directory, such as `CORP`.
 * @property size (For `SimpleAD` and `ADConnector` types) The size of the directory (`Small` or `Large` are accepted values). `Large` by default.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The directory type (`SimpleAD`, `ADConnector` or `MicrosoftAD` are accepted values). Defaults to `SimpleAD`.
 * @property vpcSettings VPC related information about the directory. Fields documented below.
 */
public data class DirectoryArgs(
    public val alias: Output<String>? = null,
    public val connectSettings: Output<DirectoryConnectSettingsArgs>? = null,
    public val description: Output<String>? = null,
    public val desiredNumberOfDomainControllers: Output<Int>? = null,
    public val edition: Output<String>? = null,
    public val enableSso: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val password: Output<String>? = null,
    public val shortName: Output<String>? = null,
    public val size: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val vpcSettings: Output<DirectoryVpcSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.directoryservice.DirectoryArgs> {
    override fun toJava(): com.pulumi.aws.directoryservice.DirectoryArgs =
        com.pulumi.aws.directoryservice.DirectoryArgs.builder()
            .alias(alias?.applyValue({ args0 -> args0 }))
            .connectSettings(connectSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .desiredNumberOfDomainControllers(desiredNumberOfDomainControllers?.applyValue({ args0 -> args0 }))
            .edition(edition?.applyValue({ args0 -> args0 }))
            .enableSso(enableSso?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .shortName(shortName?.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .vpcSettings(vpcSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DirectoryArgs].
 */
@PulumiTagMarker
public class DirectoryArgsBuilder internal constructor() {
    private var alias: Output<String>? = null

    private var connectSettings: Output<DirectoryConnectSettingsArgs>? = null

    private var description: Output<String>? = null

    private var desiredNumberOfDomainControllers: Output<Int>? = null

    private var edition: Output<String>? = null

    private var enableSso: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var password: Output<String>? = null

    private var shortName: Output<String>? = null

    private var size: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var vpcSettings: Output<DirectoryVpcSettingsArgs>? = null

    /**
     * @param value The alias for the directory (must be unique amongst all aliases in AWS). Required for `enable_sso`.
     */
    @JvmName("nwlaharpeqwywdcq")
    public suspend fun alias(`value`: Output<String>) {
        this.alias = value
    }

    /**
     * @param value Connector related information about the directory. Fields documented below.
     */
    @JvmName("wokhcqtxwurdjtlr")
    public suspend fun connectSettings(`value`: Output<DirectoryConnectSettingsArgs>) {
        this.connectSettings = value
    }

    /**
     * @param value A textual description for the directory.
     */
    @JvmName("topbuhdfupcaqwfq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The number of domain controllers desired in the directory. Minimum value of `2`. Scaling of domain controllers is only supported for `MicrosoftAD` directories.
     */
    @JvmName("yeqnosdemxphmdgf")
    public suspend fun desiredNumberOfDomainControllers(`value`: Output<Int>) {
        this.desiredNumberOfDomainControllers = value
    }

    /**
     * @param value The MicrosoftAD edition (`Standard` or `Enterprise`). Defaults to `Enterprise`.
     */
    @JvmName("docytcavogvguffa")
    public suspend fun edition(`value`: Output<String>) {
        this.edition = value
    }

    /**
     * @param value Whether to enable single-sign on for the directory. Requires `alias`. Defaults to `false`.
     */
    @JvmName("mxsfycxoqlcqkmrk")
    public suspend fun enableSso(`value`: Output<Boolean>) {
        this.enableSso = value
    }

    /**
     * @param value The fully qualified name for the directory, such as `corp.example.com`
     */
    @JvmName("fjhgsrkdntbpvtsm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The password for the directory administrator or connector user.
     */
    @JvmName("cujkeeetmtvapjiv")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The short name of the directory, such as `CORP`.
     */
    @JvmName("sgsanmmrdcpwfrfk")
    public suspend fun shortName(`value`: Output<String>) {
        this.shortName = value
    }

    /**
     * @param value (For `SimpleAD` and `ADConnector` types) The size of the directory (`Small` or `Large` are accepted values). `Large` by default.
     */
    @JvmName("twonrchnkjbjaifi")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dfdcnqdinptbbcmn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The directory type (`SimpleAD`, `ADConnector` or `MicrosoftAD` are accepted values). Defaults to `SimpleAD`.
     */
    @JvmName("heehmvqmurigrylh")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value VPC related information about the directory. Fields documented below.
     */
    @JvmName("yjdqnclwwqstgexx")
    public suspend fun vpcSettings(`value`: Output<DirectoryVpcSettingsArgs>) {
        this.vpcSettings = value
    }

    /**
     * @param value The alias for the directory (must be unique amongst all aliases in AWS). Required for `enable_sso`.
     */
    @JvmName("xletvcqjoytwsbbj")
    public suspend fun alias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alias = mapped
    }

    /**
     * @param value Connector related information about the directory. Fields documented below.
     */
    @JvmName("gjfywwggptndcgpd")
    public suspend fun connectSettings(`value`: DirectoryConnectSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectSettings = mapped
    }

    /**
     * @param argument Connector related information about the directory. Fields documented below.
     */
    @JvmName("ambgmriiocjqfvfy")
    public suspend
    fun connectSettings(argument: suspend DirectoryConnectSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DirectoryConnectSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectSettings = mapped
    }

    /**
     * @param value A textual description for the directory.
     */
    @JvmName("hgoketbwemglydjt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The number of domain controllers desired in the directory. Minimum value of `2`. Scaling of domain controllers is only supported for `MicrosoftAD` directories.
     */
    @JvmName("xvdxgqcupdlnvldy")
    public suspend fun desiredNumberOfDomainControllers(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredNumberOfDomainControllers = mapped
    }

    /**
     * @param value The MicrosoftAD edition (`Standard` or `Enterprise`). Defaults to `Enterprise`.
     */
    @JvmName("uhhoradaoknudwlt")
    public suspend fun edition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edition = mapped
    }

    /**
     * @param value Whether to enable single-sign on for the directory. Requires `alias`. Defaults to `false`.
     */
    @JvmName("yknkvdjwpientcsa")
    public suspend fun enableSso(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSso = mapped
    }

    /**
     * @param value The fully qualified name for the directory, such as `corp.example.com`
     */
    @JvmName("islyhvnhmmeyfsks")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The password for the directory administrator or connector user.
     */
    @JvmName("igkqermduwyxtjdn")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The short name of the directory, such as `CORP`.
     */
    @JvmName("nyxapdqbuxdjvtdw")
    public suspend fun shortName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shortName = mapped
    }

    /**
     * @param value (For `SimpleAD` and `ADConnector` types) The size of the directory (`Small` or `Large` are accepted values). `Large` by default.
     */
    @JvmName("icpnujmakriojgal")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vnodjmvcshodpijl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("saotjhkgpcymspao")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The directory type (`SimpleAD`, `ADConnector` or `MicrosoftAD` are accepted values). Defaults to `SimpleAD`.
     */
    @JvmName("bpprwjxuwxdolsjq")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value VPC related information about the directory. Fields documented below.
     */
    @JvmName("clilcxrdsmtqiami")
    public suspend fun vpcSettings(`value`: DirectoryVpcSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSettings = mapped
    }

    /**
     * @param argument VPC related information about the directory. Fields documented below.
     */
    @JvmName("pjmksgqhhenktjbl")
    public suspend fun vpcSettings(argument: suspend DirectoryVpcSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DirectoryVpcSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcSettings = mapped
    }

    internal fun build(): DirectoryArgs = DirectoryArgs(
        alias = alias,
        connectSettings = connectSettings,
        description = description,
        desiredNumberOfDomainControllers = desiredNumberOfDomainControllers,
        edition = edition,
        enableSso = enableSso,
        name = name,
        password = password,
        shortName = shortName,
        size = size,
        tags = tags,
        type = type,
        vpcSettings = vpcSettings,
    )
}
