@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [LogService].
 */
@PulumiTagMarker
public class LogServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LogServiceArgs = LogServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LogServiceArgsBuilder.() -> Unit) {
        val builder = LogServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LogService {
        val builtJavaResource = com.pulumi.aws.directoryservice.LogService(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LogService(builtJavaResource)
    }
}

/**
 * Provides a Log subscription for AWS Directory Service that pushes logs to cloudwatch.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicy;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicyArgs;
 * import com.pulumi.aws.directoryservice.LogService;
 * import com.pulumi.aws.directoryservice.LogServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup", LogGroupArgs.builder()
 *             .retentionInDays(14)
 *             .build());
 *         final var ad-log-policyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions(
 *                     "logs:CreateLogStream",
 *                     "logs:PutLogEvents")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("ds.amazonaws.com")
 *                     .type("Service")
 *                     .build())
 *                 .resources(exampleLogGroup.arn().applyValue(arn -> String.format("%s:*", arn)))
 *                 .effect("Allow")
 *                 .build())
 *             .build());
 *         var ad_log_policyLogResourcePolicy = new LogResourcePolicy("ad-log-policyLogResourcePolicy", LogResourcePolicyArgs.builder()
 *             .policyDocument(ad_log_policyPolicyDocument.applyValue(ad_log_policyPolicyDocument -> ad_log_policyPolicyDocument.json()))
 *             .policyName("ad-log-policy")
 *             .build());
 *         var exampleLogService = new LogService("exampleLogService", LogServiceArgs.builder()
 *             .directoryId(aws_directory_service_directory.example().id())
 *             .logGroupName(exampleLogGroup.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Directory Service Log Subscriptions using the directory id. For example:
 * ```sh
 *  $ pulumi import aws:directoryservice/logService:LogService msad d-1234567890
 * ```
 *
 */
public class LogService internal constructor(
    override val javaResource: com.pulumi.aws.directoryservice.LogService,
) : KotlinCustomResource(javaResource, LogServiceMapper) {
    /**
     * ID of directory.
     */
    public val directoryId: Output<String>
        get() = javaResource.directoryId().applyValue({ args0 -> args0 })

    /**
     * Name of the cloudwatch log group to which the logs should be published. The log group should be already created and the directory service principal should be provided with required permission to create stream and publish logs. Changing this value would delete the current subscription and create a new one. A directory can only have one log subscription at a time.
     */
    public val logGroupName: Output<String>
        get() = javaResource.logGroupName().applyValue({ args0 -> args0 })
}

public object LogServiceMapper : ResourceMapper<LogService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directoryservice.LogService::class == javaResource::class

    override fun map(javaResource: Resource): LogService = LogService(
        javaResource as
            com.pulumi.aws.directoryservice.LogService,
    )
}

/**
 * @see [LogService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LogService].
 */
public suspend fun logService(name: String, block: suspend LogServiceResourceBuilder.() -> Unit):
    LogService {
    val builder = LogServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LogService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun logService(name: String): LogService {
    val builder = LogServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
