@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.aws.directoryservice.LogServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Log subscription for AWS Directory Service that pushes logs to cloudwatch.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicy;
 * import com.pulumi.aws.cloudwatch.LogResourcePolicyArgs;
 * import com.pulumi.aws.directoryservice.LogService;
 * import com.pulumi.aws.directoryservice.LogServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup", LogGroupArgs.builder()
 *             .retentionInDays(14)
 *             .build());
 *         final var ad-log-policyPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions(
 *                     "logs:CreateLogStream",
 *                     "logs:PutLogEvents")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("ds.amazonaws.com")
 *                     .type("Service")
 *                     .build())
 *                 .resources(exampleLogGroup.arn().applyValue(arn -> String.format("%s:*", arn)))
 *                 .effect("Allow")
 *                 .build())
 *             .build());
 *         var ad_log_policyLogResourcePolicy = new LogResourcePolicy("ad-log-policyLogResourcePolicy", LogResourcePolicyArgs.builder()
 *             .policyDocument(ad_log_policyPolicyDocument.applyValue(ad_log_policyPolicyDocument -> ad_log_policyPolicyDocument.json()))
 *             .policyName("ad-log-policy")
 *             .build());
 *         var exampleLogService = new LogService("exampleLogService", LogServiceArgs.builder()
 *             .directoryId(aws_directory_service_directory.example().id())
 *             .logGroupName(exampleLogGroup.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Directory Service Log Subscriptions using the directory id. For example:
 * ```sh
 *  $ pulumi import aws:directoryservice/logService:LogService msad d-1234567890
 * ```
 * @property directoryId ID of directory.
 * @property logGroupName Name of the cloudwatch log group to which the logs should be published. The log group should be already created and the directory service principal should be provided with required permission to create stream and publish logs. Changing this value would delete the current subscription and create a new one. A directory can only have one log subscription at a time.
 */
public data class LogServiceArgs(
    public val directoryId: Output<String>? = null,
    public val logGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directoryservice.LogServiceArgs> {
    override fun toJava(): com.pulumi.aws.directoryservice.LogServiceArgs =
        com.pulumi.aws.directoryservice.LogServiceArgs.builder()
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .logGroupName(logGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogServiceArgs].
 */
@PulumiTagMarker
public class LogServiceArgsBuilder internal constructor() {
    private var directoryId: Output<String>? = null

    private var logGroupName: Output<String>? = null

    /**
     * @param value ID of directory.
     */
    @JvmName("gxcnxxjochmkkruw")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value Name of the cloudwatch log group to which the logs should be published. The log group should be already created and the directory service principal should be provided with required permission to create stream and publish logs. Changing this value would delete the current subscription and create a new one. A directory can only have one log subscription at a time.
     */
    @JvmName("uymnyavdgsjammju")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value ID of directory.
     */
    @JvmName("uoythclsqoseqygi")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value Name of the cloudwatch log group to which the logs should be published. The log group should be already created and the directory service principal should be provided with required permission to create stream and publish logs. Changing this value would delete the current subscription and create a new one. A directory can only have one log subscription at a time.
     */
    @JvmName("mcvphddhwxsldgxi")
    public suspend fun logGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    internal fun build(): LogServiceArgs = LogServiceArgs(
        directoryId = directoryId,
        logGroupName = logGroupName,
    )
}
