@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RadiusSettings].
 */
@PulumiTagMarker
public class RadiusSettingsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RadiusSettingsArgs = RadiusSettingsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RadiusSettingsArgsBuilder.() -> Unit) {
        val builder = RadiusSettingsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RadiusSettings {
        val builtJavaResource = com.pulumi.aws.directoryservice.RadiusSettings(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RadiusSettings(builtJavaResource)
    }
}

/**
 * Manages a directory's multi-factor authentication (MFA) using a Remote Authentication Dial In User Service (RADIUS) server.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directoryservice.RadiusSettings;
 * import com.pulumi.aws.directoryservice.RadiusSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RadiusSettings("example", RadiusSettingsArgs.builder()
 *             .directoryId(aws_directory_service_directory.example().id())
 *             .authenticationProtocol("PAP")
 *             .displayLabel("example")
 *             .radiusPort(1812)
 *             .radiusRetries(4)
 *             .radiusServers("10.0.1.5")
 *             .radiusTimeout(1)
 *             .sharedSecret("12345678")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import RADIUS settings using the directory ID. For example:
 * ```sh
 *  $ pulumi import aws:directoryservice/radiusSettings:RadiusSettings example d-926724cf57
 * ```
 *
 */
public class RadiusSettings internal constructor(
    override val javaResource: com.pulumi.aws.directoryservice.RadiusSettings,
) : KotlinCustomResource(javaResource, RadiusSettingsMapper) {
    /**
     * The protocol specified for your RADIUS endpoints. Valid values: `PAP`, `CHAP`, `MS-CHAPv1`, `MS-CHAPv2`.
     */
    public val authenticationProtocol: Output<String>
        get() = javaResource.authenticationProtocol().applyValue({ args0 -> args0 })

    /**
     * The identifier of the directory for which you want to manager RADIUS settings.
     */
    public val directoryId: Output<String>
        get() = javaResource.directoryId().applyValue({ args0 -> args0 })

    /**
     * Display label.
     */
    public val displayLabel: Output<String>
        get() = javaResource.displayLabel().applyValue({ args0 -> args0 })

    /**
     * The port that your RADIUS server is using for communications. Your self-managed network must allow inbound traffic over this port from the AWS Directory Service servers.
     */
    public val radiusPort: Output<Int>
        get() = javaResource.radiusPort().applyValue({ args0 -> args0 })

    /**
     * The maximum number of times that communication with the RADIUS server is attempted. Minimum value of `0`. Maximum value of `10`.
     */
    public val radiusRetries: Output<Int>
        get() = javaResource.radiusRetries().applyValue({ args0 -> args0 })

    /**
     * An array of strings that contains the fully qualified domain name (FQDN) or IP addresses of the RADIUS server endpoints, or the FQDN or IP addresses of your RADIUS server load balancer.
     */
    public val radiusServers: Output<List<String>>
        get() = javaResource.radiusServers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The amount of time, in seconds, to wait for the RADIUS server to respond. Minimum value of `1`. Maximum value of `50`.
     */
    public val radiusTimeout: Output<Int>
        get() = javaResource.radiusTimeout().applyValue({ args0 -> args0 })

    /**
     * Required for enabling RADIUS on the directory.
     */
    public val sharedSecret: Output<String>
        get() = javaResource.sharedSecret().applyValue({ args0 -> args0 })

    /**
     * Not currently used.
     */
    public val useSameUsername: Output<Boolean>?
        get() = javaResource.useSameUsername().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object RadiusSettingsMapper : ResourceMapper<RadiusSettings> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directoryservice.RadiusSettings::class == javaResource::class

    override fun map(javaResource: Resource): RadiusSettings = RadiusSettings(
        javaResource as
            com.pulumi.aws.directoryservice.RadiusSettings,
    )
}

/**
 * @see [RadiusSettings].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RadiusSettings].
 */
public suspend fun radiusSettings(
    name: String,
    block: suspend RadiusSettingsResourceBuilder.() -> Unit,
): RadiusSettings {
    val builder = RadiusSettingsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RadiusSettings].
 * @param name The _unique_ name of the resulting resource.
 */
public fun radiusSettings(name: String): RadiusSettings {
    val builder = RadiusSettingsResourceBuilder()
    builder.name(name)
    return builder.build()
}
