@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.aws.directoryservice.kotlin.outputs.ServiceRegionVpcSettings
import com.pulumi.aws.directoryservice.kotlin.outputs.ServiceRegionVpcSettings.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ServiceRegion].
 */
@PulumiTagMarker
public class ServiceRegionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceRegionArgs = ServiceRegionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceRegionArgsBuilder.() -> Unit) {
        val builder = ServiceRegionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ServiceRegion {
        val builtJavaResource = com.pulumi.aws.directoryservice.ServiceRegion(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServiceRegion(builtJavaResource)
    }
}

/**
 * Manages a replicated Region and directory for Multi-Region replication.
 * Multi-Region replication is only supported for the Enterprise Edition of AWS Managed Microsoft AD.
 * ## Import
 * Using `pulumi import`, import Replicated Regions using directory ID,Region name. For example:
 * ```sh
 *  $ pulumi import aws:directoryservice/serviceRegion:ServiceRegion example d-9267651497,us-east-2
 * ```
 *
 */
public class ServiceRegion internal constructor(
    override val javaResource: com.pulumi.aws.directoryservice.ServiceRegion,
) : KotlinCustomResource(javaResource, ServiceRegionMapper) {
    /**
     * The number of domain controllers desired in the replicated directory. Minimum value of `2`.
     */
    public val desiredNumberOfDomainControllers: Output<Int>
        get() = javaResource.desiredNumberOfDomainControllers().applyValue({ args0 -> args0 })

    /**
     * The identifier of the directory to which you want to add Region replication.
     */
    public val directoryId: Output<String>
        get() = javaResource.directoryId().applyValue({ args0 -> args0 })

    /**
     * The name of the Region where you want to add domain controllers for replication.
     */
    public val regionName: Output<String>
        get() = javaResource.regionName().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * VPC information in the replicated Region. Detailed below.
     */
    public val vpcSettings: Output<ServiceRegionVpcSettings>
        get() = javaResource.vpcSettings().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
}

public object ServiceRegionMapper : ResourceMapper<ServiceRegion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directoryservice.ServiceRegion::class == javaResource::class

    override fun map(javaResource: Resource): ServiceRegion = ServiceRegion(
        javaResource as
            com.pulumi.aws.directoryservice.ServiceRegion,
    )
}

/**
 * @see [ServiceRegion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceRegion].
 */
public suspend fun serviceRegion(
    name: String,
    block: suspend ServiceRegionResourceBuilder.() -> Unit,
): ServiceRegion {
    val builder = ServiceRegionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceRegion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceRegion(name: String): ServiceRegion {
    val builder = ServiceRegionResourceBuilder()
    builder.name(name)
    return builder.build()
}
