@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.aws.directoryservice.ServiceRegionArgs.builder
import com.pulumi.aws.directoryservice.kotlin.inputs.ServiceRegionVpcSettingsArgs
import com.pulumi.aws.directoryservice.kotlin.inputs.ServiceRegionVpcSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a replicated Region and directory for Multi-Region replication.
 * Multi-Region replication is only supported for the Enterprise Edition of AWS Managed Microsoft AD.
 * ## Import
 * Using `pulumi import`, import Replicated Regions using directory ID,Region name. For example:
 * ```sh
 *  $ pulumi import aws:directoryservice/serviceRegion:ServiceRegion example d-9267651497,us-east-2
 * ```
 * @property desiredNumberOfDomainControllers The number of domain controllers desired in the replicated directory. Minimum value of `2`.
 * @property directoryId The identifier of the directory to which you want to add Region replication.
 * @property regionName The name of the Region where you want to add domain controllers for replication.
 * @property tags Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcSettings VPC information in the replicated Region. Detailed below.
 */
public data class ServiceRegionArgs(
    public val desiredNumberOfDomainControllers: Output<Int>? = null,
    public val directoryId: Output<String>? = null,
    public val regionName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcSettings: Output<ServiceRegionVpcSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.directoryservice.ServiceRegionArgs> {
    override fun toJava(): com.pulumi.aws.directoryservice.ServiceRegionArgs =
        com.pulumi.aws.directoryservice.ServiceRegionArgs.builder()
            .desiredNumberOfDomainControllers(desiredNumberOfDomainControllers?.applyValue({ args0 -> args0 }))
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .regionName(regionName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcSettings(vpcSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ServiceRegionArgs].
 */
@PulumiTagMarker
public class ServiceRegionArgsBuilder internal constructor() {
    private var desiredNumberOfDomainControllers: Output<Int>? = null

    private var directoryId: Output<String>? = null

    private var regionName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcSettings: Output<ServiceRegionVpcSettingsArgs>? = null

    /**
     * @param value The number of domain controllers desired in the replicated directory. Minimum value of `2`.
     */
    @JvmName("ffjkluqwbcfewsvc")
    public suspend fun desiredNumberOfDomainControllers(`value`: Output<Int>) {
        this.desiredNumberOfDomainControllers = value
    }

    /**
     * @param value The identifier of the directory to which you want to add Region replication.
     */
    @JvmName("cqckuoeqywceovyu")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value The name of the Region where you want to add domain controllers for replication.
     */
    @JvmName("rsihmynqpvydurkl")
    public suspend fun regionName(`value`: Output<String>) {
        this.regionName = value
    }

    /**
     * @param value Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("heatwareuspbkjgc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value VPC information in the replicated Region. Detailed below.
     */
    @JvmName("yhuqfmebfltsnstc")
    public suspend fun vpcSettings(`value`: Output<ServiceRegionVpcSettingsArgs>) {
        this.vpcSettings = value
    }

    /**
     * @param value The number of domain controllers desired in the replicated directory. Minimum value of `2`.
     */
    @JvmName("kowmckuforwxuife")
    public suspend fun desiredNumberOfDomainControllers(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredNumberOfDomainControllers = mapped
    }

    /**
     * @param value The identifier of the directory to which you want to add Region replication.
     */
    @JvmName("yatltaajvbhsmfel")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value The name of the Region where you want to add domain controllers for replication.
     */
    @JvmName("rvjdwypsmbjtsakc")
    public suspend fun regionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionName = mapped
    }

    /**
     * @param value Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pakxjsafmntiqiao")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rvctonvgdfcgtrlk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value VPC information in the replicated Region. Detailed below.
     */
    @JvmName("ouhvuuryhructyvc")
    public suspend fun vpcSettings(`value`: ServiceRegionVpcSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSettings = mapped
    }

    /**
     * @param argument VPC information in the replicated Region. Detailed below.
     */
    @JvmName("vllkmcqcwcsgjwqs")
    public suspend fun vpcSettings(argument: suspend ServiceRegionVpcSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceRegionVpcSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcSettings = mapped
    }

    internal fun build(): ServiceRegionArgs = ServiceRegionArgs(
        desiredNumberOfDomainControllers = desiredNumberOfDomainControllers,
        directoryId = directoryId,
        regionName = regionName,
        tags = tags,
        vpcSettings = vpcSettings,
    )
}
