@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.aws.directoryservice.kotlin.outputs.SharedDirectoryTarget
import com.pulumi.aws.directoryservice.kotlin.outputs.SharedDirectoryTarget.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SharedDirectory].
 */
@PulumiTagMarker
public class SharedDirectoryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SharedDirectoryArgs = SharedDirectoryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SharedDirectoryArgsBuilder.() -> Unit) {
        val builder = SharedDirectoryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SharedDirectory {
        val builtJavaResource = com.pulumi.aws.directoryservice.SharedDirectory(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SharedDirectory(builtJavaResource)
    }
}

/**
 * Manages a directory in your account (directory owner) shared with another account (directory consumer).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.DirectoryVpcSettingsArgs;
 * import com.pulumi.aws.directoryservice.SharedDirectory;
 * import com.pulumi.aws.directoryservice.SharedDirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.SharedDirectoryTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDirectory = new Directory("exampleDirectory", DirectoryArgs.builder()
 *             .name("tf-example")
 *             .password("SuperSecretPassw0rd")
 *             .type("MicrosoftAD")
 *             .edition("Standard")
 *             .vpcSettings(DirectoryVpcSettingsArgs.builder()
 *                 .vpcId(aws_vpc.example().id())
 *                 .subnetIds(aws_subnet.example().stream().map(element -> element.id()).collect(toList()))
 *                 .build())
 *             .build());
 *         var exampleSharedDirectory = new SharedDirectory("exampleSharedDirectory", SharedDirectoryArgs.builder()
 *             .directoryId(exampleDirectory.id())
 *             .notes("You wanna have a catch?")
 *             .target(SharedDirectoryTargetArgs.builder()
 *                 .id(data.aws_caller_identity().receiver().account_id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Directory Service Shared Directories using the owner directory ID/shared directory ID. For example:
 * ```sh
 *  $ pulumi import aws:directoryservice/sharedDirectory:SharedDirectory example d-1234567890/d-9267633ece
 * ```
 *
 */
public class SharedDirectory internal constructor(
    override val javaResource: com.pulumi.aws.directoryservice.SharedDirectory,
) : KotlinCustomResource(javaResource, SharedDirectoryMapper) {
    /**
     * Identifier of the Managed Microsoft AD directory that you want to share with other accounts.
     */
    public val directoryId: Output<String>
        get() = javaResource.directoryId().applyValue({ args0 -> args0 })

    /**
     * Method used when sharing a directory. Valid values are `ORGANIZATIONS` and `HANDSHAKE`. Default is `HANDSHAKE`.
     */
    public val method: Output<String>?
        get() = javaResource.method().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Message sent by the directory owner to the directory consumer to help the directory consumer administrator determine whether to approve or reject the share invitation.
     */
    public val notes: Output<String>?
        get() = javaResource.notes().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Identifier of the directory that is stored in the directory consumer account that corresponds to the shared directory in the owner account.
     */
    public val sharedDirectoryId: Output<String>
        get() = javaResource.sharedDirectoryId().applyValue({ args0 -> args0 })

    /**
     * Identifier for the directory consumer account with whom the directory is to be shared. See below.
     * The following arguments are optional:
     */
    public val target: Output<SharedDirectoryTarget>
        get() = javaResource.target().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
}

public object SharedDirectoryMapper : ResourceMapper<SharedDirectory> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directoryservice.SharedDirectory::class == javaResource::class

    override fun map(javaResource: Resource): SharedDirectory = SharedDirectory(
        javaResource as
            com.pulumi.aws.directoryservice.SharedDirectory,
    )
}

/**
 * @see [SharedDirectory].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SharedDirectory].
 */
public suspend fun sharedDirectory(
    name: String,
    block: suspend SharedDirectoryResourceBuilder.() -> Unit,
): SharedDirectory {
    val builder = SharedDirectoryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SharedDirectory].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sharedDirectory(name: String): SharedDirectory {
    val builder = SharedDirectoryResourceBuilder()
    builder.name(name)
    return builder.build()
}
