@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SharedDirectoryAccepter].
 */
@PulumiTagMarker
public class SharedDirectoryAccepterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SharedDirectoryAccepterArgs = SharedDirectoryAccepterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SharedDirectoryAccepterArgsBuilder.() -> Unit) {
        val builder = SharedDirectoryAccepterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SharedDirectoryAccepter {
        val builtJavaResource =
            com.pulumi.aws.directoryservice.SharedDirectoryAccepter(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SharedDirectoryAccepter(builtJavaResource)
    }
}

/**
 * Accepts a shared directory in a consumer account.
 * > **NOTE:** Destroying this resource removes the shared directory from the consumer account only.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directoryservice.SharedDirectory;
 * import com.pulumi.aws.directoryservice.SharedDirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.SharedDirectoryTargetArgs;
 * import com.pulumi.aws.directoryservice.SharedDirectoryAccepter;
 * import com.pulumi.aws.directoryservice.SharedDirectoryAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSharedDirectory = new SharedDirectory("exampleSharedDirectory", SharedDirectoryArgs.builder()
 *             .directoryId(aws_directory_service_directory.example().id())
 *             .notes("example")
 *             .target(SharedDirectoryTargetArgs.builder()
 *                 .id(data.aws_caller_identity().receiver().account_id())
 *                 .build())
 *             .build());
 *         var exampleSharedDirectoryAccepter = new SharedDirectoryAccepter("exampleSharedDirectoryAccepter", SharedDirectoryAccepterArgs.builder()
 *             .sharedDirectoryId(exampleSharedDirectory.sharedDirectoryId())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider("awsalternate")
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Directory Service Shared Directories using the shared directory ID. For example:
 * ```sh
 *  $ pulumi import aws:directoryservice/sharedDirectoryAccepter:SharedDirectoryAccepter example d-9267633ece
 * ```
 *
 */
public class SharedDirectoryAccepter internal constructor(
    override val javaResource: com.pulumi.aws.directoryservice.SharedDirectoryAccepter,
) : KotlinCustomResource(javaResource, SharedDirectoryAccepterMapper) {
    /**
     * Method used when sharing a directory (i.e., `ORGANIZATIONS` or `HANDSHAKE`).
     */
    public val method: Output<String>
        get() = javaResource.method().applyValue({ args0 -> args0 })

    /**
     * Message sent by the directory owner to the directory consumer to help the directory consumer administrator determine whether to approve or reject the share invitation.
     */
    public val notes: Output<String>
        get() = javaResource.notes().applyValue({ args0 -> args0 })

    /**
     * Account identifier of the directory owner.
     */
    public val ownerAccountId: Output<String>
        get() = javaResource.ownerAccountId().applyValue({ args0 -> args0 })

    /**
     * Identifier of the Managed Microsoft AD directory from the perspective of the directory owner.
     */
    public val ownerDirectoryId: Output<String>
        get() = javaResource.ownerDirectoryId().applyValue({ args0 -> args0 })

    /**
     * Identifier of the directory that is stored in the directory consumer account that corresponds to the shared directory in the owner account.
     */
    public val sharedDirectoryId: Output<String>
        get() = javaResource.sharedDirectoryId().applyValue({ args0 -> args0 })
}

public object SharedDirectoryAccepterMapper : ResourceMapper<SharedDirectoryAccepter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directoryservice.SharedDirectoryAccepter::class == javaResource::class

    override fun map(javaResource: Resource): SharedDirectoryAccepter =
        SharedDirectoryAccepter(
            javaResource as
                com.pulumi.aws.directoryservice.SharedDirectoryAccepter,
        )
}

/**
 * @see [SharedDirectoryAccepter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SharedDirectoryAccepter].
 */
public suspend fun sharedDirectoryAccepter(
    name: String,
    block: suspend SharedDirectoryAccepterResourceBuilder.() -> Unit,
): SharedDirectoryAccepter {
    val builder = SharedDirectoryAccepterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SharedDirectoryAccepter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sharedDirectoryAccepter(name: String): SharedDirectoryAccepter {
    val builder = SharedDirectoryAccepterResourceBuilder()
    builder.name(name)
    return builder.build()
}
