@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.aws.directoryservice.SharedDirectoryAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Accepts a shared directory in a consumer account.
 * > **NOTE:** Destroying this resource removes the shared directory from the consumer account only.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directoryservice.SharedDirectory;
 * import com.pulumi.aws.directoryservice.SharedDirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.SharedDirectoryTargetArgs;
 * import com.pulumi.aws.directoryservice.SharedDirectoryAccepter;
 * import com.pulumi.aws.directoryservice.SharedDirectoryAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleSharedDirectory = new SharedDirectory("exampleSharedDirectory", SharedDirectoryArgs.builder()
 *             .directoryId(aws_directory_service_directory.example().id())
 *             .notes("example")
 *             .target(SharedDirectoryTargetArgs.builder()
 *                 .id(data.aws_caller_identity().receiver().account_id())
 *                 .build())
 *             .build());
 *         var exampleSharedDirectoryAccepter = new SharedDirectoryAccepter("exampleSharedDirectoryAccepter", SharedDirectoryAccepterArgs.builder()
 *             .sharedDirectoryId(exampleSharedDirectory.sharedDirectoryId())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider("awsalternate")
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Directory Service Shared Directories using the shared directory ID. For example:
 * ```sh
 *  $ pulumi import aws:directoryservice/sharedDirectoryAccepter:SharedDirectoryAccepter example d-9267633ece
 * ```
 * @property sharedDirectoryId Identifier of the directory that is stored in the directory consumer account that corresponds to the shared directory in the owner account.
 */
public data class SharedDirectoryAccepterArgs(
    public val sharedDirectoryId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directoryservice.SharedDirectoryAccepterArgs> {
    override fun toJava(): com.pulumi.aws.directoryservice.SharedDirectoryAccepterArgs =
        com.pulumi.aws.directoryservice.SharedDirectoryAccepterArgs.builder()
            .sharedDirectoryId(sharedDirectoryId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SharedDirectoryAccepterArgs].
 */
@PulumiTagMarker
public class SharedDirectoryAccepterArgsBuilder internal constructor() {
    private var sharedDirectoryId: Output<String>? = null

    /**
     * @param value Identifier of the directory that is stored in the directory consumer account that corresponds to the shared directory in the owner account.
     */
    @JvmName("ntgaeyvvdthbyghl")
    public suspend fun sharedDirectoryId(`value`: Output<String>) {
        this.sharedDirectoryId = value
    }

    /**
     * @param value Identifier of the directory that is stored in the directory consumer account that corresponds to the shared directory in the owner account.
     */
    @JvmName("qvohjqiimwjlykac")
    public suspend fun sharedDirectoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedDirectoryId = mapped
    }

    internal fun build(): SharedDirectoryAccepterArgs = SharedDirectoryAccepterArgs(
        sharedDirectoryId = sharedDirectoryId,
    )
}
