@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.aws.directoryservice.SharedDirectoryArgs.builder
import com.pulumi.aws.directoryservice.kotlin.inputs.SharedDirectoryTargetArgs
import com.pulumi.aws.directoryservice.kotlin.inputs.SharedDirectoryTargetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages a directory in your account (directory owner) shared with another account (directory consumer).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.DirectoryVpcSettingsArgs;
 * import com.pulumi.aws.directoryservice.SharedDirectory;
 * import com.pulumi.aws.directoryservice.SharedDirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.SharedDirectoryTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDirectory = new Directory("exampleDirectory", DirectoryArgs.builder()
 *             .name("tf-example")
 *             .password("SuperSecretPassw0rd")
 *             .type("MicrosoftAD")
 *             .edition("Standard")
 *             .vpcSettings(DirectoryVpcSettingsArgs.builder()
 *                 .vpcId(aws_vpc.example().id())
 *                 .subnetIds(aws_subnet.example().stream().map(element -> element.id()).collect(toList()))
 *                 .build())
 *             .build());
 *         var exampleSharedDirectory = new SharedDirectory("exampleSharedDirectory", SharedDirectoryArgs.builder()
 *             .directoryId(exampleDirectory.id())
 *             .notes("You wanna have a catch?")
 *             .target(SharedDirectoryTargetArgs.builder()
 *                 .id(data.aws_caller_identity().receiver().account_id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Directory Service Shared Directories using the owner directory ID/shared directory ID. For example:
 * ```sh
 *  $ pulumi import aws:directoryservice/sharedDirectory:SharedDirectory example d-1234567890/d-9267633ece
 * ```
 * @property directoryId Identifier of the Managed Microsoft AD directory that you want to share with other accounts.
 * @property method Method used when sharing a directory. Valid values are `ORGANIZATIONS` and `HANDSHAKE`. Default is `HANDSHAKE`.
 * @property notes Message sent by the directory owner to the directory consumer to help the directory consumer administrator determine whether to approve or reject the share invitation.
 * @property target Identifier for the directory consumer account with whom the directory is to be shared. See below.
 * The following arguments are optional:
 */
public data class SharedDirectoryArgs(
    public val directoryId: Output<String>? = null,
    public val method: Output<String>? = null,
    public val notes: Output<String>? = null,
    public val target: Output<SharedDirectoryTargetArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.directoryservice.SharedDirectoryArgs> {
    override fun toJava(): com.pulumi.aws.directoryservice.SharedDirectoryArgs =
        com.pulumi.aws.directoryservice.SharedDirectoryArgs.builder()
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .method(method?.applyValue({ args0 -> args0 }))
            .notes(notes?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SharedDirectoryArgs].
 */
@PulumiTagMarker
public class SharedDirectoryArgsBuilder internal constructor() {
    private var directoryId: Output<String>? = null

    private var method: Output<String>? = null

    private var notes: Output<String>? = null

    private var target: Output<SharedDirectoryTargetArgs>? = null

    /**
     * @param value Identifier of the Managed Microsoft AD directory that you want to share with other accounts.
     */
    @JvmName("bmildafrfginsvfx")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value Method used when sharing a directory. Valid values are `ORGANIZATIONS` and `HANDSHAKE`. Default is `HANDSHAKE`.
     */
    @JvmName("lrnhkybabhouhunr")
    public suspend fun method(`value`: Output<String>) {
        this.method = value
    }

    /**
     * @param value Message sent by the directory owner to the directory consumer to help the directory consumer administrator determine whether to approve or reject the share invitation.
     */
    @JvmName("rakkxndvxxkwxxcs")
    public suspend fun notes(`value`: Output<String>) {
        this.notes = value
    }

    /**
     * @param value Identifier for the directory consumer account with whom the directory is to be shared. See below.
     * The following arguments are optional:
     */
    @JvmName("belldbipukykekio")
    public suspend fun target(`value`: Output<SharedDirectoryTargetArgs>) {
        this.target = value
    }

    /**
     * @param value Identifier of the Managed Microsoft AD directory that you want to share with other accounts.
     */
    @JvmName("ouygdqldnskcgrtv")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value Method used when sharing a directory. Valid values are `ORGANIZATIONS` and `HANDSHAKE`. Default is `HANDSHAKE`.
     */
    @JvmName("hltavodrttavjsnj")
    public suspend fun method(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value Message sent by the directory owner to the directory consumer to help the directory consumer administrator determine whether to approve or reject the share invitation.
     */
    @JvmName("gudanfdxdsyerqln")
    public suspend fun notes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notes = mapped
    }

    /**
     * @param value Identifier for the directory consumer account with whom the directory is to be shared. See below.
     * The following arguments are optional:
     */
    @JvmName("gucmydsyniclhmst")
    public suspend fun target(`value`: SharedDirectoryTargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param argument Identifier for the directory consumer account with whom the directory is to be shared. See below.
     * The following arguments are optional:
     */
    @JvmName("wrpgmdyyqfdqclet")
    public suspend fun target(argument: suspend SharedDirectoryTargetArgsBuilder.() -> Unit) {
        val toBeMapped = SharedDirectoryTargetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.target = mapped
    }

    internal fun build(): SharedDirectoryArgs = SharedDirectoryArgs(
        directoryId = directoryId,
        method = method,
        notes = notes,
        target = target,
    )
}
