@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Trust].
 */
@PulumiTagMarker
public class TrustResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrustArgs = TrustArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrustArgsBuilder.() -> Unit) {
        val builder = TrustArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Trust {
        val builtJavaResource = com.pulumi.aws.directoryservice.Trust(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Trust(builtJavaResource)
    }
}

/**
 * Manages a trust relationship between two Active Directory Directories.
 * The directories may either be both AWS Managed Microsoft AD domains or an AWS Managed Microsoft AD domain and a self-managed Active Directory Domain.
 * The Trust relationship must be configured on both sides of the relationship.
 * If a Trust has only been created on one side, it will be in the state `VerifyFailed`.
 * Once the second Trust is created, the first will update to the correct state.
 * ## Example Usage
 * ### Two-Way Trust
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.Trust;
 * import com.pulumi.aws.directoryservice.TrustArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var oneDirectory = new Directory("oneDirectory", DirectoryArgs.builder()
 *             .name("one.example.com")
 *             .type("MicrosoftAD")
 *             .build());
 *         var twoDirectory = new Directory("twoDirectory", DirectoryArgs.builder()
 *             .name("two.example.com")
 *             .type("MicrosoftAD")
 *             .build());
 *         var oneTrust = new Trust("oneTrust", TrustArgs.builder()
 *             .directoryId(oneDirectory.id())
 *             .remoteDomainName(twoDirectory.name())
 *             .trustDirection("Two-Way")
 *             .trustPassword("Some0therPassword")
 *             .conditionalForwarderIpAddrs(twoDirectory.dnsIpAddresses())
 *             .build());
 *         var twoTrust = new Trust("twoTrust", TrustArgs.builder()
 *             .directoryId(twoDirectory.id())
 *             .remoteDomainName(oneDirectory.name())
 *             .trustDirection("Two-Way")
 *             .trustPassword("Some0therPassword")
 *             .conditionalForwarderIpAddrs(oneDirectory.dnsIpAddresses())
 *             .build());
 *     }
 * }
 * ```
 * ### One-Way Trust
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.Trust;
 * import com.pulumi.aws.directoryservice.TrustArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var oneDirectory = new Directory("oneDirectory", DirectoryArgs.builder()
 *             .name("one.example.com")
 *             .type("MicrosoftAD")
 *             .build());
 *         var twoDirectory = new Directory("twoDirectory", DirectoryArgs.builder()
 *             .name("two.example.com")
 *             .type("MicrosoftAD")
 *             .build());
 *         var oneTrust = new Trust("oneTrust", TrustArgs.builder()
 *             .directoryId(oneDirectory.id())
 *             .remoteDomainName(twoDirectory.name())
 *             .trustDirection("One-Way: Incoming")
 *             .trustPassword("Some0therPassword")
 *             .conditionalForwarderIpAddrs(twoDirectory.dnsIpAddresses())
 *             .build());
 *         var twoTrust = new Trust("twoTrust", TrustArgs.builder()
 *             .directoryId(twoDirectory.id())
 *             .remoteDomainName(oneDirectory.name())
 *             .trustDirection("One-Way: Outgoing")
 *             .trustPassword("Some0therPassword")
 *             .conditionalForwarderIpAddrs(oneDirectory.dnsIpAddresses())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the Trust relationship using the directory ID and remote domain name, separated by a `/`. For example:
 * ```sh
 *  $ pulumi import aws:directoryservice/trust:Trust example d-926724cf57/directory.example.com
 * ```
 *
 */
public class Trust internal constructor(
    override val javaResource: com.pulumi.aws.directoryservice.Trust,
) : KotlinCustomResource(javaResource, TrustMapper) {
    /**
     * Set of IPv4 addresses for the DNS server associated with the remote Directory.
     * Can contain between 1 and 4 values.
     */
    public val conditionalForwarderIpAddrs: Output<List<String>>?
        get() = javaResource.conditionalForwarderIpAddrs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Date and time when the Trust was created.
     */
    public val createdDateTime: Output<String>
        get() = javaResource.createdDateTime().applyValue({ args0 -> args0 })

    /**
     * Whether to delete the conditional forwarder when deleting the Trust relationship.
     */
    public val deleteAssociatedConditionalForwarder: Output<Boolean>
        get() = javaResource.deleteAssociatedConditionalForwarder().applyValue({ args0 -> args0 })

    /**
     * ID of the Directory.
     */
    public val directoryId: Output<String>
        get() = javaResource.directoryId().applyValue({ args0 -> args0 })

    /**
     * Date and time when the Trust was last updated.
     */
    public val lastUpdatedDateTime: Output<String>
        get() = javaResource.lastUpdatedDateTime().applyValue({ args0 -> args0 })

    /**
     * Fully qualified domain name of the remote Directory.
     */
    public val remoteDomainName: Output<String>
        get() = javaResource.remoteDomainName().applyValue({ args0 -> args0 })

    /**
     * Whether to enable selective authentication.
     * Valid values are `Enabled` and `Disabled`.
     * Default value is `Disabled`.
     */
    public val selectiveAuth: Output<String>
        get() = javaResource.selectiveAuth().applyValue({ args0 -> args0 })

    /**
     * Date and time when the Trust state in `trust_state` was last updated.
     */
    public val stateLastUpdatedDateTime: Output<String>
        get() = javaResource.stateLastUpdatedDateTime().applyValue({ args0 -> args0 })

    /**
     * The direction of the Trust relationship.
     * Valid values are `One-Way: Outgoing`, `One-Way: Incoming`, and `Two-Way`.
     */
    public val trustDirection: Output<String>
        get() = javaResource.trustDirection().applyValue({ args0 -> args0 })

    /**
     * Password for the Trust.
     * Does not need to match the passwords for either Directory.
     * Can contain upper- and lower-case letters, numbers, and punctuation characters.
     * May be up to 128 characters long.
     */
    public val trustPassword: Output<String>
        get() = javaResource.trustPassword().applyValue({ args0 -> args0 })

    /**
     * State of the Trust relationship.
     * One of `Created`, `VerifyFailed`,`Verified`, `UpdateFailed`,`Updated`,`Deleted`, or `Failed`.
     */
    public val trustState: Output<String>
        get() = javaResource.trustState().applyValue({ args0 -> args0 })

    /**
     * Reason for the Trust state set in `trust_state`.
     */
    public val trustStateReason: Output<String>
        get() = javaResource.trustStateReason().applyValue({ args0 -> args0 })

    /**
     * Type of the Trust relationship.
     * Valid values are `Forest` and `External`.
     * Default value is `Forest`.
     */
    public val trustType: Output<String>
        get() = javaResource.trustType().applyValue({ args0 -> args0 })
}

public object TrustMapper : ResourceMapper<Trust> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directoryservice.Trust::class == javaResource::class

    override fun map(javaResource: Resource): Trust = Trust(
        javaResource as
            com.pulumi.aws.directoryservice.Trust,
    )
}

/**
 * @see [Trust].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Trust].
 */
public suspend fun trust(name: String, block: suspend TrustResourceBuilder.() -> Unit): Trust {
    val builder = TrustResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Trust].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trust(name: String): Trust {
    val builder = TrustResourceBuilder()
    builder.name(name)
    return builder.build()
}
