@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin.inputs

import com.pulumi.aws.directoryservice.inputs.DirectoryConnectSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property availabilityZones
 * @property connectIps The IP addresses of the AD Connector servers.
 * @property customerDnsIps The DNS IP addresses of the domain to connect to.
 * @property customerUsername The username corresponding to the password provided.
 * @property subnetIds The identifiers of the subnets for the directory servers (2 subnets in 2 different AZs).
 * @property vpcId The identifier of the VPC that the directory is in.
 */
public data class DirectoryConnectSettingsArgs(
    public val availabilityZones: Output<List<String>>? = null,
    public val connectIps: Output<List<String>>? = null,
    public val customerDnsIps: Output<List<String>>,
    public val customerUsername: Output<String>,
    public val subnetIds: Output<List<String>>,
    public val vpcId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.directoryservice.inputs.DirectoryConnectSettingsArgs> {
    override fun toJava(): com.pulumi.aws.directoryservice.inputs.DirectoryConnectSettingsArgs =
        com.pulumi.aws.directoryservice.inputs.DirectoryConnectSettingsArgs.builder()
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectIps(connectIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customerDnsIps(customerDnsIps.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .customerUsername(customerUsername.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcId(vpcId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DirectoryConnectSettingsArgs].
 */
@PulumiTagMarker
public class DirectoryConnectSettingsArgsBuilder internal constructor() {
    private var availabilityZones: Output<List<String>>? = null

    private var connectIps: Output<List<String>>? = null

    private var customerDnsIps: Output<List<String>>? = null

    private var customerUsername: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("klnewvddkxpnhilu")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("cpnnthsmxiqdudlh")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ywxmnoprmckeqyoo")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value The IP addresses of the AD Connector servers.
     */
    @JvmName("jxblkibjakcstjwm")
    public suspend fun connectIps(`value`: Output<List<String>>) {
        this.connectIps = value
    }

    @JvmName("twihbjjhgdpylfwe")
    public suspend fun connectIps(vararg values: Output<String>) {
        this.connectIps = Output.all(values.asList())
    }

    /**
     * @param values The IP addresses of the AD Connector servers.
     */
    @JvmName("lywschjsejiiqkmf")
    public suspend fun connectIps(values: List<Output<String>>) {
        this.connectIps = Output.all(values)
    }

    /**
     * @param value The DNS IP addresses of the domain to connect to.
     */
    @JvmName("kouwcdhewdxxpgok")
    public suspend fun customerDnsIps(`value`: Output<List<String>>) {
        this.customerDnsIps = value
    }

    @JvmName("voisgpwpcchqfmiv")
    public suspend fun customerDnsIps(vararg values: Output<String>) {
        this.customerDnsIps = Output.all(values.asList())
    }

    /**
     * @param values The DNS IP addresses of the domain to connect to.
     */
    @JvmName("aqtcjdkpawykpcpa")
    public suspend fun customerDnsIps(values: List<Output<String>>) {
        this.customerDnsIps = Output.all(values)
    }

    /**
     * @param value The username corresponding to the password provided.
     */
    @JvmName("xqdkwifemdspfbkb")
    public suspend fun customerUsername(`value`: Output<String>) {
        this.customerUsername = value
    }

    /**
     * @param value The identifiers of the subnets for the directory servers (2 subnets in 2 different AZs).
     */
    @JvmName("isquirokfsspbrvd")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("eydcdotutkgpwcay")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values The identifiers of the subnets for the directory servers (2 subnets in 2 different AZs).
     */
    @JvmName("omssylgidobaxgwb")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value The identifier of the VPC that the directory is in.
     */
    @JvmName("rcwwjddniiblsvmj")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value
     */
    @JvmName("jpcbfwhmmitcygjc")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values
     */
    @JvmName("xwcjyhudjjatcgyn")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value The IP addresses of the AD Connector servers.
     */
    @JvmName("iyximynxhfskrebx")
    public suspend fun connectIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectIps = mapped
    }

    /**
     * @param values The IP addresses of the AD Connector servers.
     */
    @JvmName("ervmilvugwtoagsu")
    public suspend fun connectIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectIps = mapped
    }

    /**
     * @param value The DNS IP addresses of the domain to connect to.
     */
    @JvmName("cbrvrrvqqsptapnj")
    public suspend fun customerDnsIps(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customerDnsIps = mapped
    }

    /**
     * @param values The DNS IP addresses of the domain to connect to.
     */
    @JvmName("mmrstvcjjribflrc")
    public suspend fun customerDnsIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customerDnsIps = mapped
    }

    /**
     * @param value The username corresponding to the password provided.
     */
    @JvmName("qmnjwhlxtfvgyabs")
    public suspend fun customerUsername(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customerUsername = mapped
    }

    /**
     * @param value The identifiers of the subnets for the directory servers (2 subnets in 2 different AZs).
     */
    @JvmName("chbisewtjpgeavkj")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values The identifiers of the subnets for the directory servers (2 subnets in 2 different AZs).
     */
    @JvmName("iefdpvrbynhekxvb")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value The identifier of the VPC that the directory is in.
     */
    @JvmName("mckmfgbrulecedpi")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): DirectoryConnectSettingsArgs = DirectoryConnectSettingsArgs(
        availabilityZones = availabilityZones,
        connectIps = connectIps,
        customerDnsIps = customerDnsIps ?: throw PulumiNullFieldException("customerDnsIps"),
        customerUsername = customerUsername ?: throw PulumiNullFieldException("customerUsername"),
        subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
        vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
    )
}
