@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin.inputs

import com.pulumi.aws.directoryservice.inputs.DirectoryVpcSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property availabilityZones
 * @property subnetIds The identifiers of the subnets for the directory servers (2 subnets in 2 different AZs).
 * @property vpcId The identifier of the VPC that the directory is in.
 */
public data class DirectoryVpcSettingsArgs(
    public val availabilityZones: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>,
    public val vpcId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.directoryservice.inputs.DirectoryVpcSettingsArgs> {
    override fun toJava(): com.pulumi.aws.directoryservice.inputs.DirectoryVpcSettingsArgs =
        com.pulumi.aws.directoryservice.inputs.DirectoryVpcSettingsArgs.builder()
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcId(vpcId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DirectoryVpcSettingsArgs].
 */
@PulumiTagMarker
public class DirectoryVpcSettingsArgsBuilder internal constructor() {
    private var availabilityZones: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ehsbbbhcyshardfv")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("qxiwubrjemrgbpea")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("iflgvruwodpwvuqc")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value The identifiers of the subnets for the directory servers (2 subnets in 2 different AZs).
     */
    @JvmName("sojontrjijeqtmkj")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("wkrlothbbjohmrxv")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values The identifiers of the subnets for the directory servers (2 subnets in 2 different AZs).
     */
    @JvmName("hdlmwkpjvettrauf")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value The identifier of the VPC that the directory is in.
     */
    @JvmName("trhwioagdeyhsrnc")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value
     */
    @JvmName("phbayqybtbxtgeac")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values
     */
    @JvmName("wegtnfwixefqjaet")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value The identifiers of the subnets for the directory servers (2 subnets in 2 different AZs).
     */
    @JvmName("tnyvoakmxwipyqwe")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values The identifiers of the subnets for the directory servers (2 subnets in 2 different AZs).
     */
    @JvmName("rsmnqwelgrklpemc")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value The identifier of the VPC that the directory is in.
     */
    @JvmName("cnjcywpibnuxjywn")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): DirectoryVpcSettingsArgs = DirectoryVpcSettingsArgs(
        availabilityZones = availabilityZones,
        subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
        vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
    )
}
