@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property authenticationProtocol The protocol specified for your RADIUS endpoints.
 * @property displayLabel Display label.
 * @property radiusPort Port that your RADIUS server is using for communications.
 * @property radiusRetries Maximum number of times that communication with the RADIUS server is attempted.
 * @property radiusServers Set of strings that contains the fully qualified domain name (FQDN) or IP addresses of the RADIUS server endpoints, or the FQDN or IP addresses of your RADIUS server load balancer.
 * @property radiusTimeout Amount of time, in seconds, to wait for the RADIUS server to respond.
 * @property useSameUsername Not currently used.
 */
public data class GetDirectoryRadiusSetting(
    public val authenticationProtocol: String,
    public val displayLabel: String,
    public val radiusPort: Int,
    public val radiusRetries: Int,
    public val radiusServers: List<String>,
    public val radiusTimeout: Int,
    public val useSameUsername: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.directoryservice.outputs.GetDirectoryRadiusSetting):
            GetDirectoryRadiusSetting = GetDirectoryRadiusSetting(
            authenticationProtocol = javaType.authenticationProtocol(),
            displayLabel = javaType.displayLabel(),
            radiusPort = javaType.radiusPort(),
            radiusRetries = javaType.radiusRetries(),
            radiusServers = javaType.radiusServers().map({ args0 -> args0 }),
            radiusTimeout = javaType.radiusTimeout(),
            useSameUsername = javaType.useSameUsername(),
        )
    }
}
