@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getDirectory.
 * @property accessUrl Access URL for the directory/connector, such as http://alias.awsapps.com.
 * @property alias Alias for the directory/connector, such as `d-991708b282.awsapps.com`.
 * @property connectSettings
 * @property description Textual description for the directory/connector.
 * @property directoryId
 * @property dnsIpAddresses List of IP addresses of the DNS servers for the directory/connector.
 * @property edition (for `MicrosoftAD`) Microsoft AD edition (`Standard` or `Enterprise`).
 * @property enableSso Directory/connector single-sign on status.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Fully qualified name for the directory/connector.
 * @property radiusSettings
 * @property securityGroupId ID of the security group created by the directory/connector.
 * @property shortName Short name of the directory/connector, such as `CORP`.
 * @property size (for `SimpleAD` and `ADConnector`) Size of the directory/connector (`Small` or `Large`).
 * @property tags A map of tags assigned to the directory/connector.
 * @property type Directory type (`SimpleAD`, `ADConnector` or `MicrosoftAD`).
 * @property vpcSettings
 */
public data class GetDirectoryResult(
    public val accessUrl: String,
    public val alias: String,
    public val connectSettings: List<GetDirectoryConnectSetting>,
    public val description: String,
    public val directoryId: String,
    public val dnsIpAddresses: List<String>,
    public val edition: String,
    public val enableSso: Boolean,
    public val id: String,
    public val name: String,
    public val radiusSettings: List<GetDirectoryRadiusSetting>,
    public val securityGroupId: String,
    public val shortName: String,
    public val size: String,
    public val tags: Map<String, String>,
    public val type: String,
    public val vpcSettings: List<GetDirectoryVpcSetting>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.directoryservice.outputs.GetDirectoryResult):
            GetDirectoryResult = GetDirectoryResult(
            accessUrl = javaType.accessUrl(),
            alias = javaType.alias(),
            connectSettings = javaType.connectSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.directoryservice.kotlin.outputs.GetDirectoryConnectSetting.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description(),
            directoryId = javaType.directoryId(),
            dnsIpAddresses = javaType.dnsIpAddresses().map({ args0 -> args0 }),
            edition = javaType.edition(),
            enableSso = javaType.enableSso(),
            id = javaType.id(),
            name = javaType.name(),
            radiusSettings = javaType.radiusSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.directoryservice.kotlin.outputs.GetDirectoryRadiusSetting.Companion.toKotlin(args0)
                })
            }),
            securityGroupId = javaType.securityGroupId(),
            shortName = javaType.shortName(),
            size = javaType.size(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vpcSettings = javaType.vpcSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.directoryservice.kotlin.outputs.GetDirectoryVpcSetting.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
