@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZones
 * @property subnetIds Identifiers of the subnets for the connector servers (2 subnets in 2 different AZs).
 * @property vpcId ID of the VPC that the connector is in.
 */
public data class GetDirectoryVpcSetting(
    public val availabilityZones: List<String>,
    public val subnetIds: List<String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.directoryservice.outputs.GetDirectoryVpcSetting):
            GetDirectoryVpcSetting = GetDirectoryVpcSetting(
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            vpcId = javaType.vpcId(),
        )
    }
}
