@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directoryservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id Identifier of the directory consumer account.
 * @property type Type of identifier to be used in the `id` field. Valid value is `ACCOUNT`. Default is `ACCOUNT`.
 */
public data class SharedDirectoryTarget(
    public val id: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.directoryservice.outputs.SharedDirectoryTarget):
            SharedDirectoryTarget = SharedDirectoryTarget(
            id = javaType.id(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
