@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin

import com.pulumi.aws.dlm.kotlin.outputs.LifecyclePolicyPolicyDetails
import com.pulumi.aws.dlm.kotlin.outputs.LifecyclePolicyPolicyDetails.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [LifecyclePolicy].
 */
@PulumiTagMarker
public class LifecyclePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LifecyclePolicyArgs = LifecyclePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LifecyclePolicyArgsBuilder.() -> Unit) {
        val builder = LifecyclePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LifecyclePolicy {
        val builtJavaResource = com.pulumi.aws.dlm.LifecyclePolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LifecyclePolicy(builtJavaResource)
    }
}

/**
 * Provides a [Data Lifecycle Manager (DLM) lifecycle policy](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshot-lifecycle.html) for managing snapshots.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.dlm.LifecyclePolicy;
 * import com.pulumi.aws.dlm.LifecyclePolicyArgs;
 * import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("dlm.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var dlmLifecycleRole = new Role("dlmLifecycleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var dlmLifecyclePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "ec2:CreateSnapshot",
 *                         "ec2:CreateSnapshots",
 *                         "ec2:DeleteSnapshot",
 *                         "ec2:DescribeInstances",
 *                         "ec2:DescribeVolumes",
 *                         "ec2:DescribeSnapshots")
 *                     .resources("*")
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("ec2:CreateTags")
 *                     .resources("arn:aws:ec2:*::snapshot/*")
 *                     .build())
 *             .build());
 *         var dlmLifecycleRolePolicy = new RolePolicy("dlmLifecycleRolePolicy", RolePolicyArgs.builder()
 *             .role(dlmLifecycleRole.id())
 *             .policy(dlmLifecyclePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var example = new LifecyclePolicy("example", LifecyclePolicyArgs.builder()
 *             .description("example DLM lifecycle policy")
 *             .executionRoleArn(dlmLifecycleRole.arn())
 *             .state("ENABLED")
 *             .policyDetails(LifecyclePolicyPolicyDetailsArgs.builder()
 *                 .resourceTypes("VOLUME")
 *                 .schedules(LifecyclePolicyPolicyDetailsScheduleArgs.builder()
 *                     .name("2 weeks of daily snapshots")
 *                     .createRule(LifecyclePolicyPolicyDetailsScheduleCreateRuleArgs.builder()
 *                         .interval(24)
 *                         .intervalUnit("HOURS")
 *                         .times("23:45")
 *                         .build())
 *                     .retainRule(LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs.builder()
 *                         .count(14)
 *                         .build())
 *                     .tagsToAdd(Map.of("SnapshotCreator", "DLM"))
 *                     .copyTags(false)
 *                     .build())
 *                 .targetTags(Map.of("Snapshot", "true"))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example Cross-Region Snapshot Copy Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.dlm.LifecyclePolicy;
 * import com.pulumi.aws.dlm.LifecyclePolicyArgs;
 * import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var key = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("Enable IAM User Permissions")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers(String.format("arn:aws:iam::%s:root", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                     .build())
 *                 .actions("kms:*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var dlmCrossRegionCopyCmk = new Key("dlmCrossRegionCopyCmk", KeyArgs.builder()
 *             .description("Example Alternate Region KMS Key")
 *             .policy(key.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.alternate())
 *                 .build());
 *         var example = new LifecyclePolicy("example", LifecyclePolicyArgs.builder()
 *             .description("example DLM lifecycle policy")
 *             .executionRoleArn(aws_iam_role.dlm_lifecycle_role().arn())
 *             .state("ENABLED")
 *             .policyDetails(LifecyclePolicyPolicyDetailsArgs.builder()
 *                 .resourceTypes("VOLUME")
 *                 .schedules(LifecyclePolicyPolicyDetailsScheduleArgs.builder()
 *                     .name("2 weeks of daily snapshots")
 *                     .createRule(LifecyclePolicyPolicyDetailsScheduleCreateRuleArgs.builder()
 *                         .interval(24)
 *                         .intervalUnit("HOURS")
 *                         .times("23:45")
 *                         .build())
 *                     .retainRule(LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs.builder()
 *                         .count(14)
 *                         .build())
 *                     .tagsToAdd(Map.of("SnapshotCreator", "DLM"))
 *                     .copyTags(false)
 *                     .crossRegionCopyRules(LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs.builder()
 *                         .target("us-west-2")
 *                         .encrypted(true)
 *                         .cmkArn(dlmCrossRegionCopyCmk.arn())
 *                         .copyTags(true)
 *                         .retainRule(LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRuleArgs.builder()
 *                             .interval(30)
 *                             .intervalUnit("DAYS")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .targetTags(Map.of("Snapshot", "true"))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example Event Based Policy Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.dlm.LifecyclePolicy;
 * import com.pulumi.aws.dlm.LifecyclePolicyArgs;
 * import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsArgs;
 * import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsActionArgs;
 * import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsEventSourceArgs;
 * import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsEventSourceParametersArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         var exampleLifecyclePolicy = new LifecyclePolicy("exampleLifecyclePolicy", LifecyclePolicyArgs.builder()
 *             .description("tf-acc-basic")
 *             .executionRoleArn(aws_iam_role.example().arn())
 *             .policyDetails(LifecyclePolicyPolicyDetailsArgs.builder()
 *                 .policyType("EVENT_BASED_POLICY")
 *                 .action(LifecyclePolicyPolicyDetailsActionArgs.builder()
 *                     .name("tf-acc-basic")
 *                     .crossRegionCopies(LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs.builder()
 *                         .encryptionConfiguration()
 *                         .retainRule(LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRuleArgs.builder()
 *                             .interval(15)
 *                             .intervalUnit("MONTHS")
 *                             .build())
 *                         .target("us-east-1")
 *                         .build())
 *                     .build())
 *                 .eventSource(LifecyclePolicyPolicyDetailsEventSourceArgs.builder()
 *                     .type("MANAGED_CWE")
 *                     .parameters(LifecyclePolicyPolicyDetailsEventSourceParametersArgs.builder()
 *                         .descriptionRegex("^.*Created for policy: policy-1234567890abcdef0.*$")
 *                         .eventType("shareSnapshot")
 *                         .snapshotOwners(current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId()))
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *         final var examplePolicy = IamFunctions.getPolicy(GetPolicyArgs.builder()
 *             .name("AWSDataLifecycleManagerServiceRole")
 *             .build());
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment("exampleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(aws_iam_role.example().id())
 *             .policyArn(examplePolicy.applyValue(getPolicyResult -> getPolicyResult.arn()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DLM lifecycle policies using their policy ID. For example:
 * ```sh
 *  $ pulumi import aws:dlm/lifecyclePolicy:LifecyclePolicy example policy-abcdef12345678901
 * ```
 * */
 */
public class LifecyclePolicy internal constructor(
    override val javaResource: com.pulumi.aws.dlm.LifecyclePolicy,
) : KotlinCustomResource(javaResource, LifecyclePolicyMapper) {
    /**
     * Amazon Resource Name (ARN) of the DLM Lifecycle Policy.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A description for the DLM lifecycle policy.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The ARN of an IAM role that is able to be assumed by the DLM service.
     */
    public val executionRoleArn: Output<String>
        get() = javaResource.executionRoleArn().applyValue({ args0 -> args0 })

    /**
     * See the `policy_details` configuration block. Max of 1.
     */
    public val policyDetails: Output<LifecyclePolicyPolicyDetails>
        get() = javaResource.policyDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Whether the lifecycle policy should be enabled or disabled. `ENABLED` or `DISABLED` are valid values. Defaults to `ENABLED`.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object LifecyclePolicyMapper : ResourceMapper<LifecyclePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dlm.LifecyclePolicy::class == javaResource::class

    override fun map(javaResource: Resource): LifecyclePolicy = LifecyclePolicy(
        javaResource as
            com.pulumi.aws.dlm.LifecyclePolicy,
    )
}

/**
 * @see [LifecyclePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LifecyclePolicy].
 */
public suspend fun lifecyclePolicy(
    name: String,
    block: suspend LifecyclePolicyResourceBuilder.() -> Unit,
): LifecyclePolicy {
    val builder = LifecyclePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LifecyclePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun lifecyclePolicy(name: String): LifecyclePolicy {
    val builder = LifecyclePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
