@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.inputs

import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property encryptionConfiguration The encryption settings for the copied snapshot. See the `encryption_configuration` block. Max of 1 per action.
 * @property retainRule Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
 * @property target The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
 */
public data class LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs(
    public val encryptionConfiguration:
    Output<LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfigurationArgs>,
    public val retainRule: Output<LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRuleArgs>? =
        null,
    public val target: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs> {
    override fun toJava():
        com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs =
        com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs.builder()
            .encryptionConfiguration(
                encryptionConfiguration.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .retainRule(retainRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .target(target.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs].
 */
@PulumiTagMarker
public class LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgsBuilder internal constructor() {
    private var encryptionConfiguration:
        Output<LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfigurationArgs>? = null

    private var retainRule: Output<LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRuleArgs>? =
        null

    private var target: Output<String>? = null

    /**
     * @param value The encryption settings for the copied snapshot. See the `encryption_configuration` block. Max of 1 per action.
     */
    @JvmName("jsduwgcrjjafcgqi")
    public suspend
    fun encryptionConfiguration(`value`: Output<LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfigurationArgs>) {
        this.encryptionConfiguration = value
    }

    /**
     * @param value Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
     */
    @JvmName("qwhdaibupddqioyj")
    public suspend
    fun retainRule(`value`: Output<LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRuleArgs>) {
        this.retainRule = value
    }

    /**
     * @param value The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
     */
    @JvmName("ipqxraunohwgipkm")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value The encryption settings for the copied snapshot. See the `encryption_configuration` block. Max of 1 per action.
     */
    @JvmName("pnkqdvrcmultysry")
    public suspend
    fun encryptionConfiguration(`value`: LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfigurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionConfiguration = mapped
    }

    /**
     * @param argument The encryption settings for the copied snapshot. See the `encryption_configuration` block. Max of 1 per action.
     */
    @JvmName("csjxexgxqiftkajy")
    public suspend
    fun encryptionConfiguration(argument: suspend LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.encryptionConfiguration = mapped
    }

    /**
     * @param value Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
     */
    @JvmName("xgijiybtxjvnisri")
    public suspend
    fun retainRule(`value`: LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retainRule = mapped
    }

    /**
     * @param argument Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
     */
    @JvmName("blahqlenywwdqfhr")
    public suspend
    fun retainRule(argument: suspend LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRuleArgsBuilder.() -> Unit) {
        val toBeMapped =
            LifecyclePolicyPolicyDetailsActionCrossRegionCopyRetainRuleArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.retainRule = mapped
    }

    /**
     * @param value The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
     */
    @JvmName("etggodefvhldhamm")
    public suspend fun target(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs =
        LifecyclePolicyPolicyDetailsActionCrossRegionCopyArgs(
            encryptionConfiguration = encryptionConfiguration ?: throw
                PulumiNullFieldException("encryptionConfiguration"),
            retainRule = retainRule,
            target = target ?: throw PulumiNullFieldException("target"),
        )
}
