@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.inputs

import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property copyTags Whether to copy all user-defined tags from the source snapshot to the cross-region snapshot copy.
 * @property createRule See the `create_rule` block. Max of 1 per schedule.
 * @property crossRegionCopyRules See the `cross_region_copy_rule` block. Max of 3 per schedule.
 * @property deprecateRule The AMI deprecation rule for cross-Region AMI copies created by the rule. See the `deprecate_rule` block.
 * @property fastRestoreRule See the `fast_restore_rule` block. Max of 1 per schedule.
 * @property name A descriptive name for the action.
 * @property retainRule Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
 * @property shareRule See the `share_rule` block. Max of 1 per schedule.
 * @property tagsToAdd A map of tag keys and their values. DLM lifecycle policies will already tag the snapshot with the tags on the volume. This configuration adds extra tags on top of these.
 * @property variableTags A map of tag keys and variable values, where the values are determined when the policy is executed. Only `$(instance-id)` or `$(timestamp)` are valid values. Can only be used when `resource_types` is `INSTANCE`.
 */
public data class LifecyclePolicyPolicyDetailsScheduleArgs(
    public val copyTags: Output<Boolean>? = null,
    public val createRule: Output<LifecyclePolicyPolicyDetailsScheduleCreateRuleArgs>,
    public val crossRegionCopyRules:
    Output<List<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs>>? = null,
    public val deprecateRule: Output<LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgs>? = null,
    public val fastRestoreRule: Output<LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgs>? =
        null,
    public val name: Output<String>,
    public val retainRule: Output<LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs>,
    public val shareRule: Output<LifecyclePolicyPolicyDetailsScheduleShareRuleArgs>? = null,
    public val tagsToAdd: Output<Map<String, String>>? = null,
    public val variableTags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleArgs> {
    override fun toJava(): com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleArgs =
        com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleArgs.builder()
            .copyTags(copyTags?.applyValue({ args0 -> args0 }))
            .createRule(createRule.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .crossRegionCopyRules(
                crossRegionCopyRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deprecateRule(deprecateRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fastRestoreRule(fastRestoreRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .retainRule(retainRule.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .shareRule(shareRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tagsToAdd(
                tagsToAdd?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .variableTags(
                variableTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LifecyclePolicyPolicyDetailsScheduleArgs].
 */
@PulumiTagMarker
public class LifecyclePolicyPolicyDetailsScheduleArgsBuilder internal constructor() {
    private var copyTags: Output<Boolean>? = null

    private var createRule: Output<LifecyclePolicyPolicyDetailsScheduleCreateRuleArgs>? = null

    private var crossRegionCopyRules:
        Output<List<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs>>? = null

    private var deprecateRule: Output<LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgs>? = null

    private var fastRestoreRule: Output<LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgs>? =
        null

    private var name: Output<String>? = null

    private var retainRule: Output<LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs>? = null

    private var shareRule: Output<LifecyclePolicyPolicyDetailsScheduleShareRuleArgs>? = null

    private var tagsToAdd: Output<Map<String, String>>? = null

    private var variableTags: Output<Map<String, String>>? = null

    /**
     * @param value Whether to copy all user-defined tags from the source snapshot to the cross-region snapshot copy.
     */
    @JvmName("oolfsrwcxvoldurn")
    public suspend fun copyTags(`value`: Output<Boolean>) {
        this.copyTags = value
    }

    /**
     * @param value See the `create_rule` block. Max of 1 per schedule.
     */
    @JvmName("oxrudehmuadfodwe")
    public suspend
    fun createRule(`value`: Output<LifecyclePolicyPolicyDetailsScheduleCreateRuleArgs>) {
        this.createRule = value
    }

    /**
     * @param value See the `cross_region_copy_rule` block. Max of 3 per schedule.
     */
    @JvmName("ajbongryubiwkspw")
    public suspend
    fun crossRegionCopyRules(`value`: Output<List<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs>>) {
        this.crossRegionCopyRules = value
    }

    @JvmName("lpfavrqvpqdunats")
    public suspend fun crossRegionCopyRules(
        vararg
        values: Output<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs>,
    ) {
        this.crossRegionCopyRules = Output.all(values.asList())
    }

    /**
     * @param values See the `cross_region_copy_rule` block. Max of 3 per schedule.
     */
    @JvmName("wjdkofeghjprdusb")
    public suspend
    fun crossRegionCopyRules(values: List<Output<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs>>) {
        this.crossRegionCopyRules = Output.all(values)
    }

    /**
     * @param value The AMI deprecation rule for cross-Region AMI copies created by the rule. See the `deprecate_rule` block.
     */
    @JvmName("owgwwkajplonwkhu")
    public suspend
    fun deprecateRule(`value`: Output<LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgs>) {
        this.deprecateRule = value
    }

    /**
     * @param value See the `fast_restore_rule` block. Max of 1 per schedule.
     */
    @JvmName("yiuoldfmiwaxgofg")
    public suspend
    fun fastRestoreRule(`value`: Output<LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgs>) {
        this.fastRestoreRule = value
    }

    /**
     * @param value A descriptive name for the action.
     */
    @JvmName("aojobillgucagtdu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
     */
    @JvmName("byafpwvllndswjej")
    public suspend
    fun retainRule(`value`: Output<LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs>) {
        this.retainRule = value
    }

    /**
     * @param value See the `share_rule` block. Max of 1 per schedule.
     */
    @JvmName("sabdvutlncsblofk")
    public suspend fun shareRule(`value`: Output<LifecyclePolicyPolicyDetailsScheduleShareRuleArgs>) {
        this.shareRule = value
    }

    /**
     * @param value A map of tag keys and their values. DLM lifecycle policies will already tag the snapshot with the tags on the volume. This configuration adds extra tags on top of these.
     */
    @JvmName("siwdtintstrdmsaq")
    public suspend fun tagsToAdd(`value`: Output<Map<String, String>>) {
        this.tagsToAdd = value
    }

    /**
     * @param value A map of tag keys and variable values, where the values are determined when the policy is executed. Only `$(instance-id)` or `$(timestamp)` are valid values. Can only be used when `resource_types` is `INSTANCE`.
     */
    @JvmName("msawmgagkbofdgkq")
    public suspend fun variableTags(`value`: Output<Map<String, String>>) {
        this.variableTags = value
    }

    /**
     * @param value Whether to copy all user-defined tags from the source snapshot to the cross-region snapshot copy.
     */
    @JvmName("hyqcacvnfgihtdvv")
    public suspend fun copyTags(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTags = mapped
    }

    /**
     * @param value See the `create_rule` block. Max of 1 per schedule.
     */
    @JvmName("liliqxnuxnbghrcx")
    public suspend fun createRule(`value`: LifecyclePolicyPolicyDetailsScheduleCreateRuleArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createRule = mapped
    }

    /**
     * @param argument See the `create_rule` block. Max of 1 per schedule.
     */
    @JvmName("abslttntxenddpmk")
    public suspend
    fun createRule(argument: suspend LifecyclePolicyPolicyDetailsScheduleCreateRuleArgsBuilder.() -> Unit) {
        val toBeMapped = LifecyclePolicyPolicyDetailsScheduleCreateRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.createRule = mapped
    }

    /**
     * @param value See the `cross_region_copy_rule` block. Max of 3 per schedule.
     */
    @JvmName("ijiufpitckmanton")
    public suspend
    fun crossRegionCopyRules(`value`: List<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossRegionCopyRules = mapped
    }

    /**
     * @param argument See the `cross_region_copy_rule` block. Max of 3 per schedule.
     */
    @JvmName("pkarluajwgntrtlx")
    public suspend
    fun crossRegionCopyRules(argument: List<suspend LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.crossRegionCopyRules = mapped
    }

    /**
     * @param argument See the `cross_region_copy_rule` block. Max of 3 per schedule.
     */
    @JvmName("txcjkmothnnetmrd")
    public suspend fun crossRegionCopyRules(
        vararg
        argument: suspend LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.crossRegionCopyRules = mapped
    }

    /**
     * @param argument See the `cross_region_copy_rule` block. Max of 3 per schedule.
     */
    @JvmName("jfyqgpfdjlmqnlca")
    public suspend
    fun crossRegionCopyRules(argument: suspend LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.crossRegionCopyRules = mapped
    }

    /**
     * @param values See the `cross_region_copy_rule` block. Max of 3 per schedule.
     */
    @JvmName("qyrcshkmdmluesgs")
    public suspend fun crossRegionCopyRules(
        vararg
        values: LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.crossRegionCopyRules = mapped
    }

    /**
     * @param value The AMI deprecation rule for cross-Region AMI copies created by the rule. See the `deprecate_rule` block.
     */
    @JvmName("aajqxtcxneafakil")
    public suspend
    fun deprecateRule(`value`: LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deprecateRule = mapped
    }

    /**
     * @param argument The AMI deprecation rule for cross-Region AMI copies created by the rule. See the `deprecate_rule` block.
     */
    @JvmName("vctylailtwgokgkd")
    public suspend
    fun deprecateRule(argument: suspend LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgsBuilder.() -> Unit) {
        val toBeMapped = LifecyclePolicyPolicyDetailsScheduleDeprecateRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.deprecateRule = mapped
    }

    /**
     * @param value See the `fast_restore_rule` block. Max of 1 per schedule.
     */
    @JvmName("xgqcgnnrnguukrsl")
    public suspend
    fun fastRestoreRule(`value`: LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fastRestoreRule = mapped
    }

    /**
     * @param argument See the `fast_restore_rule` block. Max of 1 per schedule.
     */
    @JvmName("pipcktgxfvpaiybw")
    public suspend
    fun fastRestoreRule(argument: suspend LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgsBuilder.() -> Unit) {
        val toBeMapped = LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fastRestoreRule = mapped
    }

    /**
     * @param value A descriptive name for the action.
     */
    @JvmName("csuqdcmkwvmxkxii")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
     */
    @JvmName("dhmyrbxmreblssab")
    public suspend fun retainRule(`value`: LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retainRule = mapped
    }

    /**
     * @param argument Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
     */
    @JvmName("xlvxyvhhlkvixthg")
    public suspend
    fun retainRule(argument: suspend LifecyclePolicyPolicyDetailsScheduleRetainRuleArgsBuilder.() -> Unit) {
        val toBeMapped = LifecyclePolicyPolicyDetailsScheduleRetainRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.retainRule = mapped
    }

    /**
     * @param value See the `share_rule` block. Max of 1 per schedule.
     */
    @JvmName("wgyacdoftkwvjnqt")
    public suspend fun shareRule(`value`: LifecyclePolicyPolicyDetailsScheduleShareRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareRule = mapped
    }

    /**
     * @param argument See the `share_rule` block. Max of 1 per schedule.
     */
    @JvmName("fqsribuosyyohukv")
    public suspend
    fun shareRule(argument: suspend LifecyclePolicyPolicyDetailsScheduleShareRuleArgsBuilder.() -> Unit) {
        val toBeMapped = LifecyclePolicyPolicyDetailsScheduleShareRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.shareRule = mapped
    }

    /**
     * @param value A map of tag keys and their values. DLM lifecycle policies will already tag the snapshot with the tags on the volume. This configuration adds extra tags on top of these.
     */
    @JvmName("ljgbcayiagvnwyui")
    public suspend fun tagsToAdd(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagsToAdd = mapped
    }

    /**
     * @param values A map of tag keys and their values. DLM lifecycle policies will already tag the snapshot with the tags on the volume. This configuration adds extra tags on top of these.
     */
    @JvmName("tdgycuonixgqctdw")
    public fun tagsToAdd(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagsToAdd = mapped
    }

    /**
     * @param value A map of tag keys and variable values, where the values are determined when the policy is executed. Only `$(instance-id)` or `$(timestamp)` are valid values. Can only be used when `resource_types` is `INSTANCE`.
     */
    @JvmName("kcclwcarqtootikc")
    public suspend fun variableTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variableTags = mapped
    }

    /**
     * @param values A map of tag keys and variable values, where the values are determined when the policy is executed. Only `$(instance-id)` or `$(timestamp)` are valid values. Can only be used when `resource_types` is `INSTANCE`.
     */
    @JvmName("ticmhsopirqkunlb")
    public fun variableTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variableTags = mapped
    }

    internal fun build(): LifecyclePolicyPolicyDetailsScheduleArgs =
        LifecyclePolicyPolicyDetailsScheduleArgs(
            copyTags = copyTags,
            createRule = createRule ?: throw PulumiNullFieldException("createRule"),
            crossRegionCopyRules = crossRegionCopyRules,
            deprecateRule = deprecateRule,
            fastRestoreRule = fastRestoreRule,
            name = name ?: throw PulumiNullFieldException("name"),
            retainRule = retainRule ?: throw PulumiNullFieldException("retainRule"),
            shareRule = shareRule,
            tagsToAdd = tagsToAdd,
            variableTags = variableTags,
        )
}
