@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.inputs

import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cmkArn The Amazon Resource Name (ARN) of the AWS KMS customer master key (CMK) to use for EBS encryption. If this argument is not specified, the default KMS key for the account is used.
 * @property copyTags Whether to copy all user-defined tags from the source snapshot to the cross-region snapshot copy.
 * @property deprecateRule The AMI deprecation rule for cross-Region AMI copies created by the rule. See the `deprecate_rule` block.
 * @property encrypted To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or if encryption by default is not enabled.
 * @property retainRule Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
 * @property target The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
 */
public data class LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs(
    public val cmkArn: Output<String>? = null,
    public val copyTags: Output<Boolean>? = null,
    public val deprecateRule:
    Output<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRuleArgs>? = null,
    public val encrypted: Output<Boolean>,
    public val retainRule:
    Output<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRuleArgs>? = null,
    public val target: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs> {
    override fun toJava():
        com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs =
        com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs.builder()
            .cmkArn(cmkArn?.applyValue({ args0 -> args0 }))
            .copyTags(copyTags?.applyValue({ args0 -> args0 }))
            .deprecateRule(deprecateRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .encrypted(encrypted.applyValue({ args0 -> args0 }))
            .retainRule(retainRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .target(target.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs].
 */
@PulumiTagMarker
public class LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgsBuilder internal
constructor() {
    private var cmkArn: Output<String>? = null

    private var copyTags: Output<Boolean>? = null

    private var deprecateRule:
        Output<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRuleArgs>? = null

    private var encrypted: Output<Boolean>? = null

    private var retainRule:
        Output<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRuleArgs>? = null

    private var target: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the AWS KMS customer master key (CMK) to use for EBS encryption. If this argument is not specified, the default KMS key for the account is used.
     */
    @JvmName("houkwupcqigdveyk")
    public suspend fun cmkArn(`value`: Output<String>) {
        this.cmkArn = value
    }

    /**
     * @param value Whether to copy all user-defined tags from the source snapshot to the cross-region snapshot copy.
     */
    @JvmName("gtdqiikbwowioujc")
    public suspend fun copyTags(`value`: Output<Boolean>) {
        this.copyTags = value
    }

    /**
     * @param value The AMI deprecation rule for cross-Region AMI copies created by the rule. See the `deprecate_rule` block.
     */
    @JvmName("yvqtpqnvmbhbaati")
    public suspend
    fun deprecateRule(`value`: Output<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRuleArgs>) {
        this.deprecateRule = value
    }

    /**
     * @param value To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or if encryption by default is not enabled.
     */
    @JvmName("rchlchtqxjcnghwy")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
     */
    @JvmName("divivcrlrtwxyvha")
    public suspend
    fun retainRule(`value`: Output<LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRuleArgs>) {
        this.retainRule = value
    }

    /**
     * @param value The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
     */
    @JvmName("labrodxssmeafykq")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the AWS KMS customer master key (CMK) to use for EBS encryption. If this argument is not specified, the default KMS key for the account is used.
     */
    @JvmName("hbxofchmrtjaemhp")
    public suspend fun cmkArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cmkArn = mapped
    }

    /**
     * @param value Whether to copy all user-defined tags from the source snapshot to the cross-region snapshot copy.
     */
    @JvmName("quslqajgevvuyjuy")
    public suspend fun copyTags(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTags = mapped
    }

    /**
     * @param value The AMI deprecation rule for cross-Region AMI copies created by the rule. See the `deprecate_rule` block.
     */
    @JvmName("molivrbwckjxcxxs")
    public suspend
    fun deprecateRule(`value`: LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deprecateRule = mapped
    }

    /**
     * @param argument The AMI deprecation rule for cross-Region AMI copies created by the rule. See the `deprecate_rule` block.
     */
    @JvmName("kohobvebbhwyabpc")
    public suspend
    fun deprecateRule(argument: suspend LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRuleArgsBuilder.() -> Unit) {
        val toBeMapped =
            LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRuleArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.deprecateRule = mapped
    }

    /**
     * @param value To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or if encryption by default is not enabled.
     */
    @JvmName("cqruskhqwvvgbyfb")
    public suspend fun encrypted(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
     */
    @JvmName("jsqgxrgjwjdffkhl")
    public suspend
    fun retainRule(`value`: LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retainRule = mapped
    }

    /**
     * @param argument Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
     */
    @JvmName("jevirdoylehekqgp")
    public suspend
    fun retainRule(argument: suspend LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRuleArgsBuilder.() -> Unit) {
        val toBeMapped =
            LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRuleArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.retainRule = mapped
    }

    /**
     * @param value The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
     */
    @JvmName("ctvsfihcsiytknsv")
    public suspend fun target(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs =
        LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleArgs(
            cmkArn = cmkArn,
            copyTags = copyTags,
            deprecateRule = deprecateRule,
            encrypted = encrypted ?: throw PulumiNullFieldException("encrypted"),
            retainRule = retainRule,
            target = target ?: throw PulumiNullFieldException("target"),
        )
}
