@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.inputs

import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property availabilityZones The Availability Zones in which to enable fast snapshot restore.
 * @property count Specifies the number of oldest AMIs to deprecate. Must be an integer between `1` and `1000`. Conflicts with `interval` and `interval_unit`.
 * @property interval How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
 * @property intervalUnit The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
 */
public data class LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgs(
    public val availabilityZones: Output<List<String>>,
    public val count: Output<Int>? = null,
    public val interval: Output<Int>? = null,
    public val intervalUnit: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgs> {
    override fun toJava():
        com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgs =
        com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgs.builder()
            .availabilityZones(availabilityZones.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .count(count?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .intervalUnit(intervalUnit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgs].
 */
@PulumiTagMarker
public class LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgsBuilder internal constructor() {
    private var availabilityZones: Output<List<String>>? = null

    private var count: Output<Int>? = null

    private var interval: Output<Int>? = null

    private var intervalUnit: Output<String>? = null

    /**
     * @param value The Availability Zones in which to enable fast snapshot restore.
     */
    @JvmName("fsmfpldpuwtqflqy")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("eodhgwxugpqsspyc")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values The Availability Zones in which to enable fast snapshot restore.
     */
    @JvmName("qmdrsnkdhjrshqnl")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value Specifies the number of oldest AMIs to deprecate. Must be an integer between `1` and `1000`. Conflicts with `interval` and `interval_unit`.
     */
    @JvmName("hdxixjxkiqfetavt")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
     */
    @JvmName("dgammdjgdgdgjitx")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
     */
    @JvmName("xebuyyksfjpvfppk")
    public suspend fun intervalUnit(`value`: Output<String>) {
        this.intervalUnit = value
    }

    /**
     * @param value The Availability Zones in which to enable fast snapshot restore.
     */
    @JvmName("wifbwhuaovaiffjn")
    public suspend fun availabilityZones(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values The Availability Zones in which to enable fast snapshot restore.
     */
    @JvmName("eorjsuxwqdupxgwe")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value Specifies the number of oldest AMIs to deprecate. Must be an integer between `1` and `1000`. Conflicts with `interval` and `interval_unit`.
     */
    @JvmName("meofdaeujoqsnvon")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
     */
    @JvmName("kgauqhovmngusffn")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
     */
    @JvmName("dqlbtaocktpenyhn")
    public suspend fun intervalUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intervalUnit = mapped
    }

    internal fun build(): LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgs =
        LifecyclePolicyPolicyDetailsScheduleFastRestoreRuleArgs(
            availabilityZones = availabilityZones ?: throw PulumiNullFieldException("availabilityZones"),
            count = count,
            interval = interval,
            intervalUnit = intervalUnit,
        )
}
