@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.inputs

import com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property count Specifies the number of oldest AMIs to deprecate. Must be an integer between `1` and `1000`. Conflicts with `interval` and `interval_unit`.
 * @property interval How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
 * @property intervalUnit The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
 */
public data class LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs(
    public val count: Output<Int>? = null,
    public val interval: Output<Int>? = null,
    public val intervalUnit: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs> {
    override fun toJava():
        com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs =
        com.pulumi.aws.dlm.inputs.LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs.builder()
            .count(count?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .intervalUnit(intervalUnit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs].
 */
@PulumiTagMarker
public class LifecyclePolicyPolicyDetailsScheduleRetainRuleArgsBuilder internal constructor() {
    private var count: Output<Int>? = null

    private var interval: Output<Int>? = null

    private var intervalUnit: Output<String>? = null

    /**
     * @param value Specifies the number of oldest AMIs to deprecate. Must be an integer between `1` and `1000`. Conflicts with `interval` and `interval_unit`.
     */
    @JvmName("yngxljaxgyjsrctb")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
     */
    @JvmName("tmucyanxyuhwwqub")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
     */
    @JvmName("qyqcfpjctbtbqeyg")
    public suspend fun intervalUnit(`value`: Output<String>) {
        this.intervalUnit = value
    }

    /**
     * @param value Specifies the number of oldest AMIs to deprecate. Must be an integer between `1` and `1000`. Conflicts with `interval` and `interval_unit`.
     */
    @JvmName("utttyksavljaaxtw")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
     */
    @JvmName("viwfgfesfscqopsm")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
     */
    @JvmName("urvfgxmgtoomicyh")
    public suspend fun intervalUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intervalUnit = mapped
    }

    internal fun build(): LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs =
        LifecyclePolicyPolicyDetailsScheduleRetainRuleArgs(
            count = count,
            interval = interval,
            intervalUnit = intervalUnit,
        )
}
