@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property crossRegionCopies The rule for copying shared snapshots across Regions. See the `cross_region_copy` configuration block.
 * @property name A descriptive name for the action.
 */
public data class LifecyclePolicyPolicyDetailsAction(
    public val crossRegionCopies: List<LifecyclePolicyPolicyDetailsActionCrossRegionCopy>,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dlm.outputs.LifecyclePolicyPolicyDetailsAction):
            LifecyclePolicyPolicyDetailsAction = LifecyclePolicyPolicyDetailsAction(
            crossRegionCopies = javaType.crossRegionCopies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.dlm.kotlin.outputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopy.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
        )
    }
}
