@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cmkArn The Amazon Resource Name (ARN) of the AWS KMS customer master key (CMK) to use for EBS encryption. If this argument is not specified, the default KMS key for the account is used.
 * @property encrypted To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or if encryption by default is not enabled.
 */
public data class LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfiguration(
    public val cmkArn: String? = null,
    public val encrypted: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.dlm.outputs.LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfiguration):
            LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfiguration =
            LifecyclePolicyPolicyDetailsActionCrossRegionCopyEncryptionConfiguration(
                cmkArn = javaType.cmkArn().map({ args0 -> args0 }).orElse(null),
                encrypted = javaType.encrypted().map({ args0 -> args0 }).orElse(null),
            )
    }
}
