@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property descriptionRegex The snapshot description that can trigger the policy. The description pattern is specified using a regular expression. The policy runs only if a snapshot with a description that matches the specified pattern is shared with your account.
 * @property eventType The type of event. Currently, only `shareSnapshot` events are supported.
 * @property snapshotOwners The IDs of the AWS accounts that can trigger policy by sharing snapshots with your account. The policy only runs if one of the specified AWS accounts shares a snapshot with your account.
 */
public data class LifecyclePolicyPolicyDetailsEventSourceParameters(
    public val descriptionRegex: String,
    public val eventType: String,
    public val snapshotOwners: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.dlm.outputs.LifecyclePolicyPolicyDetailsEventSourceParameters):
            LifecyclePolicyPolicyDetailsEventSourceParameters =
            LifecyclePolicyPolicyDetailsEventSourceParameters(
                descriptionRegex = javaType.descriptionRegex(),
                eventType = javaType.eventType(),
                snapshotOwners = javaType.snapshotOwners().map({ args0 -> args0 }),
            )
    }
}
