@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cronExpression The schedule, as a Cron expression. The schedule interval must be between 1 hour and 1 year. Conflicts with `interval`, `interval_unit`, and `times`.
 * @property interval How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
 * @property intervalUnit The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
 * @property location Specifies the destination for snapshots created by the policy. To create snapshots in the same Region as the source resource, specify `CLOUD`. To create snapshots on the same Outpost as the source resource, specify `OUTPOST_LOCAL`. If you omit this parameter, `CLOUD` is used by default. If the policy targets resources in an AWS Region, then you must create snapshots in the same Region as the source resource. If the policy targets resources on an Outpost, then you can create snapshots on the same Outpost as the source resource, or in the Region of that Outpost. Valid values are `CLOUD` and `OUTPOST_LOCAL`.
 * @property times A list of times in 24 hour clock format that sets when the lifecycle policy should be evaluated. Max of 1. Conflicts with `cron_expression`. Must be set if `interval` is set.
 */
public data class LifecyclePolicyPolicyDetailsScheduleCreateRule(
    public val cronExpression: String? = null,
    public val interval: Int? = null,
    public val intervalUnit: String? = null,
    public val location: String? = null,
    public val times: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.dlm.outputs.LifecyclePolicyPolicyDetailsScheduleCreateRule):
            LifecyclePolicyPolicyDetailsScheduleCreateRule =
            LifecyclePolicyPolicyDetailsScheduleCreateRule(
                cronExpression = javaType.cronExpression().map({ args0 -> args0 }).orElse(null),
                interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
                intervalUnit = javaType.intervalUnit().map({ args0 -> args0 }).orElse(null),
                location = javaType.location().map({ args0 -> args0 }).orElse(null),
                times = javaType.times().map({ args0 -> args0 }).orElse(null),
            )
    }
}
