@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cmkArn The Amazon Resource Name (ARN) of the AWS KMS customer master key (CMK) to use for EBS encryption. If this argument is not specified, the default KMS key for the account is used.
 * @property copyTags Whether to copy all user-defined tags from the source snapshot to the cross-region snapshot copy.
 * @property deprecateRule The AMI deprecation rule for cross-Region AMI copies created by the rule. See the `deprecate_rule` block.
 * @property encrypted To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or if encryption by default is not enabled.
 * @property retainRule Specifies the retention rule for cross-Region snapshot copies. See the `retain_rule` block. Max of 1 per action.
 * @property target The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
 */
public data class LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule(
    public val cmkArn: String? = null,
    public val copyTags: Boolean? = null,
    public val deprecateRule: LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRule? =
        null,
    public val encrypted: Boolean,
    public val retainRule: LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRule? = null,
    public val target: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.dlm.outputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule):
            LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule =
            LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRule(
                cmkArn = javaType.cmkArn().map({ args0 -> args0 }).orElse(null),
                copyTags = javaType.copyTags().map({ args0 -> args0 }).orElse(null),
                deprecateRule = javaType.deprecateRule().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.dlm.kotlin.outputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleDeprecateRule.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                encrypted = javaType.encrypted(),
                retainRule = javaType.retainRule().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.dlm.kotlin.outputs.LifecyclePolicyPolicyDetailsScheduleCrossRegionCopyRuleRetainRule.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                target = javaType.target(),
            )
    }
}
