@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dlm.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property count Specifies the number of oldest AMIs to deprecate. Must be an integer between `1` and `1000`. Conflicts with `interval` and `interval_unit`.
 * @property interval How often this lifecycle policy should be evaluated. `1`, `2`,`3`,`4`,`6`,`8`,`12` or `24` are valid values. Conflicts with `cron_expression`. If set, `interval_unit` and `times` must also be set.
 * @property intervalUnit The unit for how often the lifecycle policy should be evaluated. `HOURS` is currently the only allowed value and also the default value. Conflicts with `cron_expression`. Must be set if `interval` is set.
 */
public data class LifecyclePolicyPolicyDetailsScheduleRetainRule(
    public val count: Int? = null,
    public val interval: Int? = null,
    public val intervalUnit: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.dlm.outputs.LifecyclePolicyPolicyDetailsScheduleRetainRule):
            LifecyclePolicyPolicyDetailsScheduleRetainRule =
            LifecyclePolicyPolicyDetailsScheduleRetainRule(
                count = javaType.count().map({ args0 -> args0 }).orElse(null),
                interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
                intervalUnit = javaType.intervalUnit().map({ args0 -> args0 }).orElse(null),
            )
    }
}
