@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.aws.dms.DmsFunctions.getCertificatePlain
import com.pulumi.aws.dms.DmsFunctions.getEndpointPlain
import com.pulumi.aws.dms.DmsFunctions.getReplicationInstancePlain
import com.pulumi.aws.dms.DmsFunctions.getReplicationSubnetGroupPlain
import com.pulumi.aws.dms.DmsFunctions.getReplicationTaskPlain
import com.pulumi.aws.dms.kotlin.inputs.GetCertificatePlainArgs
import com.pulumi.aws.dms.kotlin.inputs.GetCertificatePlainArgsBuilder
import com.pulumi.aws.dms.kotlin.inputs.GetEndpointPlainArgs
import com.pulumi.aws.dms.kotlin.inputs.GetEndpointPlainArgsBuilder
import com.pulumi.aws.dms.kotlin.inputs.GetReplicationInstancePlainArgs
import com.pulumi.aws.dms.kotlin.inputs.GetReplicationInstancePlainArgsBuilder
import com.pulumi.aws.dms.kotlin.inputs.GetReplicationSubnetGroupPlainArgs
import com.pulumi.aws.dms.kotlin.inputs.GetReplicationSubnetGroupPlainArgsBuilder
import com.pulumi.aws.dms.kotlin.inputs.GetReplicationTaskPlainArgs
import com.pulumi.aws.dms.kotlin.inputs.GetReplicationTaskPlainArgsBuilder
import com.pulumi.aws.dms.kotlin.outputs.GetCertificateResult
import com.pulumi.aws.dms.kotlin.outputs.GetEndpointResult
import com.pulumi.aws.dms.kotlin.outputs.GetReplicationInstanceResult
import com.pulumi.aws.dms.kotlin.outputs.GetReplicationSubnetGroupResult
import com.pulumi.aws.dms.kotlin.outputs.GetReplicationTaskResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.dms.kotlin.outputs.GetCertificateResult.Companion.toKotlin as getCertificateResultToKotlin
import com.pulumi.aws.dms.kotlin.outputs.GetEndpointResult.Companion.toKotlin as getEndpointResultToKotlin
import com.pulumi.aws.dms.kotlin.outputs.GetReplicationInstanceResult.Companion.toKotlin as getReplicationInstanceResultToKotlin
import com.pulumi.aws.dms.kotlin.outputs.GetReplicationSubnetGroupResult.Companion.toKotlin as getReplicationSubnetGroupResultToKotlin
import com.pulumi.aws.dms.kotlin.outputs.GetReplicationTaskResult.Companion.toKotlin as getReplicationTaskResultToKotlin

public object DmsFunctions {
    /**
     * Data source for managing an AWS DMS (Database Migration) Certificate.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.dms.DmsFunctions;
     * import com.pulumi.aws.dms.inputs.GetCertificateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = DmsFunctions.getCertificate(GetCertificateArgs.builder()
     *             .certificateId(aws_dms_certificate.test().certificate_id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCertificate.
     * @return A collection of values returned by getCertificate.
     */
    public suspend fun getCertificate(argument: GetCertificatePlainArgs): GetCertificateResult =
        getCertificateResultToKotlin(getCertificatePlain(argument.toJava()).await())

    /**
     * @see [getCertificate].
     * @param certificateId A customer-assigned name for the certificate. Identifiers must begin with a letter and must contain only ASCII letters, digits, and hyphens. They can't end with a hyphen or contain two consecutive hyphens.
     * @param tags
     * @return A collection of values returned by getCertificate.
     */
    public suspend fun getCertificate(certificateId: String, tags: Map<String, String>? = null):
        GetCertificateResult {
        val argument = GetCertificatePlainArgs(
            certificateId = certificateId,
            tags = tags,
        )
        return getCertificateResultToKotlin(getCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;dms&#46;kotlin&#46;inputs&#46;GetCertificatePlainArgs].
     * @return A collection of values returned by getCertificate.
     */
    public suspend fun getCertificate(argument: suspend GetCertificatePlainArgsBuilder.() -> Unit):
        GetCertificateResult {
        val builder = GetCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCertificateResultToKotlin(getCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS DMS (Database Migration) Endpoint.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.dms.DmsFunctions;
     * import com.pulumi.aws.dms.inputs.GetEndpointArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = DmsFunctions.getEndpoint(GetEndpointArgs.builder()
     *             .endpointId("test_id")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getEndpoint.
     * @return A collection of values returned by getEndpoint.
     */
    public suspend fun getEndpoint(argument: GetEndpointPlainArgs): GetEndpointResult =
        getEndpointResultToKotlin(getEndpointPlain(argument.toJava()).await())

    /**
     * @see [getEndpoint].
     * @param endpointId Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
     * @param tags
     * @return A collection of values returned by getEndpoint.
     */
    public suspend fun getEndpoint(endpointId: String, tags: Map<String, String>? = null):
        GetEndpointResult {
        val argument = GetEndpointPlainArgs(
            endpointId = endpointId,
            tags = tags,
        )
        return getEndpointResultToKotlin(getEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;dms&#46;kotlin&#46;inputs&#46;GetEndpointPlainArgs].
     * @return A collection of values returned by getEndpoint.
     */
    public suspend fun getEndpoint(argument: suspend GetEndpointPlainArgsBuilder.() -> Unit):
        GetEndpointResult {
        val builder = GetEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEndpointResultToKotlin(getEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS DMS (Database Migration) Replication Instance.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.dms.DmsFunctions;
     * import com.pulumi.aws.dms.inputs.GetReplicationInstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = DmsFunctions.getReplicationInstance(GetReplicationInstanceArgs.builder()
     *             .replicationInstanceId(aws_dms_replication_instance.test().replication_instance_id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getReplicationInstance.
     * @return A collection of values returned by getReplicationInstance.
     */
    public suspend fun getReplicationInstance(argument: GetReplicationInstancePlainArgs):
        GetReplicationInstanceResult =
        getReplicationInstanceResultToKotlin(getReplicationInstancePlain(argument.toJava()).await())

    /**
     * @see [getReplicationInstance].
     * @param replicationInstanceId The replication instance identifier.
     * @param tags
     * @return A collection of values returned by getReplicationInstance.
     */
    public suspend fun getReplicationInstance(
        replicationInstanceId: String,
        tags: Map<String, String>? = null,
    ): GetReplicationInstanceResult {
        val argument = GetReplicationInstancePlainArgs(
            replicationInstanceId = replicationInstanceId,
            tags = tags,
        )
        return getReplicationInstanceResultToKotlin(getReplicationInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getReplicationInstance].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;dms&#46;kotlin&#46;inputs&#46;GetReplicationInstancePlainArgs].
     * @return A collection of values returned by getReplicationInstance.
     */
    public suspend
    fun getReplicationInstance(argument: suspend GetReplicationInstancePlainArgsBuilder.() -> Unit):
        GetReplicationInstanceResult {
        val builder = GetReplicationInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationInstanceResultToKotlin(getReplicationInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS DMS (Database Migration) Replication Subnet Group.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.dms.DmsFunctions;
     * import com.pulumi.aws.dms.inputs.GetReplicationSubnetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = DmsFunctions.getReplicationSubnetGroup(GetReplicationSubnetGroupArgs.builder()
     *             .replicationSubnetGroupId(aws_dms_replication_subnet_group.test().replication_subnet_group_id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getReplicationSubnetGroup.
     * @return A collection of values returned by getReplicationSubnetGroup.
     */
    public suspend fun getReplicationSubnetGroup(argument: GetReplicationSubnetGroupPlainArgs):
        GetReplicationSubnetGroupResult =
        getReplicationSubnetGroupResultToKotlin(getReplicationSubnetGroupPlain(argument.toJava()).await())

    /**
     * @see [getReplicationSubnetGroup].
     * @param replicationSubnetGroupId Name for the replication subnet group. This value is stored as a lowercase string. It must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens and cannot be `default`.
     * @param tags
     * @return A collection of values returned by getReplicationSubnetGroup.
     */
    public suspend fun getReplicationSubnetGroup(
        replicationSubnetGroupId: String,
        tags: Map<String, String>? = null,
    ): GetReplicationSubnetGroupResult {
        val argument = GetReplicationSubnetGroupPlainArgs(
            replicationSubnetGroupId = replicationSubnetGroupId,
            tags = tags,
        )
        return getReplicationSubnetGroupResultToKotlin(getReplicationSubnetGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplicationSubnetGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;dms&#46;kotlin&#46;inputs&#46;GetReplicationSubnetGroupPlainArgs].
     * @return A collection of values returned by getReplicationSubnetGroup.
     */
    public suspend
    fun getReplicationSubnetGroup(argument: suspend GetReplicationSubnetGroupPlainArgsBuilder.() -> Unit):
        GetReplicationSubnetGroupResult {
        val builder = GetReplicationSubnetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationSubnetGroupResultToKotlin(getReplicationSubnetGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS DMS (Database Migration) Replication Task.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.dms.DmsFunctions;
     * import com.pulumi.aws.dms.inputs.GetReplicationTaskArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = DmsFunctions.getReplicationTask(GetReplicationTaskArgs.builder()
     *             .replicationTaskId(aws_dms_replication_task.test().replication_task_id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getReplicationTask.
     * @return A collection of values returned by getReplicationTask.
     */
    public suspend fun getReplicationTask(argument: GetReplicationTaskPlainArgs):
        GetReplicationTaskResult =
        getReplicationTaskResultToKotlin(getReplicationTaskPlain(argument.toJava()).await())

    /**
     * @see [getReplicationTask].
     * @param replicationTaskId The replication task identifier.
     * - Must contain from 1 to 255 alphanumeric characters or hyphens.
     * - First character must be a letter.
     * - Cannot end with a hyphen.
     * - Cannot contain two consecutive hyphens.
     * @param tags
     * @return A collection of values returned by getReplicationTask.
     */
    public suspend fun getReplicationTask(
        replicationTaskId: String,
        tags: Map<String, String>? =
            null,
    ): GetReplicationTaskResult {
        val argument = GetReplicationTaskPlainArgs(
            replicationTaskId = replicationTaskId,
            tags = tags,
        )
        return getReplicationTaskResultToKotlin(getReplicationTaskPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplicationTask].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;dms&#46;kotlin&#46;inputs&#46;GetReplicationTaskPlainArgs].
     * @return A collection of values returned by getReplicationTask.
     */
    public suspend
    fun getReplicationTask(argument: suspend GetReplicationTaskPlainArgsBuilder.() -> Unit):
        GetReplicationTaskResult {
        val builder = GetReplicationTaskPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationTaskResultToKotlin(getReplicationTaskPlain(builtArgument.toJava()).await())
    }
}
