@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.aws.dms.EventSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DMS (Data Migration Service) event subscription resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.EventSubscription;
 * import com.pulumi.aws.dms.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSubscription("example", EventSubscriptionArgs.builder()
 *             .enabled(true)
 *             .eventCategories(
 *                 "creation",
 *                 "failure")
 *             .snsTopicArn(aws_sns_topic.example().arn())
 *             .sourceIds(aws_dms_replication_task.example().replication_task_id())
 *             .sourceType("replication-task")
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import event subscriptions using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:dms/eventSubscription:EventSubscription test my-awesome-event-subscription
 * ```
 * @property enabled Whether the event subscription should be enabled.
 * @property eventCategories List of event categories to listen for, see `DescribeEventCategories` for a canonical list.
 * @property name Name of event subscription.
 * @property snsTopicArn SNS topic arn to send events on.
 * @property sourceIds Ids of sources to listen to.
 * @property sourceType Type of source for events. Valid values: `replication-instance` or `replication-task`
 * @property tags Map of resource tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class EventSubscriptionArgs(
    public val enabled: Output<Boolean>? = null,
    public val eventCategories: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val snsTopicArn: Output<String>? = null,
    public val sourceIds: Output<List<String>>? = null,
    public val sourceType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.EventSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.dms.EventSubscriptionArgs =
        com.pulumi.aws.dms.EventSubscriptionArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .eventCategories(eventCategories?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .snsTopicArn(snsTopicArn?.applyValue({ args0 -> args0 }))
            .sourceIds(sourceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceType(sourceType?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EventSubscriptionArgs].
 */
@PulumiTagMarker
public class EventSubscriptionArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var eventCategories: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var snsTopicArn: Output<String>? = null

    private var sourceIds: Output<List<String>>? = null

    private var sourceType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Whether the event subscription should be enabled.
     */
    @JvmName("affyvbtcjemmrihc")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value List of event categories to listen for, see `DescribeEventCategories` for a canonical list.
     */
    @JvmName("jrmwcrfixyumesxv")
    public suspend fun eventCategories(`value`: Output<List<String>>) {
        this.eventCategories = value
    }

    @JvmName("dvidgmiyymglerwx")
    public suspend fun eventCategories(vararg values: Output<String>) {
        this.eventCategories = Output.all(values.asList())
    }

    /**
     * @param values List of event categories to listen for, see `DescribeEventCategories` for a canonical list.
     */
    @JvmName("sabihytxcykvfjxg")
    public suspend fun eventCategories(values: List<Output<String>>) {
        this.eventCategories = Output.all(values)
    }

    /**
     * @param value Name of event subscription.
     */
    @JvmName("rpucimtmmcqigjxw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value SNS topic arn to send events on.
     */
    @JvmName("vmplxotndvlsblhi")
    public suspend fun snsTopicArn(`value`: Output<String>) {
        this.snsTopicArn = value
    }

    /**
     * @param value Ids of sources to listen to.
     */
    @JvmName("rxhsfarqbddmymll")
    public suspend fun sourceIds(`value`: Output<List<String>>) {
        this.sourceIds = value
    }

    @JvmName("ckfuncjrppxykqmm")
    public suspend fun sourceIds(vararg values: Output<String>) {
        this.sourceIds = Output.all(values.asList())
    }

    /**
     * @param values Ids of sources to listen to.
     */
    @JvmName("hcsytijqctuytmbe")
    public suspend fun sourceIds(values: List<Output<String>>) {
        this.sourceIds = Output.all(values)
    }

    /**
     * @param value Type of source for events. Valid values: `replication-instance` or `replication-task`
     */
    @JvmName("cwqgyomwmwjbpfrk")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value Map of resource tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mgypodfupqrqnnaw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Whether the event subscription should be enabled.
     */
    @JvmName("amnogxhxmyfpvhil")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value List of event categories to listen for, see `DescribeEventCategories` for a canonical list.
     */
    @JvmName("tejvdrcbvolnyvoe")
    public suspend fun eventCategories(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventCategories = mapped
    }

    /**
     * @param values List of event categories to listen for, see `DescribeEventCategories` for a canonical list.
     */
    @JvmName("weynrnxhjkatcvlk")
    public suspend fun eventCategories(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventCategories = mapped
    }

    /**
     * @param value Name of event subscription.
     */
    @JvmName("yrfxwwyanehakmul")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value SNS topic arn to send events on.
     */
    @JvmName("xpxyqbelqlmljhjh")
    public suspend fun snsTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsTopicArn = mapped
    }

    /**
     * @param value Ids of sources to listen to.
     */
    @JvmName("ffymgwbqgdbbpfao")
    public suspend fun sourceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIds = mapped
    }

    /**
     * @param values Ids of sources to listen to.
     */
    @JvmName("kggvrliahirhtolt")
    public suspend fun sourceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIds = mapped
    }

    /**
     * @param value Type of source for events. Valid values: `replication-instance` or `replication-task`
     */
    @JvmName("aaqsmcnarukgjwoq")
    public suspend fun sourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value Map of resource tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ntldqpvbvihuhlay")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of resource tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lnbwuughshbeuita")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EventSubscriptionArgs = EventSubscriptionArgs(
        enabled = enabled,
        eventCategories = eventCategories,
        name = name,
        snsTopicArn = snsTopicArn,
        sourceIds = sourceIds,
        sourceType = sourceType,
        tags = tags,
    )
}
