@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.aws.dms.ReplicationConfigArgs.builder
import com.pulumi.aws.dms.kotlin.inputs.ReplicationConfigComputeConfigArgs
import com.pulumi.aws.dms.kotlin.inputs.ReplicationConfigComputeConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DMS Serverless replication config resource.
 * > **NOTE:** Changing most arguments will stop the replication if it is running. You can set `start_replication` to resume the replication afterwards.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.ReplicationConfig;
 * import com.pulumi.aws.dms.ReplicationConfigArgs;
 * import com.pulumi.aws.dms.inputs.ReplicationConfigComputeConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var name = new ReplicationConfig("name", ReplicationConfigArgs.builder()
 *             .replicationConfigIdentifier("test-dms-serverless-replication-tf")
 *             .resourceIdentifier("test-dms-serverless-replication-tf")
 *             .replicationType("cdc")
 *             .sourceEndpointArn(aws_dms_endpoint.source().endpoint_arn())
 *             .targetEndpointArn(aws_dms_endpoint.target().endpoint_arn())
 *             .tableMappings("""
 *   {
 *     "rules":[{"rule-type":"selection","rule-id":"1","rule-name":"1","rule-action":"include","object-locator":{"schema-name":"%%","table-name":"%%"}}]
 *   }
 *             """)
 *             .startReplication(true)
 *             .computeConfig(ReplicationConfigComputeConfigArgs.builder()
 *                 .replicationSubnetGroupId(aws_dms_replication_subnet_group.default().replication_subnet_group_id())
 *                 .maxCapacityUnits("64")
 *                 .minCapacityUnits("2")
 *                 .preferredMaintenanceWindow("sun:23:45-mon:00:30")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import a replication config using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:dms/replicationConfig:ReplicationConfig example arn:aws:dms:us-east-1:123456789012:replication-config:UX6OL6MHMMJKFFOXE3H7LLJCMEKBDUG4ZV7DRSI
 * ```
 * @property computeConfig Configuration block for provisioning an DMS Serverless replication.
 * @property replicationConfigIdentifier Unique identifier that you want to use to create the config.
 * @property replicationSettings An escaped JSON string that are used to provision this replication configuration. For example, [Change processing tuning settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html)
 * @property replicationType The migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
 * @property resourceIdentifier Unique value or name that you set for a given resource that can be used to construct an Amazon Resource Name (ARN) for that resource. For more information, see [Fine-grained access control using resource names and tags](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess)
 * @property sourceEndpointArn The Amazon Resource Name (ARN) string that uniquely identifies the source endpoint.
 * @property startReplication Whether to run or stop the serverless replication, default is false.
 * @property supplementalSettings JSON settings for specifying supplemental data. For more information see [Specifying supplemental data for task settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html)
 * @property tableMappings An escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetEndpointArn The Amazon Resource Name (ARN) string that uniquely identifies the target endpoint.
 */
public data class ReplicationConfigArgs(
    public val computeConfig: Output<ReplicationConfigComputeConfigArgs>? = null,
    public val replicationConfigIdentifier: Output<String>? = null,
    public val replicationSettings: Output<String>? = null,
    public val replicationType: Output<String>? = null,
    public val resourceIdentifier: Output<String>? = null,
    public val sourceEndpointArn: Output<String>? = null,
    public val startReplication: Output<Boolean>? = null,
    public val supplementalSettings: Output<String>? = null,
    public val tableMappings: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetEndpointArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.ReplicationConfigArgs> {
    override fun toJava(): com.pulumi.aws.dms.ReplicationConfigArgs =
        com.pulumi.aws.dms.ReplicationConfigArgs.builder()
            .computeConfig(computeConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .replicationConfigIdentifier(replicationConfigIdentifier?.applyValue({ args0 -> args0 }))
            .replicationSettings(replicationSettings?.applyValue({ args0 -> args0 }))
            .replicationType(replicationType?.applyValue({ args0 -> args0 }))
            .resourceIdentifier(resourceIdentifier?.applyValue({ args0 -> args0 }))
            .sourceEndpointArn(sourceEndpointArn?.applyValue({ args0 -> args0 }))
            .startReplication(startReplication?.applyValue({ args0 -> args0 }))
            .supplementalSettings(supplementalSettings?.applyValue({ args0 -> args0 }))
            .tableMappings(tableMappings?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetEndpointArn(targetEndpointArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationConfigArgs].
 */
@PulumiTagMarker
public class ReplicationConfigArgsBuilder internal constructor() {
    private var computeConfig: Output<ReplicationConfigComputeConfigArgs>? = null

    private var replicationConfigIdentifier: Output<String>? = null

    private var replicationSettings: Output<String>? = null

    private var replicationType: Output<String>? = null

    private var resourceIdentifier: Output<String>? = null

    private var sourceEndpointArn: Output<String>? = null

    private var startReplication: Output<Boolean>? = null

    private var supplementalSettings: Output<String>? = null

    private var tableMappings: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetEndpointArn: Output<String>? = null

    /**
     * @param value Configuration block for provisioning an DMS Serverless replication.
     */
    @JvmName("wjdufwamjynuewly")
    public suspend fun computeConfig(`value`: Output<ReplicationConfigComputeConfigArgs>) {
        this.computeConfig = value
    }

    /**
     * @param value Unique identifier that you want to use to create the config.
     */
    @JvmName("letlgsebgobeublr")
    public suspend fun replicationConfigIdentifier(`value`: Output<String>) {
        this.replicationConfigIdentifier = value
    }

    /**
     * @param value An escaped JSON string that are used to provision this replication configuration. For example, [Change processing tuning settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html)
     */
    @JvmName("lnxdrvevhsbxhtaa")
    public suspend fun replicationSettings(`value`: Output<String>) {
        this.replicationSettings = value
    }

    /**
     * @param value The migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
     */
    @JvmName("iinrpkpkrrhougqv")
    public suspend fun replicationType(`value`: Output<String>) {
        this.replicationType = value
    }

    /**
     * @param value Unique value or name that you set for a given resource that can be used to construct an Amazon Resource Name (ARN) for that resource. For more information, see [Fine-grained access control using resource names and tags](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess)
     */
    @JvmName("axqbijmqnbftbnue")
    public suspend fun resourceIdentifier(`value`: Output<String>) {
        this.resourceIdentifier = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) string that uniquely identifies the source endpoint.
     */
    @JvmName("efkmooaccutgrbsl")
    public suspend fun sourceEndpointArn(`value`: Output<String>) {
        this.sourceEndpointArn = value
    }

    /**
     * @param value Whether to run or stop the serverless replication, default is false.
     */
    @JvmName("yphtbdigocegxhxb")
    public suspend fun startReplication(`value`: Output<Boolean>) {
        this.startReplication = value
    }

    /**
     * @param value JSON settings for specifying supplemental data. For more information see [Specifying supplemental data for task settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html)
     */
    @JvmName("jygpfpemyukqvcui")
    public suspend fun supplementalSettings(`value`: Output<String>) {
        this.supplementalSettings = value
    }

    /**
     * @param value An escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
     */
    @JvmName("lkfcfkfjyemhqehx")
    public suspend fun tableMappings(`value`: Output<String>) {
        this.tableMappings = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qhytfrvoqjqsovts")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) string that uniquely identifies the target endpoint.
     */
    @JvmName("ouflvssaimhbgkxy")
    public suspend fun targetEndpointArn(`value`: Output<String>) {
        this.targetEndpointArn = value
    }

    /**
     * @param value Configuration block for provisioning an DMS Serverless replication.
     */
    @JvmName("lxvdrqnkivpefrdv")
    public suspend fun computeConfig(`value`: ReplicationConfigComputeConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeConfig = mapped
    }

    /**
     * @param argument Configuration block for provisioning an DMS Serverless replication.
     */
    @JvmName("jsmmsmsmihxdiyxl")
    public suspend
    fun computeConfig(argument: suspend ReplicationConfigComputeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ReplicationConfigComputeConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.computeConfig = mapped
    }

    /**
     * @param value Unique identifier that you want to use to create the config.
     */
    @JvmName("yguhegaylxkwkbxp")
    public suspend fun replicationConfigIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationConfigIdentifier = mapped
    }

    /**
     * @param value An escaped JSON string that are used to provision this replication configuration. For example, [Change processing tuning settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.ChangeProcessingTuning.html)
     */
    @JvmName("xbmjsdtprbqpgbyh")
    public suspend fun replicationSettings(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationSettings = mapped
    }

    /**
     * @param value The migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
     */
    @JvmName("lvrjqrhnqvnewtpy")
    public suspend fun replicationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationType = mapped
    }

    /**
     * @param value Unique value or name that you set for a given resource that can be used to construct an Amazon Resource Name (ARN) for that resource. For more information, see [Fine-grained access control using resource names and tags](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.FineGrainedAccess)
     */
    @JvmName("jxnpdaqaxkfnophv")
    public suspend fun resourceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceIdentifier = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) string that uniquely identifies the source endpoint.
     */
    @JvmName("ouovhyusthihfrva")
    public suspend fun sourceEndpointArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointArn = mapped
    }

    /**
     * @param value Whether to run or stop the serverless replication, default is false.
     */
    @JvmName("xqucyiqxgywrdvnt")
    public suspend fun startReplication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startReplication = mapped
    }

    /**
     * @param value JSON settings for specifying supplemental data. For more information see [Specifying supplemental data for task settings](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html)
     */
    @JvmName("ueqigihglcqmkmau")
    public suspend fun supplementalSettings(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supplementalSettings = mapped
    }

    /**
     * @param value An escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
     */
    @JvmName("oakxwrsxfhrtotam")
    public suspend fun tableMappings(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableMappings = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fjirkxeherrrwiqc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mnvehqxphhhytrsu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) string that uniquely identifies the target endpoint.
     */
    @JvmName("arscckgdapmngarr")
    public suspend fun targetEndpointArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetEndpointArn = mapped
    }

    internal fun build(): ReplicationConfigArgs = ReplicationConfigArgs(
        computeConfig = computeConfig,
        replicationConfigIdentifier = replicationConfigIdentifier,
        replicationSettings = replicationSettings,
        replicationType = replicationType,
        resourceIdentifier = resourceIdentifier,
        sourceEndpointArn = sourceEndpointArn,
        startReplication = startReplication,
        supplementalSettings = supplementalSettings,
        tableMappings = tableMappings,
        tags = tags,
        targetEndpointArn = targetEndpointArn,
    )
}
