@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ReplicationInstance].
 */
@PulumiTagMarker
public class ReplicationInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationInstanceArgs = ReplicationInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationInstanceArgsBuilder.() -> Unit) {
        val builder = ReplicationInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReplicationInstance {
        val builtJavaResource = com.pulumi.aws.dms.ReplicationInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReplicationInstance(builtJavaResource)
    }
}

/**
 * Provides a DMS (Data Migration Service) replication instance resource. DMS replication instances can be created, updated, deleted, and imported.
 * ## Example Usage
 * Create required roles and then create a DMS instance, setting the depends_on to the required role policy attachments.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.dms.ReplicationInstance;
 * import com.pulumi.aws.dms.ReplicationInstanceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var dmsAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("dms.amazonaws.com")
 *                     .type("Service")
 *                     .build())
 *                 .build())
 *             .build());
 *         var dms_access_for_endpoint = new Role("dms-access-for-endpoint", RoleArgs.builder()
 *             .assumeRolePolicy(dmsAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var dms_access_for_endpoint_AmazonDMSRedshiftS3Role = new RolePolicyAttachment("dms-access-for-endpoint-AmazonDMSRedshiftS3Role", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AmazonDMSRedshiftS3Role")
 *             .role(dms_access_for_endpoint.name())
 *             .build());
 *         var dms_cloudwatch_logs_role = new Role("dms-cloudwatch-logs-role", RoleArgs.builder()
 *             .assumeRolePolicy(dmsAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var dms_cloudwatch_logs_role_AmazonDMSCloudWatchLogsRole = new RolePolicyAttachment("dms-cloudwatch-logs-role-AmazonDMSCloudWatchLogsRole", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AmazonDMSCloudWatchLogsRole")
 *             .role(dms_cloudwatch_logs_role.name())
 *             .build());
 *         var dms_vpc_role = new Role("dms-vpc-role", RoleArgs.builder()
 *             .assumeRolePolicy(dmsAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var dms_vpc_role_AmazonDMSVPCManagementRole = new RolePolicyAttachment("dms-vpc-role-AmazonDMSVPCManagementRole", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole")
 *             .role(dms_vpc_role.name())
 *             .build());
 *         var test = new ReplicationInstance("test", ReplicationInstanceArgs.builder()
 *             .allocatedStorage(20)
 *             .applyImmediately(true)
 *             .autoMinorVersionUpgrade(true)
 *             .availabilityZone("us-west-2c")
 *             .engineVersion("3.1.4")
 *             .kmsKeyArn("arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012")
 *             .multiAz(false)
 *             .preferredMaintenanceWindow("sun:10:30-sun:14:30")
 *             .publiclyAccessible(true)
 *             .replicationInstanceClass("dms.t2.micro")
 *             .replicationInstanceId("test-dms-replication-instance-tf")
 *             .replicationSubnetGroupId(aws_dms_replication_subnet_group.test-dms-replication-subnet-group-tf().id())
 *             .tags(Map.of("Name", "test"))
 *             .vpcSecurityGroupIds("sg-12345678")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     dms_access_for_endpoint_AmazonDMSRedshiftS3Role,
 *                     dms_cloudwatch_logs_role_AmazonDMSCloudWatchLogsRole,
 *                     dms_vpc_role_AmazonDMSVPCManagementRole)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import replication instances using the `replication_instance_id`. For example:
 * ```sh
 *  $ pulumi import aws:dms/replicationInstance:ReplicationInstance test test-dms-replication-instance-tf
 * ```
 *
 */
public class ReplicationInstance internal constructor(
    override val javaResource: com.pulumi.aws.dms.ReplicationInstance,
) : KotlinCustomResource(javaResource, ReplicationInstanceMapper) {
    /**
     * The amount of storage (in gigabytes) to be initially allocated for the replication instance.
     */
    public val allocatedStorage: Output<Int>
        get() = javaResource.allocatedStorage().applyValue({ args0 -> args0 })

    /**
     * Indicates that major version upgrades are allowed.
     */
    public val allowMajorVersionUpgrade: Output<Boolean>?
        get() = javaResource.allowMajorVersionUpgrade().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the changes should be applied immediately or during the next maintenance window. Only used when updating an existing resource.
     */
    public val applyImmediately: Output<Boolean>?
        get() = javaResource.applyImmediately().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates that minor engine upgrades will be applied automatically to the replication instance during the maintenance window.
     */
    public val autoMinorVersionUpgrade: Output<Boolean>
        get() = javaResource.autoMinorVersionUpgrade().applyValue({ args0 -> args0 })

    /**
     * The EC2 Availability Zone that the replication instance will be created in.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The engine version number of the replication instance.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
     */
    public val kmsKeyArn: Output<String>
        get() = javaResource.kmsKeyArn().applyValue({ args0 -> args0 })

    /**
     * Specifies if the replication instance is a multi-az deployment. You cannot set the `availability_zone` parameter if the `multi_az` parameter is set to `true`.
     */
    public val multiAz: Output<Boolean>
        get() = javaResource.multiAz().applyValue({ args0 -> args0 })

    /**
     * The type of IP address protocol used by a replication instance. Valid values: `IPV4`, `DUAL`.
     */
    public val networkType: Output<String>
        get() = javaResource.networkType().applyValue({ args0 -> args0 })

    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * - Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week.
     * - Format: `ddd:hh24:mi-ddd:hh24:mi`
     * - Valid Days: `mon, tue, wed, thu, fri, sat, sun`
     * - Constraints: Minimum 30-minute window.
     */
    public val preferredMaintenanceWindow: Output<String>
        get() = javaResource.preferredMaintenanceWindow().applyValue({ args0 -> args0 })

    /**
     * Specifies the accessibility options for the replication instance. A value of true represents an instance with a public IP address. A value of false represents an instance with a private IP address.
     */
    public val publiclyAccessible: Output<Boolean>
        get() = javaResource.publiclyAccessible().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the replication instance.
     */
    public val replicationInstanceArn: Output<String>
        get() = javaResource.replicationInstanceArn().applyValue({ args0 -> args0 })

    /**
     * The compute and memory capacity of the replication instance as specified by the replication instance class. See [AWS DMS User Guide](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.Types.html) for available instance sizes and advice on which one to choose.
     */
    public val replicationInstanceClass: Output<String>
        get() = javaResource.replicationInstanceClass().applyValue({ args0 -> args0 })

    /**
     * The replication instance identifier. This parameter is stored as a lowercase string.
     * - Must contain from 1 to 63 alphanumeric characters or hyphens.
     * - First character must be a letter.
     * - Cannot end with a hyphen
     * - Cannot contain two consecutive hyphens.
     */
    public val replicationInstanceId: Output<String>
        get() = javaResource.replicationInstanceId().applyValue({ args0 -> args0 })

    /**
     * A list of the private IP addresses of the replication instance.
     */
    public val replicationInstancePrivateIps: Output<List<String>>
        get() = javaResource.replicationInstancePrivateIps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * A list of the public IP addresses of the replication instance.
     */
    public val replicationInstancePublicIps: Output<List<String>>
        get() = javaResource.replicationInstancePublicIps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * A subnet group to associate with the replication instance.
     */
    public val replicationSubnetGroupId: Output<String>
        get() = javaResource.replicationSubnetGroupId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A list of VPC security group IDs to be used with the replication instance. The VPC security groups must work with the VPC containing the replication instance.
     */
    public val vpcSecurityGroupIds: Output<List<String>>
        get() = javaResource.vpcSecurityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object ReplicationInstanceMapper : ResourceMapper<ReplicationInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dms.ReplicationInstance::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationInstance = ReplicationInstance(
        javaResource
            as com.pulumi.aws.dms.ReplicationInstance,
    )
}

/**
 * @see [ReplicationInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationInstance].
 */
public suspend fun replicationInstance(
    name: String,
    block: suspend ReplicationInstanceResourceBuilder.() -> Unit,
): ReplicationInstance {
    val builder = ReplicationInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationInstance(name: String): ReplicationInstance {
    val builder = ReplicationInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
