@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.aws.dms.ReplicationInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DMS (Data Migration Service) replication instance resource. DMS replication instances can be created, updated, deleted, and imported.
 * ## Example Usage
 * Create required roles and then create a DMS instance, setting the depends_on to the required role policy attachments.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.dms.ReplicationInstance;
 * import com.pulumi.aws.dms.ReplicationInstanceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var dmsAssumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .identifiers("dms.amazonaws.com")
 *                     .type("Service")
 *                     .build())
 *                 .build())
 *             .build());
 *         var dms_access_for_endpoint = new Role("dms-access-for-endpoint", RoleArgs.builder()
 *             .assumeRolePolicy(dmsAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var dms_access_for_endpoint_AmazonDMSRedshiftS3Role = new RolePolicyAttachment("dms-access-for-endpoint-AmazonDMSRedshiftS3Role", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AmazonDMSRedshiftS3Role")
 *             .role(dms_access_for_endpoint.name())
 *             .build());
 *         var dms_cloudwatch_logs_role = new Role("dms-cloudwatch-logs-role", RoleArgs.builder()
 *             .assumeRolePolicy(dmsAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var dms_cloudwatch_logs_role_AmazonDMSCloudWatchLogsRole = new RolePolicyAttachment("dms-cloudwatch-logs-role-AmazonDMSCloudWatchLogsRole", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AmazonDMSCloudWatchLogsRole")
 *             .role(dms_cloudwatch_logs_role.name())
 *             .build());
 *         var dms_vpc_role = new Role("dms-vpc-role", RoleArgs.builder()
 *             .assumeRolePolicy(dmsAssumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var dms_vpc_role_AmazonDMSVPCManagementRole = new RolePolicyAttachment("dms-vpc-role-AmazonDMSVPCManagementRole", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole")
 *             .role(dms_vpc_role.name())
 *             .build());
 *         var test = new ReplicationInstance("test", ReplicationInstanceArgs.builder()
 *             .allocatedStorage(20)
 *             .applyImmediately(true)
 *             .autoMinorVersionUpgrade(true)
 *             .availabilityZone("us-west-2c")
 *             .engineVersion("3.1.4")
 *             .kmsKeyArn("arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012")
 *             .multiAz(false)
 *             .preferredMaintenanceWindow("sun:10:30-sun:14:30")
 *             .publiclyAccessible(true)
 *             .replicationInstanceClass("dms.t2.micro")
 *             .replicationInstanceId("test-dms-replication-instance-tf")
 *             .replicationSubnetGroupId(aws_dms_replication_subnet_group.test-dms-replication-subnet-group-tf().id())
 *             .tags(Map.of("Name", "test"))
 *             .vpcSecurityGroupIds("sg-12345678")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     dms_access_for_endpoint_AmazonDMSRedshiftS3Role,
 *                     dms_cloudwatch_logs_role_AmazonDMSCloudWatchLogsRole,
 *                     dms_vpc_role_AmazonDMSVPCManagementRole)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import replication instances using the `replication_instance_id`. For example:
 * ```sh
 *  $ pulumi import aws:dms/replicationInstance:ReplicationInstance test test-dms-replication-instance-tf
 * ```
 * @property allocatedStorage The amount of storage (in gigabytes) to be initially allocated for the replication instance.
 * @property allowMajorVersionUpgrade Indicates that major version upgrades are allowed.
 * @property applyImmediately Indicates whether the changes should be applied immediately or during the next maintenance window. Only used when updating an existing resource.
 * @property autoMinorVersionUpgrade Indicates that minor engine upgrades will be applied automatically to the replication instance during the maintenance window.
 * @property availabilityZone The EC2 Availability Zone that the replication instance will be created in.
 * @property engineVersion The engine version number of the replication instance.
 * @property kmsKeyArn The Amazon Resource Name (ARN) for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
 * @property multiAz Specifies if the replication instance is a multi-az deployment. You cannot set the `availability_zone` parameter if the `multi_az` parameter is set to `true`.
 * @property networkType The type of IP address protocol used by a replication instance. Valid values: `IPV4`, `DUAL`.
 * @property preferredMaintenanceWindow The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
 * - Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week.
 * - Format: `ddd:hh24:mi-ddd:hh24:mi`
 * - Valid Days: `mon, tue, wed, thu, fri, sat, sun`
 * - Constraints: Minimum 30-minute window.
 * @property publiclyAccessible Specifies the accessibility options for the replication instance. A value of true represents an instance with a public IP address. A value of false represents an instance with a private IP address.
 * @property replicationInstanceClass The compute and memory capacity of the replication instance as specified by the replication instance class. See [AWS DMS User Guide](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.Types.html) for available instance sizes and advice on which one to choose.
 * @property replicationInstanceId The replication instance identifier. This parameter is stored as a lowercase string.
 * - Must contain from 1 to 63 alphanumeric characters or hyphens.
 * - First character must be a letter.
 * - Cannot end with a hyphen
 * - Cannot contain two consecutive hyphens.
 * @property replicationSubnetGroupId A subnet group to associate with the replication instance.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcSecurityGroupIds A list of VPC security group IDs to be used with the replication instance. The VPC security groups must work with the VPC containing the replication instance.
 */
public data class ReplicationInstanceArgs(
    public val allocatedStorage: Output<Int>? = null,
    public val allowMajorVersionUpgrade: Output<Boolean>? = null,
    public val applyImmediately: Output<Boolean>? = null,
    public val autoMinorVersionUpgrade: Output<Boolean>? = null,
    public val availabilityZone: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val kmsKeyArn: Output<String>? = null,
    public val multiAz: Output<Boolean>? = null,
    public val networkType: Output<String>? = null,
    public val preferredMaintenanceWindow: Output<String>? = null,
    public val publiclyAccessible: Output<Boolean>? = null,
    public val replicationInstanceClass: Output<String>? = null,
    public val replicationInstanceId: Output<String>? = null,
    public val replicationSubnetGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcSecurityGroupIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.ReplicationInstanceArgs> {
    override fun toJava(): com.pulumi.aws.dms.ReplicationInstanceArgs =
        com.pulumi.aws.dms.ReplicationInstanceArgs.builder()
            .allocatedStorage(allocatedStorage?.applyValue({ args0 -> args0 }))
            .allowMajorVersionUpgrade(allowMajorVersionUpgrade?.applyValue({ args0 -> args0 }))
            .applyImmediately(applyImmediately?.applyValue({ args0 -> args0 }))
            .autoMinorVersionUpgrade(autoMinorVersionUpgrade?.applyValue({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .multiAz(multiAz?.applyValue({ args0 -> args0 }))
            .networkType(networkType?.applyValue({ args0 -> args0 }))
            .preferredMaintenanceWindow(preferredMaintenanceWindow?.applyValue({ args0 -> args0 }))
            .publiclyAccessible(publiclyAccessible?.applyValue({ args0 -> args0 }))
            .replicationInstanceClass(replicationInstanceClass?.applyValue({ args0 -> args0 }))
            .replicationInstanceId(replicationInstanceId?.applyValue({ args0 -> args0 }))
            .replicationSubnetGroupId(replicationSubnetGroupId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcSecurityGroupIds(
                vpcSecurityGroupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ReplicationInstanceArgs].
 */
@PulumiTagMarker
public class ReplicationInstanceArgsBuilder internal constructor() {
    private var allocatedStorage: Output<Int>? = null

    private var allowMajorVersionUpgrade: Output<Boolean>? = null

    private var applyImmediately: Output<Boolean>? = null

    private var autoMinorVersionUpgrade: Output<Boolean>? = null

    private var availabilityZone: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var kmsKeyArn: Output<String>? = null

    private var multiAz: Output<Boolean>? = null

    private var networkType: Output<String>? = null

    private var preferredMaintenanceWindow: Output<String>? = null

    private var publiclyAccessible: Output<Boolean>? = null

    private var replicationInstanceClass: Output<String>? = null

    private var replicationInstanceId: Output<String>? = null

    private var replicationSubnetGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcSecurityGroupIds: Output<List<String>>? = null

    /**
     * @param value The amount of storage (in gigabytes) to be initially allocated for the replication instance.
     */
    @JvmName("ihcvmjvgsglrbhke")
    public suspend fun allocatedStorage(`value`: Output<Int>) {
        this.allocatedStorage = value
    }

    /**
     * @param value Indicates that major version upgrades are allowed.
     */
    @JvmName("ktmbhimveohoxwyq")
    public suspend fun allowMajorVersionUpgrade(`value`: Output<Boolean>) {
        this.allowMajorVersionUpgrade = value
    }

    /**
     * @param value Indicates whether the changes should be applied immediately or during the next maintenance window. Only used when updating an existing resource.
     */
    @JvmName("pihsyuhcylosywkt")
    public suspend fun applyImmediately(`value`: Output<Boolean>) {
        this.applyImmediately = value
    }

    /**
     * @param value Indicates that minor engine upgrades will be applied automatically to the replication instance during the maintenance window.
     */
    @JvmName("oxrhhxcqvvmwknxm")
    public suspend fun autoMinorVersionUpgrade(`value`: Output<Boolean>) {
        this.autoMinorVersionUpgrade = value
    }

    /**
     * @param value The EC2 Availability Zone that the replication instance will be created in.
     */
    @JvmName("bhatdjcisfnhbocv")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value The engine version number of the replication instance.
     */
    @JvmName("teohyakscrebxoqr")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
     */
    @JvmName("kgtclcnejyenjdic")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value Specifies if the replication instance is a multi-az deployment. You cannot set the `availability_zone` parameter if the `multi_az` parameter is set to `true`.
     */
    @JvmName("vrudoaxktwapxhbc")
    public suspend fun multiAz(`value`: Output<Boolean>) {
        this.multiAz = value
    }

    /**
     * @param value The type of IP address protocol used by a replication instance. Valid values: `IPV4`, `DUAL`.
     */
    @JvmName("diaakfjsbjifbbkt")
    public suspend fun networkType(`value`: Output<String>) {
        this.networkType = value
    }

    /**
     * @param value The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * - Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week.
     * - Format: `ddd:hh24:mi-ddd:hh24:mi`
     * - Valid Days: `mon, tue, wed, thu, fri, sat, sun`
     * - Constraints: Minimum 30-minute window.
     */
    @JvmName("wblosxlvbtfecbci")
    public suspend fun preferredMaintenanceWindow(`value`: Output<String>) {
        this.preferredMaintenanceWindow = value
    }

    /**
     * @param value Specifies the accessibility options for the replication instance. A value of true represents an instance with a public IP address. A value of false represents an instance with a private IP address.
     */
    @JvmName("thfrfjogheesoyxy")
    public suspend fun publiclyAccessible(`value`: Output<Boolean>) {
        this.publiclyAccessible = value
    }

    /**
     * @param value The compute and memory capacity of the replication instance as specified by the replication instance class. See [AWS DMS User Guide](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.Types.html) for available instance sizes and advice on which one to choose.
     */
    @JvmName("onjcesmkjcneqgva")
    public suspend fun replicationInstanceClass(`value`: Output<String>) {
        this.replicationInstanceClass = value
    }

    /**
     * @param value The replication instance identifier. This parameter is stored as a lowercase string.
     * - Must contain from 1 to 63 alphanumeric characters or hyphens.
     * - First character must be a letter.
     * - Cannot end with a hyphen
     * - Cannot contain two consecutive hyphens.
     */
    @JvmName("emmforsuumyktcnj")
    public suspend fun replicationInstanceId(`value`: Output<String>) {
        this.replicationInstanceId = value
    }

    /**
     * @param value A subnet group to associate with the replication instance.
     */
    @JvmName("grqafopgqknohcbv")
    public suspend fun replicationSubnetGroupId(`value`: Output<String>) {
        this.replicationSubnetGroupId = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kyftonbtaxrgowkd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of VPC security group IDs to be used with the replication instance. The VPC security groups must work with the VPC containing the replication instance.
     */
    @JvmName("bhwighsrvpiwtgpl")
    public suspend fun vpcSecurityGroupIds(`value`: Output<List<String>>) {
        this.vpcSecurityGroupIds = value
    }

    @JvmName("bibkjysawegaxohx")
    public suspend fun vpcSecurityGroupIds(vararg values: Output<String>) {
        this.vpcSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of VPC security group IDs to be used with the replication instance. The VPC security groups must work with the VPC containing the replication instance.
     */
    @JvmName("umucabqomqwfbtup")
    public suspend fun vpcSecurityGroupIds(values: List<Output<String>>) {
        this.vpcSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value The amount of storage (in gigabytes) to be initially allocated for the replication instance.
     */
    @JvmName("svukfbadxjhtysat")
    public suspend fun allocatedStorage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocatedStorage = mapped
    }

    /**
     * @param value Indicates that major version upgrades are allowed.
     */
    @JvmName("xeggykwefwhcwgif")
    public suspend fun allowMajorVersionUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowMajorVersionUpgrade = mapped
    }

    /**
     * @param value Indicates whether the changes should be applied immediately or during the next maintenance window. Only used when updating an existing resource.
     */
    @JvmName("uhqjjoljpniyrlqt")
    public suspend fun applyImmediately(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyImmediately = mapped
    }

    /**
     * @param value Indicates that minor engine upgrades will be applied automatically to the replication instance during the maintenance window.
     */
    @JvmName("mjowhtrqwvjekwkv")
    public suspend fun autoMinorVersionUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoMinorVersionUpgrade = mapped
    }

    /**
     * @param value The EC2 Availability Zone that the replication instance will be created in.
     */
    @JvmName("yijqqadvyehqccmx")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value The engine version number of the replication instance.
     */
    @JvmName("aqrpcmkeegcnulmm")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
     */
    @JvmName("daibygbtpfluujpp")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value Specifies if the replication instance is a multi-az deployment. You cannot set the `availability_zone` parameter if the `multi_az` parameter is set to `true`.
     */
    @JvmName("swamuphdgueojdky")
    public suspend fun multiAz(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiAz = mapped
    }

    /**
     * @param value The type of IP address protocol used by a replication instance. Valid values: `IPV4`, `DUAL`.
     */
    @JvmName("ykldcclmpckqijqu")
    public suspend fun networkType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkType = mapped
    }

    /**
     * @param value The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * - Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week.
     * - Format: `ddd:hh24:mi-ddd:hh24:mi`
     * - Valid Days: `mon, tue, wed, thu, fri, sat, sun`
     * - Constraints: Minimum 30-minute window.
     */
    @JvmName("sceoopoeufcyuguy")
    public suspend fun preferredMaintenanceWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredMaintenanceWindow = mapped
    }

    /**
     * @param value Specifies the accessibility options for the replication instance. A value of true represents an instance with a public IP address. A value of false represents an instance with a private IP address.
     */
    @JvmName("ygpyvntpqxdlunng")
    public suspend fun publiclyAccessible(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publiclyAccessible = mapped
    }

    /**
     * @param value The compute and memory capacity of the replication instance as specified by the replication instance class. See [AWS DMS User Guide](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.Types.html) for available instance sizes and advice on which one to choose.
     */
    @JvmName("uowrxmckbixvdntg")
    public suspend fun replicationInstanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationInstanceClass = mapped
    }

    /**
     * @param value The replication instance identifier. This parameter is stored as a lowercase string.
     * - Must contain from 1 to 63 alphanumeric characters or hyphens.
     * - First character must be a letter.
     * - Cannot end with a hyphen
     * - Cannot contain two consecutive hyphens.
     */
    @JvmName("nkpfohoylvupcwks")
    public suspend fun replicationInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationInstanceId = mapped
    }

    /**
     * @param value A subnet group to associate with the replication instance.
     */
    @JvmName("tyufssiqncrtyfah")
    public suspend fun replicationSubnetGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationSubnetGroupId = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rmsuodnxvrqixakm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("npiucqjfrsdkipqv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A list of VPC security group IDs to be used with the replication instance. The VPC security groups must work with the VPC containing the replication instance.
     */
    @JvmName("eikawcugfphrtcbh")
    public suspend fun vpcSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param values A list of VPC security group IDs to be used with the replication instance. The VPC security groups must work with the VPC containing the replication instance.
     */
    @JvmName("kgoelukpknikhtqu")
    public suspend fun vpcSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    internal fun build(): ReplicationInstanceArgs = ReplicationInstanceArgs(
        allocatedStorage = allocatedStorage,
        allowMajorVersionUpgrade = allowMajorVersionUpgrade,
        applyImmediately = applyImmediately,
        autoMinorVersionUpgrade = autoMinorVersionUpgrade,
        availabilityZone = availabilityZone,
        engineVersion = engineVersion,
        kmsKeyArn = kmsKeyArn,
        multiAz = multiAz,
        networkType = networkType,
        preferredMaintenanceWindow = preferredMaintenanceWindow,
        publiclyAccessible = publiclyAccessible,
        replicationInstanceClass = replicationInstanceClass,
        replicationInstanceId = replicationInstanceId,
        replicationSubnetGroupId = replicationSubnetGroupId,
        tags = tags,
        vpcSecurityGroupIds = vpcSecurityGroupIds,
    )
}
