@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ReplicationSubnetGroup].
 */
@PulumiTagMarker
public class ReplicationSubnetGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationSubnetGroupArgs = ReplicationSubnetGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationSubnetGroupArgsBuilder.() -> Unit) {
        val builder = ReplicationSubnetGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReplicationSubnetGroup {
        val builtJavaResource = com.pulumi.aws.dms.ReplicationSubnetGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReplicationSubnetGroup(builtJavaResource)
    }
}

/**
 * Provides a DMS (Data Migration Service) replication subnet group resource. DMS replication subnet groups can be created, updated, deleted, and imported.
 * > **Note:** AWS requires a special IAM role called `dms-vpc-role` when using this resource. See the example below to create it as part of your configuration.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.ReplicationSubnetGroup;
 * import com.pulumi.aws.dms.ReplicationSubnetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ReplicationSubnetGroup("example", ReplicationSubnetGroupArgs.builder()
 *             .replicationSubnetGroupDescription("Example replication subnet group")
 *             .replicationSubnetGroupId("example-dms-replication-subnet-group-tf")
 *             .subnetIds(
 *                 "subnet-12345678",
 *                 "subnet-12345679")
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ### Creating special IAM role
 * If your account does not already include the `dms-vpc-role` IAM role, you will need to create it to allow DMS to manage subnets in the VPC.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.dms.ReplicationSubnetGroup;
 * import com.pulumi.aws.dms.ReplicationSubnetGroupArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dms_vpc_role = new Role("dms-vpc-role", RoleArgs.builder()
 *             .description("Allows DMS to manage VPC")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "dms.amazonaws.com")
 *                         )),
 *                         jsonProperty("Action", "sts:AssumeRole")
 *                     )))
 *                 )))
 *             .build());
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment("exampleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(dms_vpc_role.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole")
 *             .build());
 *         var exampleReplicationSubnetGroup = new ReplicationSubnetGroup("exampleReplicationSubnetGroup", ReplicationSubnetGroupArgs.builder()
 *             .replicationSubnetGroupDescription("Example")
 *             .replicationSubnetGroupId("example-id")
 *             .subnetIds(
 *                 "subnet-12345678",
 *                 "subnet-12345679")
 *             .tags(Map.of("Name", "example-id"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleRolePolicyAttachment)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import replication subnet groups using the `replication_subnet_group_id`. For example:
 * ```sh
 *  $ pulumi import aws:dms/replicationSubnetGroup:ReplicationSubnetGroup test test-dms-replication-subnet-group-tf
 * ```
 *
 */
public class ReplicationSubnetGroup internal constructor(
    override val javaResource: com.pulumi.aws.dms.ReplicationSubnetGroup,
) : KotlinCustomResource(javaResource, ReplicationSubnetGroupMapper) {
    public val replicationSubnetGroupArn: Output<String>
        get() = javaResource.replicationSubnetGroupArn().applyValue({ args0 -> args0 })

    /**
     * Description for the subnet group.
     */
    public val replicationSubnetGroupDescription: Output<String>
        get() = javaResource.replicationSubnetGroupDescription().applyValue({ args0 -> args0 })

    /**
     * Name for the replication subnet group. This value is stored as a lowercase string. It must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens and cannot be `default`.
     */
    public val replicationSubnetGroupId: Output<String>
        get() = javaResource.replicationSubnetGroupId().applyValue({ args0 -> args0 })

    /**
     * List of at least 2 EC2 subnet IDs for the subnet group. The subnets must cover at least 2 availability zones.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the VPC the subnet group is in.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object ReplicationSubnetGroupMapper : ResourceMapper<ReplicationSubnetGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dms.ReplicationSubnetGroup::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationSubnetGroup =
        ReplicationSubnetGroup(javaResource as com.pulumi.aws.dms.ReplicationSubnetGroup)
}

/**
 * @see [ReplicationSubnetGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationSubnetGroup].
 */
public suspend fun replicationSubnetGroup(
    name: String,
    block: suspend ReplicationSubnetGroupResourceBuilder.() -> Unit,
): ReplicationSubnetGroup {
    val builder = ReplicationSubnetGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationSubnetGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationSubnetGroup(name: String): ReplicationSubnetGroup {
    val builder = ReplicationSubnetGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
