@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.aws.dms.ReplicationSubnetGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DMS (Data Migration Service) replication subnet group resource. DMS replication subnet groups can be created, updated, deleted, and imported.
 * > **Note:** AWS requires a special IAM role called `dms-vpc-role` when using this resource. See the example below to create it as part of your configuration.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.ReplicationSubnetGroup;
 * import com.pulumi.aws.dms.ReplicationSubnetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ReplicationSubnetGroup("example", ReplicationSubnetGroupArgs.builder()
 *             .replicationSubnetGroupDescription("Example replication subnet group")
 *             .replicationSubnetGroupId("example-dms-replication-subnet-group-tf")
 *             .subnetIds(
 *                 "subnet-12345678",
 *                 "subnet-12345679")
 *             .tags(Map.of("Name", "example"))
 *             .build());
 *     }
 * }
 * ```
 * ### Creating special IAM role
 * If your account does not already include the `dms-vpc-role` IAM role, you will need to create it to allow DMS to manage subnets in the VPC.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.dms.ReplicationSubnetGroup;
 * import com.pulumi.aws.dms.ReplicationSubnetGroupArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dms_vpc_role = new Role("dms-vpc-role", RoleArgs.builder()
 *             .description("Allows DMS to manage VPC")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "dms.amazonaws.com")
 *                         )),
 *                         jsonProperty("Action", "sts:AssumeRole")
 *                     )))
 *                 )))
 *             .build());
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment("exampleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(dms_vpc_role.name())
 *             .policyArn("arn:aws:iam::aws:policy/service-role/AmazonDMSVPCManagementRole")
 *             .build());
 *         var exampleReplicationSubnetGroup = new ReplicationSubnetGroup("exampleReplicationSubnetGroup", ReplicationSubnetGroupArgs.builder()
 *             .replicationSubnetGroupDescription("Example")
 *             .replicationSubnetGroupId("example-id")
 *             .subnetIds(
 *                 "subnet-12345678",
 *                 "subnet-12345679")
 *             .tags(Map.of("Name", "example-id"))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleRolePolicyAttachment)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import replication subnet groups using the `replication_subnet_group_id`. For example:
 * ```sh
 *  $ pulumi import aws:dms/replicationSubnetGroup:ReplicationSubnetGroup test test-dms-replication-subnet-group-tf
 * ```
 * @property replicationSubnetGroupDescription Description for the subnet group.
 * @property replicationSubnetGroupId Name for the replication subnet group. This value is stored as a lowercase string. It must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens and cannot be `default`.
 * @property subnetIds List of at least 2 EC2 subnet IDs for the subnet group. The subnets must cover at least 2 availability zones.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ReplicationSubnetGroupArgs(
    public val replicationSubnetGroupDescription: Output<String>? = null,
    public val replicationSubnetGroupId: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.ReplicationSubnetGroupArgs> {
    override fun toJava(): com.pulumi.aws.dms.ReplicationSubnetGroupArgs =
        com.pulumi.aws.dms.ReplicationSubnetGroupArgs.builder()
            .replicationSubnetGroupDescription(
                replicationSubnetGroupDescription?.applyValue({ args0 ->
                    args0
                }),
            )
            .replicationSubnetGroupId(replicationSubnetGroupId?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ReplicationSubnetGroupArgs].
 */
@PulumiTagMarker
public class ReplicationSubnetGroupArgsBuilder internal constructor() {
    private var replicationSubnetGroupDescription: Output<String>? = null

    private var replicationSubnetGroupId: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description for the subnet group.
     */
    @JvmName("ihxnigifggsajpsq")
    public suspend fun replicationSubnetGroupDescription(`value`: Output<String>) {
        this.replicationSubnetGroupDescription = value
    }

    /**
     * @param value Name for the replication subnet group. This value is stored as a lowercase string. It must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens and cannot be `default`.
     */
    @JvmName("hftafdvhpbngiokq")
    public suspend fun replicationSubnetGroupId(`value`: Output<String>) {
        this.replicationSubnetGroupId = value
    }

    /**
     * @param value List of at least 2 EC2 subnet IDs for the subnet group. The subnets must cover at least 2 availability zones.
     */
    @JvmName("wiwvindkjlvdqwkv")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("ecoifyjaxyjwqwxi")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values List of at least 2 EC2 subnet IDs for the subnet group. The subnets must cover at least 2 availability zones.
     */
    @JvmName("fpbjivmhlbmjmotg")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bwpeejkbktpkgwgr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description for the subnet group.
     */
    @JvmName("otbgxkxvrgdpfhfo")
    public suspend fun replicationSubnetGroupDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationSubnetGroupDescription = mapped
    }

    /**
     * @param value Name for the replication subnet group. This value is stored as a lowercase string. It must contain no more than 255 alphanumeric characters, periods, spaces, underscores, or hyphens and cannot be `default`.
     */
    @JvmName("wtfbouadbklpifve")
    public suspend fun replicationSubnetGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationSubnetGroupId = mapped
    }

    /**
     * @param value List of at least 2 EC2 subnet IDs for the subnet group. The subnets must cover at least 2 availability zones.
     */
    @JvmName("qckspccanlllpysp")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values List of at least 2 EC2 subnet IDs for the subnet group. The subnets must cover at least 2 availability zones.
     */
    @JvmName("ooateeaipxcvpkea")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dcbhjqkggfkhchrx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lrevybircvduidpj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ReplicationSubnetGroupArgs = ReplicationSubnetGroupArgs(
        replicationSubnetGroupDescription = replicationSubnetGroupDescription,
        replicationSubnetGroupId = replicationSubnetGroupId,
        subnetIds = subnetIds,
        tags = tags,
    )
}
