@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ReplicationTask].
 */
@PulumiTagMarker
public class ReplicationTaskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationTaskArgs = ReplicationTaskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationTaskArgsBuilder.() -> Unit) {
        val builder = ReplicationTaskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReplicationTask {
        val builtJavaResource = com.pulumi.aws.dms.ReplicationTask(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReplicationTask(builtJavaResource)
    }
}

/**
 * Provides a DMS (Data Migration Service) replication task resource. DMS replication tasks can be created, updated, deleted, and imported.
 * > **NOTE:** Changing most arguments will stop the task if it is running. You can set `start_replication_task` to resume the task afterwards.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.ReplicationTask;
 * import com.pulumi.aws.dms.ReplicationTaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ReplicationTask("test", ReplicationTaskArgs.builder()
 *             .cdcStartTime(1484346880)
 *             .migrationType("full-load")
 *             .replicationInstanceArn(aws_dms_replication_instance.test-dms-replication-instance-tf().replication_instance_arn())
 *             .replicationTaskId("test-dms-replication-task-tf")
 *             .replicationTaskSettings("...")
 *             .sourceEndpointArn(aws_dms_endpoint.test-dms-source-endpoint-tf().endpoint_arn())
 *             .tableMappings("{\"rules\":[{\"rule-type\":\"selection\",\"rule-id\":\"1\",\"rule-name\":\"1\",\"object-locator\":{\"schema-name\":\"%\",\"table-name\":\"%\"},\"rule-action\":\"include\"}]}")
 *             .tags(Map.of("Name", "test"))
 *             .targetEndpointArn(aws_dms_endpoint.test-dms-target-endpoint-tf().endpoint_arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import replication tasks using the `replication_task_id`. For example:
 * ```sh
 *  $ pulumi import aws:dms/replicationTask:ReplicationTask test test-dms-replication-task-tf
 * ```
 *
 */
public class ReplicationTask internal constructor(
    override val javaResource: com.pulumi.aws.dms.ReplicationTask,
) : KotlinCustomResource(javaResource, ReplicationTaskMapper) {
    /**
     * Indicates when you want a change data capture (CDC) operation to start. The value can be in date, checkpoint, or LSN/SCN format depending on the source engine. For more information, see [Determining a CDC native start point](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native).
     */
    public val cdcStartPosition: Output<String>
        get() = javaResource.cdcStartPosition().applyValue({ args0 -> args0 })

    /**
     * The Unix timestamp integer for the start of the Change Data Capture (CDC) operation.
     */
    public val cdcStartTime: Output<String>?
        get() = javaResource.cdcStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
     */
    public val migrationType: Output<String>
        get() = javaResource.migrationType().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the replication instance.
     */
    public val replicationInstanceArn: Output<String>
        get() = javaResource.replicationInstanceArn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) for the replication task.
     */
    public val replicationTaskArn: Output<String>
        get() = javaResource.replicationTaskArn().applyValue({ args0 -> args0 })

    /**
     * The replication task identifier.
     * - Must contain from 1 to 255 alphanumeric characters or hyphens.
     * - First character must be a letter.
     * - Cannot end with a hyphen.
     * - Cannot contain two consecutive hyphens.
     */
    public val replicationTaskId: Output<String>
        get() = javaResource.replicationTaskId().applyValue({ args0 -> args0 })

    /**
     * An escaped JSON string that contains the task settings. For a complete list of task settings, see [Task Settings for AWS Database Migration Service Tasks](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html).
     */
    public val replicationTaskSettings: Output<String>?
        get() = javaResource.replicationTaskSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) string that uniquely identifies the source endpoint.
     */
    public val sourceEndpointArn: Output<String>
        get() = javaResource.sourceEndpointArn().applyValue({ args0 -> args0 })

    /**
     * Whether to run or stop the replication task.
     */
    public val startReplicationTask: Output<Boolean>?
        get() = javaResource.startReplicationTask().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Replication Task status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * An escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
     */
    public val tableMappings: Output<String>
        get() = javaResource.tableMappings().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The Amazon Resource Name (ARN) string that uniquely identifies the target endpoint.
     */
    public val targetEndpointArn: Output<String>
        get() = javaResource.targetEndpointArn().applyValue({ args0 -> args0 })
}

public object ReplicationTaskMapper : ResourceMapper<ReplicationTask> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dms.ReplicationTask::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationTask = ReplicationTask(
        javaResource as
            com.pulumi.aws.dms.ReplicationTask,
    )
}

/**
 * @see [ReplicationTask].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationTask].
 */
public suspend fun replicationTask(
    name: String,
    block: suspend ReplicationTaskResourceBuilder.() -> Unit,
): ReplicationTask {
    val builder = ReplicationTaskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationTask].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationTask(name: String): ReplicationTask {
    val builder = ReplicationTaskResourceBuilder()
    builder.name(name)
    return builder.build()
}
