@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.aws.dms.ReplicationTaskArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DMS (Data Migration Service) replication task resource. DMS replication tasks can be created, updated, deleted, and imported.
 * > **NOTE:** Changing most arguments will stop the task if it is running. You can set `start_replication_task` to resume the task afterwards.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.ReplicationTask;
 * import com.pulumi.aws.dms.ReplicationTaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ReplicationTask("test", ReplicationTaskArgs.builder()
 *             .cdcStartTime(1484346880)
 *             .migrationType("full-load")
 *             .replicationInstanceArn(aws_dms_replication_instance.test-dms-replication-instance-tf().replication_instance_arn())
 *             .replicationTaskId("test-dms-replication-task-tf")
 *             .replicationTaskSettings("...")
 *             .sourceEndpointArn(aws_dms_endpoint.test-dms-source-endpoint-tf().endpoint_arn())
 *             .tableMappings("{\"rules\":[{\"rule-type\":\"selection\",\"rule-id\":\"1\",\"rule-name\":\"1\",\"object-locator\":{\"schema-name\":\"%\",\"table-name\":\"%\"},\"rule-action\":\"include\"}]}")
 *             .tags(Map.of("Name", "test"))
 *             .targetEndpointArn(aws_dms_endpoint.test-dms-target-endpoint-tf().endpoint_arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import replication tasks using the `replication_task_id`. For example:
 * ```sh
 *  $ pulumi import aws:dms/replicationTask:ReplicationTask test test-dms-replication-task-tf
 * ```
 * @property cdcStartPosition Indicates when you want a change data capture (CDC) operation to start. The value can be in date, checkpoint, or LSN/SCN format depending on the source engine. For more information, see [Determining a CDC native start point](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native).
 * @property cdcStartTime The Unix timestamp integer for the start of the Change Data Capture (CDC) operation.
 * @property migrationType The migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
 * @property replicationInstanceArn The Amazon Resource Name (ARN) of the replication instance.
 * @property replicationTaskId The replication task identifier.
 * - Must contain from 1 to 255 alphanumeric characters or hyphens.
 * - First character must be a letter.
 * - Cannot end with a hyphen.
 * - Cannot contain two consecutive hyphens.
 * @property replicationTaskSettings An escaped JSON string that contains the task settings. For a complete list of task settings, see [Task Settings for AWS Database Migration Service Tasks](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html).
 * @property sourceEndpointArn The Amazon Resource Name (ARN) string that uniquely identifies the source endpoint.
 * @property startReplicationTask Whether to run or stop the replication task.
 * @property tableMappings An escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetEndpointArn The Amazon Resource Name (ARN) string that uniquely identifies the target endpoint.
 */
public data class ReplicationTaskArgs(
    public val cdcStartPosition: Output<String>? = null,
    public val cdcStartTime: Output<String>? = null,
    public val migrationType: Output<String>? = null,
    public val replicationInstanceArn: Output<String>? = null,
    public val replicationTaskId: Output<String>? = null,
    public val replicationTaskSettings: Output<String>? = null,
    public val sourceEndpointArn: Output<String>? = null,
    public val startReplicationTask: Output<Boolean>? = null,
    public val tableMappings: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetEndpointArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.ReplicationTaskArgs> {
    override fun toJava(): com.pulumi.aws.dms.ReplicationTaskArgs =
        com.pulumi.aws.dms.ReplicationTaskArgs.builder()
            .cdcStartPosition(cdcStartPosition?.applyValue({ args0 -> args0 }))
            .cdcStartTime(cdcStartTime?.applyValue({ args0 -> args0 }))
            .migrationType(migrationType?.applyValue({ args0 -> args0 }))
            .replicationInstanceArn(replicationInstanceArn?.applyValue({ args0 -> args0 }))
            .replicationTaskId(replicationTaskId?.applyValue({ args0 -> args0 }))
            .replicationTaskSettings(replicationTaskSettings?.applyValue({ args0 -> args0 }))
            .sourceEndpointArn(sourceEndpointArn?.applyValue({ args0 -> args0 }))
            .startReplicationTask(startReplicationTask?.applyValue({ args0 -> args0 }))
            .tableMappings(tableMappings?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetEndpointArn(targetEndpointArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationTaskArgs].
 */
@PulumiTagMarker
public class ReplicationTaskArgsBuilder internal constructor() {
    private var cdcStartPosition: Output<String>? = null

    private var cdcStartTime: Output<String>? = null

    private var migrationType: Output<String>? = null

    private var replicationInstanceArn: Output<String>? = null

    private var replicationTaskId: Output<String>? = null

    private var replicationTaskSettings: Output<String>? = null

    private var sourceEndpointArn: Output<String>? = null

    private var startReplicationTask: Output<Boolean>? = null

    private var tableMappings: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetEndpointArn: Output<String>? = null

    /**
     * @param value Indicates when you want a change data capture (CDC) operation to start. The value can be in date, checkpoint, or LSN/SCN format depending on the source engine. For more information, see [Determining a CDC native start point](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native).
     */
    @JvmName("oxoqvrjrvbgibenh")
    public suspend fun cdcStartPosition(`value`: Output<String>) {
        this.cdcStartPosition = value
    }

    /**
     * @param value The Unix timestamp integer for the start of the Change Data Capture (CDC) operation.
     */
    @JvmName("imeytdikmmmriybe")
    public suspend fun cdcStartTime(`value`: Output<String>) {
        this.cdcStartTime = value
    }

    /**
     * @param value The migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
     */
    @JvmName("yhdfhaclbsssgiei")
    public suspend fun migrationType(`value`: Output<String>) {
        this.migrationType = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the replication instance.
     */
    @JvmName("joyxyhswkxjyravm")
    public suspend fun replicationInstanceArn(`value`: Output<String>) {
        this.replicationInstanceArn = value
    }

    /**
     * @param value The replication task identifier.
     * - Must contain from 1 to 255 alphanumeric characters or hyphens.
     * - First character must be a letter.
     * - Cannot end with a hyphen.
     * - Cannot contain two consecutive hyphens.
     */
    @JvmName("nyhluksroukhakfg")
    public suspend fun replicationTaskId(`value`: Output<String>) {
        this.replicationTaskId = value
    }

    /**
     * @param value An escaped JSON string that contains the task settings. For a complete list of task settings, see [Task Settings for AWS Database Migration Service Tasks](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html).
     */
    @JvmName("gamsusdnybgclxkv")
    public suspend fun replicationTaskSettings(`value`: Output<String>) {
        this.replicationTaskSettings = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) string that uniquely identifies the source endpoint.
     */
    @JvmName("ytfbmgptuehmufsd")
    public suspend fun sourceEndpointArn(`value`: Output<String>) {
        this.sourceEndpointArn = value
    }

    /**
     * @param value Whether to run or stop the replication task.
     */
    @JvmName("iwobrstmvyymsoar")
    public suspend fun startReplicationTask(`value`: Output<Boolean>) {
        this.startReplicationTask = value
    }

    /**
     * @param value An escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
     */
    @JvmName("ptgnflvirvqtmoqx")
    public suspend fun tableMappings(`value`: Output<String>) {
        this.tableMappings = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kafwgvjagjlnnjoo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) string that uniquely identifies the target endpoint.
     */
    @JvmName("cgmqbqyajkpupgqp")
    public suspend fun targetEndpointArn(`value`: Output<String>) {
        this.targetEndpointArn = value
    }

    /**
     * @param value Indicates when you want a change data capture (CDC) operation to start. The value can be in date, checkpoint, or LSN/SCN format depending on the source engine. For more information, see [Determining a CDC native start point](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Task.CDC.html#CHAP_Task.CDC.StartPoint.Native).
     */
    @JvmName("enlgsndcjvyesfjs")
    public suspend fun cdcStartPosition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdcStartPosition = mapped
    }

    /**
     * @param value The Unix timestamp integer for the start of the Change Data Capture (CDC) operation.
     */
    @JvmName("avsoimicydmjqlss")
    public suspend fun cdcStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdcStartTime = mapped
    }

    /**
     * @param value The migration type. Can be one of `full-load | cdc | full-load-and-cdc`.
     */
    @JvmName("vfjhnlgcoebhutta")
    public suspend fun migrationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationType = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the replication instance.
     */
    @JvmName("wchbqkhvpukuehpm")
    public suspend fun replicationInstanceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationInstanceArn = mapped
    }

    /**
     * @param value The replication task identifier.
     * - Must contain from 1 to 255 alphanumeric characters or hyphens.
     * - First character must be a letter.
     * - Cannot end with a hyphen.
     * - Cannot contain two consecutive hyphens.
     */
    @JvmName("fkmvkrohxbcijona")
    public suspend fun replicationTaskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationTaskId = mapped
    }

    /**
     * @param value An escaped JSON string that contains the task settings. For a complete list of task settings, see [Task Settings for AWS Database Migration Service Tasks](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html).
     */
    @JvmName("fdbkbldcteddvuks")
    public suspend fun replicationTaskSettings(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationTaskSettings = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) string that uniquely identifies the source endpoint.
     */
    @JvmName("fsyuwgwgboubnwrt")
    public suspend fun sourceEndpointArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndpointArn = mapped
    }

    /**
     * @param value Whether to run or stop the replication task.
     */
    @JvmName("cveinqhgqjujqyut")
    public suspend fun startReplicationTask(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startReplicationTask = mapped
    }

    /**
     * @param value An escaped JSON string that contains the table mappings. For information on table mapping see [Using Table Mapping with an AWS Database Migration Service Task to Select and Filter Data](http://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
     */
    @JvmName("blmuwegejkaxkooc")
    public suspend fun tableMappings(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableMappings = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cqcmnrnhtfjkhgse")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gbqteicilljulkch")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) string that uniquely identifies the target endpoint.
     */
    @JvmName("hvtnknixlwjhwugh")
    public suspend fun targetEndpointArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetEndpointArn = mapped
    }

    internal fun build(): ReplicationTaskArgs = ReplicationTaskArgs(
        cdcStartPosition = cdcStartPosition,
        cdcStartTime = cdcStartTime,
        migrationType = migrationType,
        replicationInstanceArn = replicationInstanceArn,
        replicationTaskId = replicationTaskId,
        replicationTaskSettings = replicationTaskSettings,
        sourceEndpointArn = sourceEndpointArn,
        startReplicationTask = startReplicationTask,
        tableMappings = tableMappings,
        tags = tags,
        targetEndpointArn = targetEndpointArn,
    )
}
