@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [S3Endpoint].
 */
@PulumiTagMarker
public class S3EndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: S3EndpointArgs = S3EndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend S3EndpointArgsBuilder.() -> Unit) {
        val builder = S3EndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): S3Endpoint {
        val builtJavaResource = com.pulumi.aws.dms.S3Endpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return S3Endpoint(builtJavaResource)
    }
}

/**
 * Provides a DMS (Data Migration Service) S3 endpoint resource. DMS S3 endpoints can be created, updated, deleted, and imported.
 * > **Note:** AWS is deprecating `extra_connection_attributes`, such as used with `aws.dms.Endpoint`. This resource is an alternative to `aws.dms.Endpoint` and does not use `extra_connection_attributes`. (AWS currently includes `extra_connection_attributes` in the raw responses to the AWS Provider requests and so they may be visible in the logs.)
 * > **Note:** Some of this resource's arguments have default values that come from the AWS Provider. Other default values are provided by AWS and subject to change without notice. When relying on AWS defaults, the provider state will often have a zero value. For example, the AWS Provider does not provide a default for `cdc_max_batch_interval` but the AWS default is `60` (seconds). However, the provider state will show `0` since this is the value return by AWS when no value is present. Below, we aim to flag the defaults that come from AWS (_e.g._, "AWS default...").
 * ## Example Usage
 * ### Minimal Configuration
 * This is the minimal configuration for an `aws.dms.S3Endpoint`. This endpoint will rely on the AWS Provider and AWS defaults.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.S3Endpoint;
 * import com.pulumi.aws.dms.S3EndpointArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new S3Endpoint("example", S3EndpointArgs.builder()
 *             .endpointId("donnedtipi")
 *             .endpointType("target")
 *             .bucketName("beckut_name")
 *             .serviceAccessRoleArn(aws_iam_role.example().arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_iam_role_policy.example())
 *                 .build());
 *     }
 * }
 * ```
 * ### Complete Configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.dms.S3Endpoint;
 * import com.pulumi.aws.dms.S3EndpointArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new S3Endpoint("example", S3EndpointArgs.builder()
 *             .endpointId("donnedtipi")
 *             .endpointType("target")
 *             .sslMode("none")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "donnedtipi"),
 *                 Map.entry("Update", "to-update"),
 *                 Map.entry("Remove", "to-remove")
 *             ))
 *             .addColumnName(true)
 *             .addTrailingPaddingCharacter(false)
 *             .bucketFolder("folder")
 *             .bucketName("bucket_name")
 *             .cannedAclForObjects("private")
 *             .cdcInsertsAndUpdates(true)
 *             .cdcInsertsOnly(false)
 *             .cdcMaxBatchInterval(100)
 *             .cdcMinFileSize(16)
 *             .cdcPath("cdc/path")
 *             .compressionType("GZIP")
 *             .csvDelimiter(";")
 *             .csvNoSupValue("x")
 *             .csvNullValue("?")
 *             .csvRowDelimiter("\\r\\n")
 *             .dataFormat("parquet")
 *             .dataPageSize(1100000)
 *             .datePartitionDelimiter("UNDERSCORE")
 *             .datePartitionEnabled(true)
 *             .datePartitionSequence("yyyymmddhh")
 *             .datePartitionTimezone("Asia/Seoul")
 *             .dictPageSizeLimit(1000000)
 *             .enableStatistics(false)
 *             .encodingType("plain")
 *             .encryptionMode("SSE_S3")
 *             .expectedBucketOwner(data.aws_caller_identity().current().account_id())
 *             .externalTableDefinition("etd")
 *             .ignoreHeaderRows(1)
 *             .includeOpForFullLoad(true)
 *             .maxFileSize(1000000)
 *             .parquetTimestampInMillisecond(true)
 *             .parquetVersion("parquet-2-0")
 *             .preserveTransactions(false)
 *             .rfc4180(false)
 *             .rowGroupLength(11000)
 *             .serverSideEncryptionKmsKeyId(aws_kms_key.example().arn())
 *             .serviceAccessRoleArn(aws_iam_role.example().arn())
 *             .timestampColumnName("tx_commit_time")
 *             .useCsvNoSupValue(false)
 *             .useTaskStartTimeForFullLoadTimestamp(true)
 *             .glueCatalogGeneration(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_iam_role_policy.example())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import endpoints using the `endpoint_id`. For example:
 * ```sh
 *  $ pulumi import aws:dms/s3Endpoint:S3Endpoint example example-dms-endpoint-tf
 * ```
 *
 */
public class S3Endpoint internal constructor(
    override val javaResource: com.pulumi.aws.dms.S3Endpoint,
) : KotlinCustomResource(javaResource, S3EndpointMapper) {
    /**
     * Whether to add column name information to the .csv output file. Default is `false`.
     */
    public val addColumnName: Output<Boolean>?
        get() = javaResource.addColumnName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to add padding. Default is `false`. (Ignored for source endpoints.)
     */
    public val addTrailingPaddingCharacter: Output<Boolean>?
        get() = javaResource.addTrailingPaddingCharacter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * S3 object prefix.
     */
    public val bucketFolder: Output<String>?
        get() = javaResource.bucketFolder().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * S3 bucket name.
     */
    public val bucketName: Output<String>
        get() = javaResource.bucketName().applyValue({ args0 -> args0 })

    /**
     * Predefined (canned) access control list for objects created in an S3 bucket. Valid values include `none`, `private`, `public-read`, `public-read-write`, `authenticated-read`, `aws-exec-read`, `bucket-owner-read`, and `bucket-owner-full-control`. Default is `none`.
     */
    public val cannedAclForObjects: Output<String>?
        get() = javaResource.cannedAclForObjects().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to write insert and update operations to .csv or .parquet output files. Default is `false`.
     */
    public val cdcInsertsAndUpdates: Output<Boolean>?
        get() = javaResource.cdcInsertsAndUpdates().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to write insert operations to .csv or .parquet output files. Default is `false`.
     */
    public val cdcInsertsOnly: Output<Boolean>?
        get() = javaResource.cdcInsertsOnly().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Maximum length of the interval, defined in seconds, after which to output a file to Amazon S3. (AWS default is `60`.)
     */
    public val cdcMaxBatchInterval: Output<Int>?
        get() = javaResource.cdcMaxBatchInterval().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Minimum file size condition as defined in kilobytes to output a file to Amazon S3. (AWS default is 32000 KB.)
     */
    public val cdcMinFileSize: Output<Int>?
        get() = javaResource.cdcMinFileSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Folder path of CDC files. If `cdc_path` is set, AWS DMS reads CDC files from this path and replicates the data changes to the target endpoint. Supported in AWS DMS versions 3.4.2 and later.
     */
    public val cdcPath: Output<String>?
        get() = javaResource.cdcPath().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ARN for the certificate.
     */
    public val certificateArn: Output<String>
        get() = javaResource.certificateArn().applyValue({ args0 -> args0 })

    /**
     * Set to compress target files. Valid values are `GZIP` and `NONE`. Default is `NONE`. (Ignored for source endpoints.)
     */
    public val compressionType: Output<String>?
        get() = javaResource.compressionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Delimiter used to separate columns in the source files. Default is `,`.
     */
    public val csvDelimiter: Output<String>?
        get() = javaResource.csvDelimiter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Only applies if output files for a CDC load are written in .csv format. If `use_csv_no_sup_value` is set to `true`, string to use for all columns not included in the supplemental log. If you do not specify a string value, DMS uses the null value for these columns regardless of `use_csv_no_sup_value`. (Ignored for source endpoints.)
     */
    public val csvNoSupValue: Output<String>?
        get() = javaResource.csvNoSupValue().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * String to as null when writing to the target. (AWS default is `NULL`.)
     */
    public val csvNullValue: Output<String>?
        get() = javaResource.csvNullValue().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Delimiter used to separate rows in the source files. Default is newline (_i.e._, `\n`).
     */
    public val csvRowDelimiter: Output<String>?
        get() = javaResource.csvRowDelimiter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Output format for the files that AWS DMS uses to create S3 objects. Valid values are `csv` and `parquet`.  (Ignored for source endpoints -- only `csv` is valid.)
     */
    public val dataFormat: Output<String>?
        get() = javaResource.dataFormat().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Size of one data page in bytes. (AWS default is 1 MiB, _i.e._, `1048576`.)
     */
    public val dataPageSize: Output<Int>?
        get() = javaResource.dataPageSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Date separating delimiter to use during folder partitioning. Valid values are `SLASH`, `UNDERSCORE`, `DASH`, and `NONE`. (AWS default is `SLASH`.) (Ignored for source endpoints.)
     */
    public val datePartitionDelimiter: Output<String>?
        get() = javaResource.datePartitionDelimiter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Partition S3 bucket folders based on transaction commit dates. Default is `false`. (Ignored for source endpoints.)
     */
    public val datePartitionEnabled: Output<Boolean>?
        get() = javaResource.datePartitionEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Date format to use during folder partitioning. Use this parameter when `date_partition_enabled` is set to true. Valid values are `YYYYMMDD`, `YYYYMMDDHH`, `YYYYMM`, `MMYYYYDD`, and `DDMMYYYY`. (AWS default is `YYYYMMDD`.) (Ignored for source endpoints.)
     */
    public val datePartitionSequence: Output<String>?
        get() = javaResource.datePartitionSequence().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Convert the current UTC time to a timezone. The conversion occurs when a date partition folder is created and a CDC filename is generated. The timezone format is Area/Location (_e.g._, `Europe/Paris`). Use this when `date_partition_enabled` is `true`. (Ignored for source endpoints.)
     */
    public val datePartitionTimezone: Output<String>?
        get() = javaResource.datePartitionTimezone().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Undocumented argument for use as directed by AWS Support.
     */
    public val detachTargetOnLobLookupFailureParquet: Output<Boolean>?
        get() = javaResource.detachTargetOnLobLookupFailureParquet().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Maximum size in bytes of an encoded dictionary page of a column. (AWS default is 1 MiB, _i.e._, `1048576`.)
     */
    public val dictPageSizeLimit: Output<Int>?
        get() = javaResource.dictPageSizeLimit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable statistics for Parquet pages and row groups. Default is `true`.
     */
    public val enableStatistics: Output<Boolean>?
        get() = javaResource.enableStatistics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of encoding to use. Value values are `rle_dictionary`, `plain`, and `plain_dictionary`. (AWS default is `rle_dictionary`.)
     */
    public val encodingType: Output<String>?
        get() = javaResource.encodingType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Server-side encryption mode that you want to encrypt your .csv or .parquet object files copied to S3. Valid values are `SSE_S3` and `SSE_KMS`. (AWS default is `SSE_S3`.) (Ignored for source endpoints -- only `SSE_S3` is valid.)
     */
    public val encryptionMode: Output<String>?
        get() = javaResource.encryptionMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN for the endpoint.
     */
    public val endpointArn: Output<String>
        get() = javaResource.endpointArn().applyValue({ args0 -> args0 })

    /**
     * Database endpoint identifier. Identifiers must contain from 1 to 255 alphanumeric characters or hyphens, begin with a letter, contain only ASCII letters, digits, and hyphens, not end with a hyphen, and not contain two consecutive hyphens.
     */
    public val endpointId: Output<String>
        get() = javaResource.endpointId().applyValue({ args0 -> args0 })

    /**
     * Type of endpoint. Valid values are `source`, `target`.
     */
    public val endpointType: Output<String>
        get() = javaResource.endpointType().applyValue({ args0 -> args0 })

    /**
     * Expanded name for the engine name.
     */
    public val engineDisplayName: Output<String>
        get() = javaResource.engineDisplayName().applyValue({ args0 -> args0 })

    /**
     * Bucket owner to prevent sniping. Value is an AWS account ID.
     */
    public val expectedBucketOwner: Output<String>?
        get() = javaResource.expectedBucketOwner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Can be used for cross-account validation. Use it in another account with `aws.dms.S3Endpoint` to create the endpoint cross-account.
     */
    public val externalId: Output<String>
        get() = javaResource.externalId().applyValue({ args0 -> args0 })

    /**
     * JSON document that describes how AWS DMS should interpret the data.
     */
    public val externalTableDefinition: Output<String>?
        get() = javaResource.externalTableDefinition().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to integrate AWS Glue Data Catalog with an Amazon S3 target. See [Using AWS Glue Data Catalog with an Amazon S3 target for AWS DMS](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.GlueCatalog) for more information. Default is `false`.
     */
    public val glueCatalogGeneration: Output<Boolean>?
        get() = javaResource.glueCatalogGeneration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When this value is set to `1`, DMS ignores the first row header in a .csv file. (AWS default is `0`.)
     */
    public val ignoreHeaderRows: Output<Int>?
        get() = javaResource.ignoreHeaderRows().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to enable a full load to write INSERT operations to the .csv output files only to indicate how the rows were added to the source database. Default is `false`.
     */
    public val includeOpForFullLoad: Output<Boolean>?
        get() = javaResource.includeOpForFullLoad().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN for the KMS key that will be used to encrypt the connection parameters. If you do not specify a value for `kms_key_arn`, then AWS DMS will use your default encryption key. AWS KMS creates the default encryption key for your AWS account. Your AWS account has a different default encryption key for each AWS region.
     */
    public val kmsKeyArn: Output<String>
        get() = javaResource.kmsKeyArn().applyValue({ args0 -> args0 })

    /**
     * Maximum size (in KB) of any .csv file to be created while migrating to an S3 target during full load. Valid values are from `1` to `1048576`. (AWS default is 1 GB, _i.e._, `1048576`.)
     */
    public val maxFileSize: Output<Int>?
        get() = javaResource.maxFileSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the precision of any TIMESTAMP column values written to an S3 object file in .parquet format. Default is `false`. (Ignored for source endpoints.)
     */
    public val parquetTimestampInMillisecond: Output<Boolean>?
        get() = javaResource.parquetTimestampInMillisecond().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Version of the .parquet file format. Valid values are `parquet-1-0` and `parquet-2-0`. (AWS default is `parquet-1-0`.) (Ignored for source endpoints.)
     */
    public val parquetVersion: Output<String>?
        get() = javaResource.parquetVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether DMS saves the transaction order for a CDC load on the S3 target specified by `cdc_path`. Default is `false`. (Ignored for source endpoints.)
     */
    public val preserveTransactions: Output<Boolean>?
        get() = javaResource.preserveTransactions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * For an S3 source, whether each leading double quotation mark has to be followed by an ending double quotation mark. Default is `true`.
     */
    public val rfc4180: Output<Boolean>?
        get() = javaResource.rfc4180().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Number of rows in a row group. (AWS default is `10000`.)
     */
    public val rowGroupLength: Output<Int>?
        get() = javaResource.rowGroupLength().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When `encryption_mode` is `SSE_KMS`, ARN for the AWS KMS key. (Ignored for source endpoints -- only `SSE_S3` `encryption_mode` is valid.)
     */
    public val serverSideEncryptionKmsKeyId: Output<String>?
        get() = javaResource.serverSideEncryptionKmsKeyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the IAM role with permissions to the S3 Bucket.
     * The following arguments are optional:
     */
    public val serviceAccessRoleArn: Output<String>
        get() = javaResource.serviceAccessRoleArn().applyValue({ args0 -> args0 })

    /**
     * SSL mode to use for the connection. Valid values are `none`, `require`, `verify-ca`, `verify-full`. (AWS default is `none`.)
     */
    public val sslMode: Output<String>
        get() = javaResource.sslMode().applyValue({ args0 -> args0 })

    /**
     * Status of the endpoint.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Column to add with timestamp information to the endpoint data for an Amazon S3 target.
     */
    public val timestampColumnName: Output<String>?
        get() = javaResource.timestampColumnName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to use `csv_no_sup_value` for columns not included in the supplemental log. (Ignored for source endpoints.)
     */
    public val useCsvNoSupValue: Output<Boolean>?
        get() = javaResource.useCsvNoSupValue().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When set to `true`, uses the task start time as the timestamp column value instead of the time data is written to target. For full load, when set to `true`, each row of the timestamp column contains the task start time. For CDC loads, each row of the timestamp column contains the transaction commit time.When set to false, the full load timestamp in the timestamp column increments with the time data arrives at the target. Default is `false`.
     */
    public val useTaskStartTimeForFullLoadTimestamp: Output<Boolean>?
        get() = javaResource.useTaskStartTimeForFullLoadTimestamp().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })
}

public object S3EndpointMapper : ResourceMapper<S3Endpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.dms.S3Endpoint::class == javaResource::class

    override fun map(javaResource: Resource): S3Endpoint = S3Endpoint(
        javaResource as
            com.pulumi.aws.dms.S3Endpoint,
    )
}

/**
 * @see [S3Endpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [S3Endpoint].
 */
public suspend fun s3Endpoint(name: String, block: suspend S3EndpointResourceBuilder.() -> Unit):
    S3Endpoint {
    val builder = S3EndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [S3Endpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun s3Endpoint(name: String): S3Endpoint {
    val builder = S3EndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
