@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dms.kotlin.inputs

import com.pulumi.aws.dms.inputs.EndpointKafkaSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property broker Kafka broker location. Specify in the form broker-hostname-or-ip:port.
 * @property includeControlDetails Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output. Default is `false`.
 * @property includeNullAndEmpty Include NULL and empty columns for records migrated to the endpoint. Default is `false`.
 * @property includePartitionValue Shows the partition value within the Kafka message output unless the partition type is `schema-table-type`. Default is `false`.
 * @property includeTableAlterOperations Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table`, `drop-table`, `add-column`, `drop-column`, and `rename-column`. Default is `false`.
 * @property includeTransactionDetails Provides detailed transaction information from the source database. This information includes a commit timestamp, a log position, and values for `transaction_id`, previous `transaction_id`, and `transaction_record_id` (the record offset within a transaction). Default is `false`.
 * @property messageFormat Output format for the records created on the endpoint. Message format is `JSON` (default) or `JSON_UNFORMATTED` (a single line with no tab).
 * @property messageMaxBytes Maximum size in bytes for records created on the endpoint Default is `1,000,000`.
 * @property noHexPrefix Set this optional parameter to true to avoid adding a '0x' prefix to raw data in hexadecimal format. For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the `no_hex_prefix` endpoint setting to enable migration of RAW data type columns without adding the `'0x'` prefix.
 * @property partitionIncludeSchemaTable Prefixes schema and table names to partition values, when the partition type is `primary-key-type`. Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. Default is `false`.
 * @property saslPassword Secure password you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
 * @property saslUsername Secure user name you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
 * @property securityProtocol Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS). Options include `ssl-encryption`, `ssl-authentication`, and `sasl-ssl`. `sasl-ssl` requires `sasl_username` and `sasl_password`.
 * @property sslCaCertificateArn ARN for the private certificate authority (CA) cert that AWS DMS uses to securely connect to your Kafka target endpoint.
 * @property sslClientCertificateArn ARN of the client certificate used to securely connect to a Kafka target endpoint.
 * @property sslClientKeyArn ARN for the client private key used to securely connect to a Kafka target endpoint.
 * @property sslClientKeyPassword Password for the client private key used to securely connect to a Kafka target endpoint.
 * @property topic Kafka topic for migration. Default is `kafka-default-topic`.
 */
public data class EndpointKafkaSettingsArgs(
    public val broker: Output<String>,
    public val includeControlDetails: Output<Boolean>? = null,
    public val includeNullAndEmpty: Output<Boolean>? = null,
    public val includePartitionValue: Output<Boolean>? = null,
    public val includeTableAlterOperations: Output<Boolean>? = null,
    public val includeTransactionDetails: Output<Boolean>? = null,
    public val messageFormat: Output<String>? = null,
    public val messageMaxBytes: Output<Int>? = null,
    public val noHexPrefix: Output<Boolean>? = null,
    public val partitionIncludeSchemaTable: Output<Boolean>? = null,
    public val saslPassword: Output<String>? = null,
    public val saslUsername: Output<String>? = null,
    public val securityProtocol: Output<String>? = null,
    public val sslCaCertificateArn: Output<String>? = null,
    public val sslClientCertificateArn: Output<String>? = null,
    public val sslClientKeyArn: Output<String>? = null,
    public val sslClientKeyPassword: Output<String>? = null,
    public val topic: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.dms.inputs.EndpointKafkaSettingsArgs> {
    override fun toJava(): com.pulumi.aws.dms.inputs.EndpointKafkaSettingsArgs =
        com.pulumi.aws.dms.inputs.EndpointKafkaSettingsArgs.builder()
            .broker(broker.applyValue({ args0 -> args0 }))
            .includeControlDetails(includeControlDetails?.applyValue({ args0 -> args0 }))
            .includeNullAndEmpty(includeNullAndEmpty?.applyValue({ args0 -> args0 }))
            .includePartitionValue(includePartitionValue?.applyValue({ args0 -> args0 }))
            .includeTableAlterOperations(includeTableAlterOperations?.applyValue({ args0 -> args0 }))
            .includeTransactionDetails(includeTransactionDetails?.applyValue({ args0 -> args0 }))
            .messageFormat(messageFormat?.applyValue({ args0 -> args0 }))
            .messageMaxBytes(messageMaxBytes?.applyValue({ args0 -> args0 }))
            .noHexPrefix(noHexPrefix?.applyValue({ args0 -> args0 }))
            .partitionIncludeSchemaTable(partitionIncludeSchemaTable?.applyValue({ args0 -> args0 }))
            .saslPassword(saslPassword?.applyValue({ args0 -> args0 }))
            .saslUsername(saslUsername?.applyValue({ args0 -> args0 }))
            .securityProtocol(securityProtocol?.applyValue({ args0 -> args0 }))
            .sslCaCertificateArn(sslCaCertificateArn?.applyValue({ args0 -> args0 }))
            .sslClientCertificateArn(sslClientCertificateArn?.applyValue({ args0 -> args0 }))
            .sslClientKeyArn(sslClientKeyArn?.applyValue({ args0 -> args0 }))
            .sslClientKeyPassword(sslClientKeyPassword?.applyValue({ args0 -> args0 }))
            .topic(topic?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointKafkaSettingsArgs].
 */
@PulumiTagMarker
public class EndpointKafkaSettingsArgsBuilder internal constructor() {
    private var broker: Output<String>? = null

    private var includeControlDetails: Output<Boolean>? = null

    private var includeNullAndEmpty: Output<Boolean>? = null

    private var includePartitionValue: Output<Boolean>? = null

    private var includeTableAlterOperations: Output<Boolean>? = null

    private var includeTransactionDetails: Output<Boolean>? = null

    private var messageFormat: Output<String>? = null

    private var messageMaxBytes: Output<Int>? = null

    private var noHexPrefix: Output<Boolean>? = null

    private var partitionIncludeSchemaTable: Output<Boolean>? = null

    private var saslPassword: Output<String>? = null

    private var saslUsername: Output<String>? = null

    private var securityProtocol: Output<String>? = null

    private var sslCaCertificateArn: Output<String>? = null

    private var sslClientCertificateArn: Output<String>? = null

    private var sslClientKeyArn: Output<String>? = null

    private var sslClientKeyPassword: Output<String>? = null

    private var topic: Output<String>? = null

    /**
     * @param value Kafka broker location. Specify in the form broker-hostname-or-ip:port.
     */
    @JvmName("encalaprxumxjfbh")
    public suspend fun broker(`value`: Output<String>) {
        this.broker = value
    }

    /**
     * @param value Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output. Default is `false`.
     */
    @JvmName("tfsxiumlluoxvtwx")
    public suspend fun includeControlDetails(`value`: Output<Boolean>) {
        this.includeControlDetails = value
    }

    /**
     * @param value Include NULL and empty columns for records migrated to the endpoint. Default is `false`.
     */
    @JvmName("mkwopsavrcxvsrin")
    public suspend fun includeNullAndEmpty(`value`: Output<Boolean>) {
        this.includeNullAndEmpty = value
    }

    /**
     * @param value Shows the partition value within the Kafka message output unless the partition type is `schema-table-type`. Default is `false`.
     */
    @JvmName("yloowgahphwjfkxb")
    public suspend fun includePartitionValue(`value`: Output<Boolean>) {
        this.includePartitionValue = value
    }

    /**
     * @param value Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table`, `drop-table`, `add-column`, `drop-column`, and `rename-column`. Default is `false`.
     */
    @JvmName("sywegwhnqiwcyrqo")
    public suspend fun includeTableAlterOperations(`value`: Output<Boolean>) {
        this.includeTableAlterOperations = value
    }

    /**
     * @param value Provides detailed transaction information from the source database. This information includes a commit timestamp, a log position, and values for `transaction_id`, previous `transaction_id`, and `transaction_record_id` (the record offset within a transaction). Default is `false`.
     */
    @JvmName("qpvejqqwdhryfaki")
    public suspend fun includeTransactionDetails(`value`: Output<Boolean>) {
        this.includeTransactionDetails = value
    }

    /**
     * @param value Output format for the records created on the endpoint. Message format is `JSON` (default) or `JSON_UNFORMATTED` (a single line with no tab).
     */
    @JvmName("pifncgvgaxnegwae")
    public suspend fun messageFormat(`value`: Output<String>) {
        this.messageFormat = value
    }

    /**
     * @param value Maximum size in bytes for records created on the endpoint Default is `1,000,000`.
     */
    @JvmName("rnafeycmljqgyxof")
    public suspend fun messageMaxBytes(`value`: Output<Int>) {
        this.messageMaxBytes = value
    }

    /**
     * @param value Set this optional parameter to true to avoid adding a '0x' prefix to raw data in hexadecimal format. For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the `no_hex_prefix` endpoint setting to enable migration of RAW data type columns without adding the `'0x'` prefix.
     */
    @JvmName("cktlbniscgurilbb")
    public suspend fun noHexPrefix(`value`: Output<Boolean>) {
        this.noHexPrefix = value
    }

    /**
     * @param value Prefixes schema and table names to partition values, when the partition type is `primary-key-type`. Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. Default is `false`.
     */
    @JvmName("olyfpddqctbhkmvb")
    public suspend fun partitionIncludeSchemaTable(`value`: Output<Boolean>) {
        this.partitionIncludeSchemaTable = value
    }

    /**
     * @param value Secure password you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
     */
    @JvmName("wflmeobeyegsueqk")
    public suspend fun saslPassword(`value`: Output<String>) {
        this.saslPassword = value
    }

    /**
     * @param value Secure user name you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
     */
    @JvmName("gvnnbofqpsntnfhj")
    public suspend fun saslUsername(`value`: Output<String>) {
        this.saslUsername = value
    }

    /**
     * @param value Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS). Options include `ssl-encryption`, `ssl-authentication`, and `sasl-ssl`. `sasl-ssl` requires `sasl_username` and `sasl_password`.
     */
    @JvmName("cnjjyguputxfkgqj")
    public suspend fun securityProtocol(`value`: Output<String>) {
        this.securityProtocol = value
    }

    /**
     * @param value ARN for the private certificate authority (CA) cert that AWS DMS uses to securely connect to your Kafka target endpoint.
     */
    @JvmName("arqeycgeyjvauaqk")
    public suspend fun sslCaCertificateArn(`value`: Output<String>) {
        this.sslCaCertificateArn = value
    }

    /**
     * @param value ARN of the client certificate used to securely connect to a Kafka target endpoint.
     */
    @JvmName("msdfndifrvrgtfcg")
    public suspend fun sslClientCertificateArn(`value`: Output<String>) {
        this.sslClientCertificateArn = value
    }

    /**
     * @param value ARN for the client private key used to securely connect to a Kafka target endpoint.
     */
    @JvmName("bgksdmixinkmobqr")
    public suspend fun sslClientKeyArn(`value`: Output<String>) {
        this.sslClientKeyArn = value
    }

    /**
     * @param value Password for the client private key used to securely connect to a Kafka target endpoint.
     */
    @JvmName("esqrqepvtqvarkrh")
    public suspend fun sslClientKeyPassword(`value`: Output<String>) {
        this.sslClientKeyPassword = value
    }

    /**
     * @param value Kafka topic for migration. Default is `kafka-default-topic`.
     */
    @JvmName("xgbpajtsejkegbln")
    public suspend fun topic(`value`: Output<String>) {
        this.topic = value
    }

    /**
     * @param value Kafka broker location. Specify in the form broker-hostname-or-ip:port.
     */
    @JvmName("frqhourycldwplsy")
    public suspend fun broker(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.broker = mapped
    }

    /**
     * @param value Shows detailed control information for table definition, column definition, and table and column changes in the Kafka message output. Default is `false`.
     */
    @JvmName("mhabjmkpdlbypwie")
    public suspend fun includeControlDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeControlDetails = mapped
    }

    /**
     * @param value Include NULL and empty columns for records migrated to the endpoint. Default is `false`.
     */
    @JvmName("xtlydvpafswsrqas")
    public suspend fun includeNullAndEmpty(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeNullAndEmpty = mapped
    }

    /**
     * @param value Shows the partition value within the Kafka message output unless the partition type is `schema-table-type`. Default is `false`.
     */
    @JvmName("vhmkdpiyoucscxbd")
    public suspend fun includePartitionValue(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includePartitionValue = mapped
    }

    /**
     * @param value Includes any data definition language (DDL) operations that change the table in the control data, such as `rename-table`, `drop-table`, `add-column`, `drop-column`, and `rename-column`. Default is `false`.
     */
    @JvmName("vfwebxrquivgxcpu")
    public suspend fun includeTableAlterOperations(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeTableAlterOperations = mapped
    }

    /**
     * @param value Provides detailed transaction information from the source database. This information includes a commit timestamp, a log position, and values for `transaction_id`, previous `transaction_id`, and `transaction_record_id` (the record offset within a transaction). Default is `false`.
     */
    @JvmName("uxdxhorbjxdgoopp")
    public suspend fun includeTransactionDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeTransactionDetails = mapped
    }

    /**
     * @param value Output format for the records created on the endpoint. Message format is `JSON` (default) or `JSON_UNFORMATTED` (a single line with no tab).
     */
    @JvmName("cbmjicteistlabxp")
    public suspend fun messageFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageFormat = mapped
    }

    /**
     * @param value Maximum size in bytes for records created on the endpoint Default is `1,000,000`.
     */
    @JvmName("pjpaqvxjebdewxmu")
    public suspend fun messageMaxBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageMaxBytes = mapped
    }

    /**
     * @param value Set this optional parameter to true to avoid adding a '0x' prefix to raw data in hexadecimal format. For example, by default, AWS DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an Oracle source to a Kafka target. Use the `no_hex_prefix` endpoint setting to enable migration of RAW data type columns without adding the `'0x'` prefix.
     */
    @JvmName("icmrdqmglbkocbgy")
    public suspend fun noHexPrefix(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noHexPrefix = mapped
    }

    /**
     * @param value Prefixes schema and table names to partition values, when the partition type is `primary-key-type`. Doing this increases data distribution among Kafka partitions. For example, suppose that a SysBench schema has thousands of tables and each table has only limited range for a primary key. In this case, the same primary key is sent from thousands of tables to the same partition, which causes throttling. Default is `false`.
     */
    @JvmName("ijdoawrjltnwdomc")
    public suspend fun partitionIncludeSchemaTable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionIncludeSchemaTable = mapped
    }

    /**
     * @param value Secure password you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
     */
    @JvmName("jhjlokikqwdgdeba")
    public suspend fun saslPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.saslPassword = mapped
    }

    /**
     * @param value Secure user name you created when you first set up your MSK cluster to validate a client identity and make an encrypted connection between server and client using SASL-SSL authentication.
     */
    @JvmName("ciokveqjxlybltjx")
    public suspend fun saslUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.saslUsername = mapped
    }

    /**
     * @param value Set secure connection to a Kafka target endpoint using Transport Layer Security (TLS). Options include `ssl-encryption`, `ssl-authentication`, and `sasl-ssl`. `sasl-ssl` requires `sasl_username` and `sasl_password`.
     */
    @JvmName("lticewjpejkiofap")
    public suspend fun securityProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityProtocol = mapped
    }

    /**
     * @param value ARN for the private certificate authority (CA) cert that AWS DMS uses to securely connect to your Kafka target endpoint.
     */
    @JvmName("tmqwarbasgeqwtkp")
    public suspend fun sslCaCertificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslCaCertificateArn = mapped
    }

    /**
     * @param value ARN of the client certificate used to securely connect to a Kafka target endpoint.
     */
    @JvmName("ayiuewvxcpfldxgn")
    public suspend fun sslClientCertificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslClientCertificateArn = mapped
    }

    /**
     * @param value ARN for the client private key used to securely connect to a Kafka target endpoint.
     */
    @JvmName("tjyegrbkntdsmhkx")
    public suspend fun sslClientKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslClientKeyArn = mapped
    }

    /**
     * @param value Password for the client private key used to securely connect to a Kafka target endpoint.
     */
    @JvmName("ivmmnhfmkxmlfggs")
    public suspend fun sslClientKeyPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslClientKeyPassword = mapped
    }

    /**
     * @param value Kafka topic for migration. Default is `kafka-default-topic`.
     */
    @JvmName("tpkhcnbxhqrxqbml")
    public suspend fun topic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topic = mapped
    }

    internal fun build(): EndpointKafkaSettingsArgs = EndpointKafkaSettingsArgs(
        broker = broker ?: throw PulumiNullFieldException("broker"),
        includeControlDetails = includeControlDetails,
        includeNullAndEmpty = includeNullAndEmpty,
        includePartitionValue = includePartitionValue,
        includeTableAlterOperations = includeTableAlterOperations,
        includeTransactionDetails = includeTransactionDetails,
        messageFormat = messageFormat,
        messageMaxBytes = messageMaxBytes,
        noHexPrefix = noHexPrefix,
        partitionIncludeSchemaTable = partitionIncludeSchemaTable,
        saslPassword = saslPassword,
        saslUsername = saslUsername,
        securityProtocol = securityProtocol,
        sslCaCertificateArn = sslCaCertificateArn,
        sslClientCertificateArn = sslClientCertificateArn,
        sslClientKeyArn = sslClientKeyArn,
        sslClientKeyPassword = sslClientKeyPassword,
        topic = topic,
    )
}
